/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.util;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.xwiki.shaded.apache.commons.lang.StringUtils;

public class IdGenerator {
    private static final BitSet ALLOWED;
    private static final char[] HEXDIGIT;
    private Set<String> generatedIds = new HashSet<String>();

    public String generateUniqueId(String text) {
        return this.generateUniqueId("I", text);
    }

    public String generateUniqueId(String prefix, String text) {
        if (StringUtils.isEmpty(prefix) || !StringUtils.isAlpha(prefix)) {
            throw new IllegalArgumentException("The prefix [" + prefix + "] should only contain alphanumerical characters and not be empty.");
        }
        String idPrefix = (prefix != null ? prefix : "") + this.normalizeId(text);
        int occurence = 0;
        String id = idPrefix;
        while (this.generatedIds.contains(id)) {
            id = idPrefix + "-" + ++occurence;
        }
        this.generatedIds.add(id);
        return id;
    }

    private String normalizeId(String stringToNormalize) {
        int len = stringToNormalize.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        for (int x = 0; x < len; ++x) {
            char c = stringToNormalize.charAt(x);
            if (ALLOWED.get(c)) {
                outBuffer.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            boolean skip = true;
            int nibble = c >> 12 & 0xF;
            if (nibble != 0) {
                skip = false;
                outBuffer.append(this.toHex(nibble));
            }
            nibble = c >> 8 & 0xF;
            if (!skip || nibble != 0) {
                skip = false;
                outBuffer.append(this.toHex(nibble));
            }
            nibble = c >> 4 & 0xF;
            if (!skip || nibble != 0) {
                outBuffer.append(this.toHex(nibble));
            }
            outBuffer.append(this.toHex(c & 0xF));
        }
        return outBuffer.toString();
    }

    private char toHex(int nibble) {
        return HEXDIGIT[nibble & 0xF];
    }

    public void remove(String id) {
        this.generatedIds.remove(id);
    }

    public void reset() {
        this.generatedIds.clear();
    }

    static {
        int i;
        ALLOWED = new BitSet(256);
        for (i = 48; i <= 57; ++i) {
            ALLOWED.set(i);
        }
        for (i = 97; i <= 122; ++i) {
            ALLOWED.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            ALLOWED.set(i);
        }
        ALLOWED.set(58);
        ALLOWED.set(95);
        ALLOWED.set(46);
        ALLOWED.set(45);
        HEXDIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

