/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.wikimodel.wem;

import java.util.Arrays;

public class WikiPageUtil {
    private static final char[] HTTP_RESERVED_SYMBOLS = new char[]{';', '/', '?', ':', '@', '&', '=', '+', '$', ','};
    private static final char[] HTTP_UNRESERVED_SYMBOLS = new char[]{'-', '_', '.', '!', '~', '*', '\'', '(', ')', '#'};

    public static String decodeHttpParams(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        char[] array = str.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            char ch = array[i];
            if (ch == '%') {
                if (i + 2 >= array.length) break;
                int val = array[++i] - 48;
                val <<= 4;
                ch = (char)(val |= array[++i] - 48);
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String encodeHttpParams(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        char[] array = str.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            char ch = array[i];
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || Character.isDigit(ch) || Arrays.binarySearch(HTTP_RESERVED_SYMBOLS, ch) >= 0 || Arrays.binarySearch(HTTP_UNRESERVED_SYMBOLS, ch) >= 0) {
                buf.append(array[i]);
                continue;
            }
            buf.append("%" + Integer.toHexString(array[i]));
        }
        return buf.toString();
    }

    public static String escapeXmlAttribute(String str) {
        return WikiPageUtil.escapeXmlString(str, true);
    }

    public static String escapeXmlString(String str) {
        return WikiPageUtil.escapeXmlString(str, false);
    }

    public static String escapeXmlString(String str, boolean escapeQuots) {
        if (str == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        char[] array = str.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == '>' || array[i] == '&' || array[i] == '<' || escapeQuots && (array[i] == '\'' || array[i] == '\"')) {
                buf.append("&#x" + Integer.toHexString(array[i]) + ";");
                continue;
            }
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String getCDATA(String text) {
        StringBuffer buf = new StringBuffer();
        buf.append("<![CDATA[");
        int startPos = 0;
        while (startPos >= 0 && startPos < text.length()) {
            int id = text.indexOf("]]>", startPos);
            if (id >= 0) {
                buf.append(text.substring(startPos, id));
                buf.append("]]]]><![CDATA[>");
                startPos += id + "]]>".length();
                continue;
            }
            buf.append(text.substring(startPos));
            startPos = -1;
        }
        buf.append("]]>");
        return buf.toString();
    }

    public static boolean isValidXmlChar(int ch) {
        return ch == 9 || ch == 10 || ch == 13 || ch >= 32 && ch <= 55295 || ch >= 57344 && ch <= 65533 || ch >= 65536 && ch <= 0x10FFFF;
    }

    public static boolean isValidXmlName(String tagName, boolean colonEnabled) {
        boolean valid = false;
        int len = tagName != null ? tagName.length() : 0;
        for (int i = 0; i < len; ++i) {
            char ch = tagName.charAt(i);
            valid = i == 0 ? WikiPageUtil.isValidXmlNameStartChar(ch, colonEnabled) : WikiPageUtil.isValidXmlNameChar(ch, colonEnabled);
            if (!valid) break;
        }
        return valid;
    }

    public static boolean isValidXmlNameChar(char ch, boolean colonEnabled) {
        return WikiPageUtil.isValidXmlNameStartChar(ch, colonEnabled) || ch == '-' || ch == '.' || ch >= '0' && ch <= '9' || ch == '\u00b7' || ch >= '\u0300' && ch <= '\u036f' || ch >= '\u203f' && ch <= '\u2040';
    }

    public static boolean isValidXmlNameStartChar(char ch, boolean colonEnabled) {
        if (ch == ':') {
            return colonEnabled;
        }
        return ch >= 'A' && ch <= 'Z' || ch == '_' || ch >= 'a' && ch <= 'z' || ch >= '\u00c0' && ch <= '\u00d6' || ch >= '\u00d8' && ch <= '\u00f6' || ch >= '\u00f8' && ch <= '\u02ff' || ch >= '\u0370' && ch <= '\u037d' || ch >= '\u037f' && ch <= '\u1fff' || ch >= '\u200c' && ch <= '\u200d' || ch >= '\u2070' && ch <= '\u218f' || ch >= '\u2c00' && ch <= '\u2fef' || ch >= '\u3001' && ch <= '\ud7ff' || ch >= '\uf900' && ch <= '\ufdcf' || ch >= '\ufdf0' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\ueffff';
    }

    static {
        Arrays.sort(HTTP_RESERVED_SYMBOLS);
        Arrays.sort(HTTP_UNRESERVED_SYMBOLS);
    }
}

