/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.wikimodel.wem.xhtml;

import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xwiki.shaded.wikimodel.wem.IWemListener;
import org.xwiki.shaded.wikimodel.wem.IWikiParser;
import org.xwiki.shaded.wikimodel.wem.WikiParserException;
import org.xwiki.shaded.wikimodel.wem.impl.WikiScannerContext;
import org.xwiki.shaded.wikimodel.wem.xhtml.filter.AccumulationXMLFilter;
import org.xwiki.shaded.wikimodel.wem.xhtml.filter.DTDXMLFilter;
import org.xwiki.shaded.wikimodel.wem.xhtml.filter.XHTMLWhitespaceXMLFilter;
import org.xwiki.shaded.wikimodel.wem.xhtml.handler.CommentHandler;
import org.xwiki.shaded.wikimodel.wem.xhtml.handler.TagHandler;
import org.xwiki.shaded.wikimodel.wem.xhtml.impl.LocalEntityResolver;
import org.xwiki.shaded.wikimodel.wem.xhtml.impl.XhtmlHandler;
import org.xwiki.shaded.xml.sax.InputSource;
import org.xwiki.shaded.xml.sax.XMLReader;
import org.xwiki.shaded.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XhtmlParser
implements IWikiParser {
    private Map<String, TagHandler> fExtraHandlers = Collections.emptyMap();
    private CommentHandler fCommentHandler = new CommentHandler();
    private XMLReader fXmlReader;

    public void setExtraHandlers(Map<String, TagHandler> extraHandlers) {
        this.fExtraHandlers = extraHandlers;
    }

    public void setCommentHandler(CommentHandler commentHandler) {
        this.fCommentHandler = commentHandler;
    }

    public void setXmlReader(XMLReader xmlReader) {
        this.fXmlReader = xmlReader;
    }

    public DefaultHandler getHandler(IWemListener listener) {
        WikiScannerContext context = new WikiScannerContext(listener);
        XhtmlHandler handler = new XhtmlHandler(context, this.fExtraHandlers, this.fCommentHandler);
        return handler;
    }

    @Override
    public void parse(Reader reader, IWemListener listener) throws WikiParserException {
        try {
            XMLReader xmlReader = this.getXMLReader();
            DefaultHandler handler = this.getHandler(listener);
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xmlReader.setEntityResolver(new LocalEntityResolver());
            xmlReader.setContentHandler(handler);
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            InputSource source = new InputSource(reader);
            xmlReader.parse(source);
        }
        catch (Exception e) {
            throw new WikiParserException(e);
        }
    }

    private XMLReader getXMLReader() throws Exception {
        XMLReader reader;
        if (this.fXmlReader != null) {
            reader = this.fXmlReader;
        } else {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            DTDXMLFilter dtdFilter = new DTDXMLFilter(xmlReader);
            AccumulationXMLFilter accumulationFilter = new AccumulationXMLFilter(dtdFilter);
            XHTMLWhitespaceXMLFilter whitespaceFilter = new XHTMLWhitespaceXMLFilter(accumulationFilter);
            reader = whitespaceFilter;
        }
        return reader;
    }
}

