/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.annotation;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.ComponentDependencyFactory;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.util.ReflectionUtils;

public class ComponentDescriptorFactory {
    private ServiceLoader<ComponentDependencyFactory> componentDependencyFactories = ServiceLoader.load(ComponentDependencyFactory.class);

    public List<ComponentDescriptor> createComponentDescriptors(Class<?> componentClass, Class<?> componentRoleClass) {
        Component component;
        ArrayList<ComponentDescriptor> descriptors = new ArrayList<ComponentDescriptor>();
        Named named = componentClass.getAnnotation(Named.class);
        String[] hints = named != null ? new String[]{named.value()} : ((component = componentClass.getAnnotation(Component.class)) != null && component.hints().length > 0 ? component.hints() : (component != null && component.value().trim().length() > 0 ? new String[]{component.value().trim()} : new String[]{"default"}));
        for (String hint : hints) {
            descriptors.add(this.createComponentDescriptor(componentClass, hint, componentRoleClass));
        }
        return descriptors;
    }

    private ComponentDescriptor createComponentDescriptor(Class<?> componentClass, String hint, Class<?> componentRoleClass) {
        Collection<Field> fields;
        DefaultComponentDescriptor descriptor = new DefaultComponentDescriptor();
        descriptor.setRole(componentRoleClass);
        descriptor.setImplementation(componentClass);
        descriptor.setRoleHint(hint);
        descriptor.setInstantiationStrategy(this.createComponentInstantiationStrategy(componentClass));
        try {
            fields = ReflectionUtils.getAllFields(componentClass);
        }
        catch (NoClassDefFoundError e) {
            throw new NoClassDefFoundError("Failed to load class [" + e.getMessage() + "] required by a field of component class [" + componentClass.getName() + "], hint [" + hint + "], role [" + componentRoleClass.getName() + "]");
        }
        for (Field field : fields) {
            ComponentDependency dependency = this.createComponentDependency(field);
            if (dependency == null) continue;
            descriptor.addComponentDependency(dependency);
        }
        return descriptor;
    }

    private ComponentInstantiationStrategy createComponentInstantiationStrategy(Class<?> componentClass) {
        InstantiationStrategy instantiationStrategy;
        Singleton singleton = componentClass.getAnnotation(Singleton.class);
        ComponentInstantiationStrategy strategy = singleton != null ? ComponentInstantiationStrategy.SINGLETON : ((instantiationStrategy = componentClass.getAnnotation(InstantiationStrategy.class)) != null ? instantiationStrategy.value() : ComponentInstantiationStrategy.SINGLETON);
        return strategy;
    }

    private ComponentDependency createComponentDependency(Field field) {
        ComponentDependencyFactory factory;
        ComponentDependency dependency = null;
        Iterator<ComponentDependencyFactory> i$ = this.componentDependencyFactories.iterator();
        while (i$.hasNext() && (dependency = (factory = i$.next()).createComponentDependency(field)) == null) {
        }
        return dependency;
    }
}

