/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal;

import java.util.Stack;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.event.ComponentDescriptorAddedEvent;
import org.xwiki.component.event.ComponentDescriptorRemovedEvent;
import org.xwiki.component.manager.ComponentEventManager;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

public class StackingComponentEventManager
implements ComponentEventManager {
    private ObservationManager observationManager;
    private Stack<ComponentEventEntry> events = new Stack();
    private boolean shouldStack = true;

    @Override
    public void notifyComponentRegistered(ComponentDescriptor<?> descriptor) {
        this.notifyComponentEvent(new ComponentDescriptorAddedEvent(descriptor.getRole(), descriptor.getRoleHint()), descriptor);
    }

    @Override
    public void notifyComponentUnregistered(ComponentDescriptor<?> descriptor) {
        this.notifyComponentEvent(new ComponentDescriptorRemovedEvent(descriptor.getRole(), descriptor.getRoleHint()), descriptor);
    }

    public synchronized void flushEvents() {
        for (ComponentEventEntry entry : this.events) {
            this.sendEvent(entry.event, entry.descriptor);
        }
    }

    public void shouldStack(boolean shouldStack) {
        this.shouldStack = shouldStack;
    }

    public void setObservationManager(ObservationManager observationManager) {
        this.observationManager = observationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyComponentEvent(Event event, ComponentDescriptor<?> descriptor) {
        if (this.shouldStack) {
            StackingComponentEventManager stackingComponentEventManager = this;
            synchronized (stackingComponentEventManager) {
                this.events.push(new ComponentEventEntry(event, descriptor));
            }
        } else {
            this.sendEvent(event, descriptor);
        }
    }

    private void sendEvent(Event event, ComponentDescriptor<?> descriptor) {
        if (this.observationManager != null) {
            this.observationManager.notify(event, this, descriptor);
        }
    }

    static class ComponentEventEntry {
        public Event event;
        public ComponentDescriptor<?> descriptor;

        public ComponentEventEntry(Event event, ComponentDescriptor<?> descriptor) {
            this.event = event;
            this.descriptor = descriptor;
        }
    }
}

