/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import org.xwiki.shaded.htmlcleaner.BaseToken;
import org.xwiki.shaded.htmlcleaner.Serializer;

public class DoctypeToken
implements BaseToken {
    private String part1;
    private String part2;
    private String part3;
    private String part4;

    public DoctypeToken(String part1, String part2, String part3, String part4) {
        this.part1 = part1 != null ? part1.toUpperCase() : part1;
        this.part2 = part2 != null ? part2.toUpperCase() : part2;
        this.part3 = this.clean(part3);
        this.part4 = this.clean(part4);
    }

    private String clean(String s) {
        if (s != null) {
            s = s.replace('>', ' ');
            s = s.replace('<', ' ');
            s = s.replace('&', ' ');
            s = s.replace('\'', ' ');
            s = s.replace('\"', ' ');
        }
        return s;
    }

    public boolean isValid() {
        if (this.part1 == null || "".equals(this.part1)) {
            return false;
        }
        if (!"public".equalsIgnoreCase(this.part2) && !"system".equalsIgnoreCase(this.part2)) {
            return false;
        }
        if ("system".equalsIgnoreCase(this.part2) && this.part4 != null && !"".equals(this.part4)) {
            return false;
        }
        return !"public".equalsIgnoreCase(this.part2) || this.part4 != null && !"".equals(this.part4);
    }

    public String getContent() {
        String result = "<!DOCTYPE " + this.part1 + " ";
        result = result + this.part2 + " \"" + this.part3 + "\"";
        if (this.part4 != null && !"".equals(this.part4)) {
            result = result + " \"" + this.part4 + "\"";
        }
        result = result + ">";
        return result;
    }

    public String toString() {
        return this.getContent();
    }

    public String getName() {
        return "";
    }

    public void serialize(Serializer serializer, Writer writer) throws IOException {
        writer.write(this.getContent() + "\n");
    }

    public String getPart1() {
        return this.part1;
    }

    public String getPart2() {
        return this.part2;
    }

    public String getPart3() {
        return this.part3;
    }

    public String getPart4() {
        return this.part4;
    }
}

