/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.htmlcleaner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.xwiki.shaded.htmlcleaner.BaseToken;
import org.xwiki.shaded.htmlcleaner.CleanerProperties;
import org.xwiki.shaded.htmlcleaner.CleanerTransformations;
import org.xwiki.shaded.htmlcleaner.ContentNode;
import org.xwiki.shaded.htmlcleaner.DefaultTagProvider;
import org.xwiki.shaded.htmlcleaner.EndTagToken;
import org.xwiki.shaded.htmlcleaner.HtmlCleanerException;
import org.xwiki.shaded.htmlcleaner.HtmlTokenizer;
import org.xwiki.shaded.htmlcleaner.ITagInfoProvider;
import org.xwiki.shaded.htmlcleaner.SimpleXmlSerializer;
import org.xwiki.shaded.htmlcleaner.TagInfo;
import org.xwiki.shaded.htmlcleaner.TagNode;
import org.xwiki.shaded.htmlcleaner.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlCleaner {
    public static final String DEFAULT_CHARSET = System.getProperty("file.encoding");
    private CleanerProperties properties;
    private ITagInfoProvider tagInfoProvider;
    private CleanerTransformations transformations = null;

    public HtmlCleaner() {
        this(null, null);
    }

    public HtmlCleaner(ITagInfoProvider tagInfoProvider) {
        this(tagInfoProvider, null);
    }

    public HtmlCleaner(CleanerProperties properties) {
        this(null, properties);
    }

    public HtmlCleaner(ITagInfoProvider tagInfoProvider, CleanerProperties properties) {
        this.tagInfoProvider = tagInfoProvider == null ? DefaultTagProvider.getInstance() : tagInfoProvider;
        this.properties = properties == null ? new CleanerProperties() : properties;
        this.properties.tagInfoProvider = this.tagInfoProvider;
    }

    public TagNode clean(String htmlContent) {
        try {
            return this.clean(new StringReader(htmlContent));
        }
        catch (IOException e) {
            throw new HtmlCleanerException(e);
        }
    }

    public TagNode clean(File file, String charset) throws IOException {
        FileInputStream in = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)in, charset);
        return this.clean(reader);
    }

    public TagNode clean(File file) throws IOException {
        return this.clean(file, DEFAULT_CHARSET);
    }

    public TagNode clean(URL url, String charset) throws IOException {
        URLConnection urlConnection = url.openConnection();
        if (charset == null) {
            charset = Utils.getCharsetFromContentTypeString(urlConnection.getHeaderField("Content-Type"));
        }
        if (charset == null) {
            charset = Utils.getCharsetFromContent(url);
        }
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        return this.clean(url.openStream(), charset);
    }

    public TagNode clean(URL url) throws IOException {
        return this.clean(url, null);
    }

    public TagNode clean(InputStream in, String charset) throws IOException {
        return this.clean(new InputStreamReader(in, charset));
    }

    public TagNode clean(InputStream in) throws IOException {
        return this.clean(in, DEFAULT_CHARSET);
    }

    public TagNode clean(Reader reader) throws IOException {
        return this.clean(reader, new CleanTimeValues());
    }

    public TagNode clean(Reader reader, final CleanTimeValues cleanTimeValues) throws IOException {
        cleanTimeValues._openTags = new OpenTags();
        cleanTimeValues._headOpened = false;
        cleanTimeValues._bodyOpened = false;
        cleanTimeValues._headTags.clear();
        cleanTimeValues.allTags.clear();
        this.setPruneTags(this.properties.pruneTags, cleanTimeValues);
        cleanTimeValues.htmlNode = this.createTagNode("html", cleanTimeValues);
        cleanTimeValues.bodyNode = this.createTagNode("body", cleanTimeValues);
        cleanTimeValues.headNode = this.createTagNode("head", cleanTimeValues);
        cleanTimeValues.rootNode = null;
        cleanTimeValues.htmlNode.addChild(cleanTimeValues.headNode);
        cleanTimeValues.htmlNode.addChild(cleanTimeValues.bodyNode);
        HtmlTokenizer htmlTokenizer = new HtmlTokenizer(reader, this.properties, this.transformations, this.tagInfoProvider){

            @Override
            void makeTree(List<BaseToken> tokenList) {
                HtmlCleaner.this.makeTree(tokenList, tokenList.listIterator(tokenList.size() - 1), cleanTimeValues);
            }

            @Override
            TagNode createTagNode(String name) {
                return HtmlCleaner.this.createTagNode(name, cleanTimeValues);
            }
        };
        htmlTokenizer.start();
        List<BaseToken> nodeList = htmlTokenizer.getTokenList();
        this.closeAll(nodeList, cleanTimeValues);
        this.createDocumentNodes(nodeList, cleanTimeValues);
        this.calculateRootNode(cleanTimeValues);
        if (cleanTimeValues.pruneNodeSet != null && !cleanTimeValues.pruneNodeSet.isEmpty()) {
            for (TagNode tagNode : cleanTimeValues.pruneNodeSet) {
                TagNode parent = tagNode.getParent();
                if (parent == null) continue;
                parent.removeChild(tagNode);
            }
        }
        cleanTimeValues.rootNode.setDocType(htmlTokenizer.getDocType());
        return cleanTimeValues.rootNode;
    }

    private TagNode createTagNode(String name, CleanTimeValues cleanTimeValues) {
        TagNode node = new TagNode(name);
        if (cleanTimeValues.pruneTagSet != null && name != null && cleanTimeValues.pruneTagSet.contains(name.toLowerCase())) {
            cleanTimeValues.pruneNodeSet.add(node);
        }
        return node;
    }

    private TagNode makeTagNodeCopy(TagNode tagNode, CleanTimeValues cleanTimeValues) {
        TagNode copy = tagNode.makeCopy();
        if (cleanTimeValues.pruneTagSet != null && cleanTimeValues.pruneTagSet.contains(tagNode.getName())) {
            cleanTimeValues.pruneNodeSet.add(copy);
        }
        return copy;
    }

    private void calculateRootNode(CleanTimeValues cleanTimeValues) {
        List bodyChildren;
        cleanTimeValues.rootNode = cleanTimeValues.htmlNode;
        if (this.properties.omitHtmlEnvelope && (bodyChildren = cleanTimeValues.bodyNode.getChildren()) != null) {
            for (Object child : bodyChildren) {
                if (!(child instanceof TagNode)) continue;
                cleanTimeValues.rootNode = (TagNode)child;
                break;
            }
        }
    }

    private void addAttributesToTag(TagNode tag, Map attributes) {
        if (attributes != null) {
            Map<String, String> tagAttributes = tag.getAttributes();
            for (Map.Entry currEntry : attributes.entrySet()) {
                String attName = (String)currEntry.getKey();
                if (tagAttributes.containsKey(attName)) continue;
                String attValue = (String)currEntry.getValue();
                tag.setAttribute(attName, attValue);
            }
        }
    }

    private boolean isFatalTagSatisfied(TagInfo tag, CleanTimeValues cleanTimeValues) {
        if (tag != null) {
            String fatalTagName = tag.getFatalTag();
            return fatalTagName == null ? true : cleanTimeValues._openTags.tagExists(fatalTagName);
        }
        return true;
    }

    private boolean mustAddRequiredParent(TagInfo tag, CleanTimeValues cleanTimeValues) {
        String requiredParent;
        if (tag != null && (requiredParent = tag.getRequiredParent()) != null) {
            TagPos tagPos;
            String fatalTag = tag.getFatalTag();
            int fatalTagPositon = -1;
            if (fatalTag != null && (tagPos = cleanTimeValues._openTags.findTag(fatalTag)) != null) {
                fatalTagPositon = tagPos.position;
            }
            ListIterator it = cleanTimeValues._openTags.list.listIterator(cleanTimeValues._openTags.list.size());
            while (it.hasPrevious()) {
                TagPos currTagPos = (TagPos)it.previous();
                if (!tag.isHigher(currTagPos.name)) continue;
                return currTagPos.position <= fatalTagPositon;
            }
            return true;
        }
        return false;
    }

    private TagNode createTagNode(TagNode startTagToken) {
        startTagToken.setFormed();
        return startTagToken;
    }

    private boolean isAllowedInLastOpenTag(BaseToken token, CleanTimeValues cleanTimeValues) {
        TagPos last = cleanTimeValues._openTags.getLastTagPos();
        if (last != null && last.info != null) {
            return last.info.allowsItem(token);
        }
        return true;
    }

    private void saveToLastOpenTag(List nodeList, BaseToken tokenToAdd, CleanTimeValues cleanTimeValues) {
        TagPos last = cleanTimeValues._openTags.getLastTagPos();
        if (last != null && last.info != null && last.info.isIgnorePermitted()) {
            return;
        }
        TagPos rubbishPos = cleanTimeValues._openTags.findTagToPlaceRubbish();
        if (rubbishPos != null) {
            TagNode startTagToken = (TagNode)nodeList.get(rubbishPos.position);
            startTagToken.addItemForMoving(tokenToAdd);
        }
    }

    private boolean isStartToken(Object o) {
        return o instanceof TagNode && !((TagNode)o).isFormed();
    }

    void makeTree(List<BaseToken> nodeList, ListIterator<BaseToken> nodeIterator, CleanTimeValues cleanTimeValues) {
        while (nodeIterator.hasNext()) {
            TagInfo tag;
            String tagName;
            BaseToken token = nodeIterator.next();
            if (token instanceof EndTagToken) {
                EndTagToken endTagToken = (EndTagToken)token;
                tagName = endTagToken.getName();
                tag = this.tagInfoProvider.getTagInfo(tagName);
                if (tag == null && this.properties.omitUnknownTags || tag != null && tag.isDeprecated() && this.properties.omitDeprecatedTags) {
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && !tag.allowsBody()) {
                    nodeIterator.set(null);
                    continue;
                }
                TagPos matchingPosition = cleanTimeValues._openTags.findTag(tagName);
                if (matchingPosition != null) {
                    List closed = this.closeSnippet(nodeList, matchingPosition, endTagToken, cleanTimeValues);
                    nodeIterator.set(null);
                    for (int i = closed.size() - 1; i >= 1; --i) {
                        TagNode closedTag = (TagNode)closed.get(i);
                        if (tag == null || !tag.isContinueAfter(closedTag.getName())) continue;
                        nodeIterator.add(this.makeTagNodeCopy(closedTag, cleanTimeValues));
                        nodeIterator.previous();
                    }
                    continue;
                }
                if (this.isAllowedInLastOpenTag(token, cleanTimeValues)) continue;
                this.saveToLastOpenTag(nodeList, token, cleanTimeValues);
                nodeIterator.set(null);
                continue;
            }
            if (this.isStartToken(token)) {
                TagNode startTagToken = (TagNode)token;
                tagName = startTagToken.getName();
                tag = this.tagInfoProvider.getTagInfo(tagName);
                TagPos lastTagPos = cleanTimeValues._openTags.isEmpty() ? null : cleanTimeValues._openTags.getLastTagPos();
                TagInfo lastTagInfo = lastTagPos == null ? null : this.tagInfoProvider.getTagInfo(lastTagPos.name);
                cleanTimeValues.allTags.add(tagName);
                if ("html".equals(tagName)) {
                    this.addAttributesToTag(cleanTimeValues.htmlNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if ("body".equals(tagName)) {
                    cleanTimeValues._bodyOpened = true;
                    this.addAttributesToTag(cleanTimeValues.bodyNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if ("head".equals(tagName)) {
                    cleanTimeValues._headOpened = true;
                    this.addAttributesToTag(cleanTimeValues.headNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if (tag == null && this.properties.omitUnknownTags || tag != null && tag.isDeprecated() && this.properties.omitDeprecatedTags) {
                    nodeIterator.set(null);
                    continue;
                }
                if (tag == null && lastTagInfo != null && !lastTagInfo.allowsAnything()) {
                    this.saveToLastOpenTag(nodeList, token, cleanTimeValues);
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && tag.hasPermittedTags() && cleanTimeValues._openTags.someAlreadyOpen(tag.getPermittedTags())) {
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && tag.isUnique() && cleanTimeValues._openTags.tagEncountered(tagName)) {
                    nodeIterator.set(null);
                    continue;
                }
                if (!this.isFatalTagSatisfied(tag, cleanTimeValues)) {
                    nodeIterator.set(null);
                    continue;
                }
                if (this.mustAddRequiredParent(tag, cleanTimeValues)) {
                    String requiredParent = tag.getRequiredParent();
                    TagNode requiredParentStartToken = this.createTagNode(requiredParent, cleanTimeValues);
                    nodeIterator.previous();
                    nodeIterator.add(requiredParentStartToken);
                    nodeIterator.previous();
                    continue;
                }
                if (tag != null && lastTagPos != null && tag.isMustCloseTag(lastTagInfo)) {
                    List closed = this.closeSnippet(nodeList, lastTagPos, startTagToken, cleanTimeValues);
                    int closedCount = closed.size();
                    if (tag.hasCopyTags() && closedCount > 0) {
                        TagNode currStartToken;
                        ListIterator closedIt = closed.listIterator(closedCount);
                        ArrayList<TagNode> toBeCopied = new ArrayList<TagNode>();
                        while (closedIt.hasPrevious() && tag.isCopy((currStartToken = (TagNode)closedIt.previous()).getName())) {
                            toBeCopied.add(0, currStartToken);
                        }
                        if (toBeCopied.size() > 0) {
                            for (TagNode currStartToken2 : toBeCopied) {
                                nodeIterator.add(this.makeTagNodeCopy(currStartToken2, cleanTimeValues));
                            }
                            for (int i = 0; i < toBeCopied.size(); ++i) {
                                nodeIterator.previous();
                            }
                        }
                    }
                    nodeIterator.previous();
                    continue;
                }
                if (!this.isAllowedInLastOpenTag(token, cleanTimeValues)) {
                    this.saveToLastOpenTag(nodeList, token, cleanTimeValues);
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && !tag.allowsBody()) {
                    TagNode newTagNode = this.createTagNode(startTagToken);
                    this.addPossibleHeadCandidate(tag, newTagNode, cleanTimeValues);
                    nodeIterator.set(newTagNode);
                    continue;
                }
                cleanTimeValues._openTags.addTag(tagName, nodeIterator.previousIndex());
                continue;
            }
            if (this.isAllowedInLastOpenTag(token, cleanTimeValues)) continue;
            this.saveToLastOpenTag(nodeList, token, cleanTimeValues);
            nodeIterator.set(null);
        }
    }

    private void createDocumentNodes(List listNodes, CleanTimeValues cleanTimeValues) {
        for (Object child : listNodes) {
            if (child == null) continue;
            boolean toAdd = true;
            if (child instanceof TagNode) {
                TagNode node = (TagNode)child;
                TagInfo tag = this.tagInfoProvider.getTagInfo(node.getName());
                this.addPossibleHeadCandidate(tag, node, cleanTimeValues);
            } else if (child instanceof ContentNode) {
                boolean bl = toAdd = !"".equals(child.toString());
            }
            if (!toAdd) continue;
            cleanTimeValues.bodyNode.addChild(child);
        }
        for (TagNode headCandidateNode : cleanTimeValues._headTags) {
            boolean toMove = true;
            for (TagNode parent = headCandidateNode.getParent(); parent != null; parent = parent.getParent()) {
                if (!cleanTimeValues._headTags.contains(parent)) continue;
                toMove = false;
                break;
            }
            if (!toMove) continue;
            headCandidateNode.removeFromTree();
            cleanTimeValues.headNode.addChild(headCandidateNode);
        }
    }

    private List closeSnippet(List nodeList, TagPos tagPos, Object toNode, CleanTimeValues cleanTimeValues) {
        ArrayList<TagNode> closed = new ArrayList<TagNode>();
        ListIterator<Object> it = nodeList.listIterator(tagPos.position);
        TagNode tagNode = null;
        Object item = it.next();
        boolean isListEnd = false;
        while (toNode == null && !isListEnd || toNode != null && item != toNode) {
            if (this.isStartToken(item)) {
                TagNode startTagToken = (TagNode)item;
                closed.add(startTagToken);
                List<BaseToken> itemsToMove = startTagToken.getItemsToMove();
                if (itemsToMove != null) {
                    OpenTags prevOpenTags = cleanTimeValues._openTags;
                    cleanTimeValues._openTags = new OpenTags();
                    this.makeTree(itemsToMove, itemsToMove.listIterator(0), cleanTimeValues);
                    this.closeAll(itemsToMove, cleanTimeValues);
                    startTagToken.setItemsToMove(null);
                    cleanTimeValues._openTags = prevOpenTags;
                }
                TagNode newTagNode = this.createTagNode(startTagToken);
                TagInfo tag = this.tagInfoProvider.getTagInfo(newTagNode.getName());
                this.addPossibleHeadCandidate(tag, newTagNode, cleanTimeValues);
                if (tagNode != null) {
                    tagNode.addChildren(itemsToMove);
                    tagNode.addChild(newTagNode);
                    it.set(null);
                } else if (itemsToMove != null) {
                    itemsToMove.add(newTagNode);
                    it.set(itemsToMove);
                } else {
                    it.set(newTagNode);
                }
                cleanTimeValues._openTags.removeTag(newTagNode.getName());
                tagNode = newTagNode;
            } else if (tagNode != null) {
                it.set(null);
                if (item != null) {
                    tagNode.addChild(item);
                }
            }
            if (it.hasNext()) {
                item = it.next();
                continue;
            }
            isListEnd = true;
        }
        return closed;
    }

    private void closeAll(List<BaseToken> nodeList, CleanTimeValues cleanTimeValues) {
        TagPos firstTagPos = cleanTimeValues._openTags.findFirstTagPos();
        if (firstTagPos != null) {
            this.closeSnippet(nodeList, firstTagPos, null, cleanTimeValues);
        }
    }

    private void addPossibleHeadCandidate(TagInfo tagInfo, TagNode tagNode, CleanTimeValues cleanTimeValues) {
        if (tagInfo != null && tagNode != null && (tagInfo.isHeadTag() || tagInfo.isHeadAndBodyTag() && cleanTimeValues._headOpened && !cleanTimeValues._bodyOpened)) {
            cleanTimeValues._headTags.add(tagNode);
        }
    }

    public CleanerProperties getProperties() {
        return this.properties;
    }

    private void setPruneTags(String pruneTags, CleanTimeValues cleanTimeValues) {
        cleanTimeValues.pruneTagSet.clear();
        cleanTimeValues.pruneNodeSet.clear();
        if (pruneTags != null) {
            StringTokenizer tokenizer = new StringTokenizer(pruneTags, ",");
            while (tokenizer.hasMoreTokens()) {
                cleanTimeValues.pruneTagSet.add(tokenizer.nextToken().trim().toLowerCase());
            }
        }
    }

    public ITagInfoProvider getTagInfoProvider() {
        return this.tagInfoProvider;
    }

    public CleanerTransformations getTransformations() {
        return this.transformations;
    }

    public void setTransformations(CleanerTransformations transformations) {
        this.transformations = transformations;
    }

    public String getInnerHtml(TagNode node) {
        if (node != null) {
            try {
                String content = new SimpleXmlSerializer(this.properties).getAsString(node);
                int index1 = content.indexOf("<" + node.getName());
                index1 = content.indexOf(62, index1 + 1);
                int index2 = content.lastIndexOf(60);
                return index1 >= 0 && index1 <= index2 ? content.substring(index1 + 1, index2) : null;
            }
            catch (IOException e) {
                throw new HtmlCleanerException(e);
            }
        }
        throw new HtmlCleanerException("Cannot return inner html of the null node!");
    }

    public void setInnerHtml(TagNode node, String content) {
        if (node != null) {
            String nodeName = node.getName();
            StringBuilder html = new StringBuilder();
            html.append("<" + nodeName + " marker=''>");
            html.append(content);
            html.append("</" + nodeName + ">");
            for (TagNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                String parentName = parent.getName();
                html.insert(0, "<" + parentName + ">");
                html.append("</" + parentName + ">");
            }
            TagNode rootNode = this.clean(html.toString());
            TagNode cleanedNode = rootNode.findElementHavingAttribute("marker", true);
            if (cleanedNode != null) {
                node.setChildren(cleanedNode.getChildren());
            }
        }
    }

    private class CleanTimeValues {
        private OpenTags _openTags;
        private boolean _headOpened = false;
        private boolean _bodyOpened = false;
        private Set _headTags = new LinkedHashSet();
        private Set allTags = new TreeSet();
        private TagNode htmlNode;
        private TagNode bodyNode;
        private TagNode headNode;
        private TagNode rootNode;
        private Set<String> pruneTagSet = new HashSet<String>();
        private Set<TagNode> pruneNodeSet = new HashSet<TagNode>();

        private CleanTimeValues() {
        }
    }

    private class OpenTags {
        private List<TagPos> list = new ArrayList<TagPos>();
        private TagPos last = null;
        private Set<String> set = new HashSet<String>();

        private OpenTags() {
        }

        private boolean isEmpty() {
            return this.list.isEmpty();
        }

        private void addTag(String tagName, int position) {
            this.last = new TagPos(position, tagName);
            this.list.add(this.last);
            this.set.add(tagName);
        }

        private void removeTag(String tagName) {
            ListIterator<TagPos> it = this.list.listIterator(this.list.size());
            while (it.hasPrevious()) {
                TagPos currTagPos = it.previous();
                if (!tagName.equals(currTagPos.name)) continue;
                it.remove();
                break;
            }
            this.last = this.list.isEmpty() ? null : this.list.get(this.list.size() - 1);
        }

        private TagPos findFirstTagPos() {
            return this.list.isEmpty() ? null : this.list.get(0);
        }

        private TagPos getLastTagPos() {
            return this.last;
        }

        private TagPos findTag(String tagName) {
            if (tagName != null) {
                ListIterator<TagPos> it = this.list.listIterator(this.list.size());
                String fatalTag = null;
                TagInfo fatalInfo = HtmlCleaner.this.tagInfoProvider.getTagInfo(tagName);
                if (fatalInfo != null) {
                    fatalTag = fatalInfo.getFatalTag();
                }
                while (it.hasPrevious()) {
                    TagPos currTagPos = it.previous();
                    if (tagName.equals(currTagPos.name)) {
                        return currTagPos;
                    }
                    if (fatalTag == null || !fatalTag.equals(currTagPos.name)) continue;
                    return null;
                }
            }
            return null;
        }

        private boolean tagExists(String tagName) {
            TagPos tagPos = this.findTag(tagName);
            return tagPos != null;
        }

        private TagPos findTagToPlaceRubbish() {
            TagPos result = null;
            TagPos prev = null;
            if (!this.isEmpty()) {
                ListIterator<TagPos> it = this.list.listIterator(this.list.size());
                while (it.hasPrevious()) {
                    result = it.previous();
                    if ((result.info == null || result.info.allowsAnything()) && prev != null) {
                        return prev;
                    }
                    prev = result;
                }
            }
            return result;
        }

        private boolean tagEncountered(String tagName) {
            return this.set.contains(tagName);
        }

        private boolean someAlreadyOpen(Set tags) {
            for (TagPos curr : this.list) {
                if (!tags.contains(curr.name)) continue;
                return true;
            }
            return false;
        }
    }

    private class TagPos {
        private int position;
        private String name;
        private TagInfo info;

        TagPos(int position, String name) {
            this.position = position;
            this.name = name;
            this.info = HtmlCleaner.this.tagInfoProvider.getTagInfo(name);
        }
    }
}

