/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.htmlcleaner;

import java.util.List;
import java.util.Map;
import org.xwiki.shaded.htmlcleaner.CleanerProperties;
import org.xwiki.shaded.htmlcleaner.CommentNode;
import org.xwiki.shaded.htmlcleaner.ContentNode;
import org.xwiki.shaded.htmlcleaner.TagNode;
import org.xwiki.shaded.htmlcleaner.Utils;
import org.xwiki.shaded.jdom.Comment;
import org.xwiki.shaded.jdom.DefaultJDOMFactory;
import org.xwiki.shaded.jdom.Document;
import org.xwiki.shaded.jdom.Element;
import org.xwiki.shaded.jdom.Namespace;
import org.xwiki.shaded.jdom.Text;

public class JDomSerializer {
    private DefaultJDOMFactory factory;
    protected CleanerProperties props;
    protected boolean escapeXml = true;

    public JDomSerializer(CleanerProperties props, boolean escapeXml) {
        this.props = props;
        this.escapeXml = escapeXml;
    }

    public JDomSerializer(CleanerProperties props) {
        this(props, true);
    }

    public Document createJDom(TagNode rootNode) {
        this.factory = new DefaultJDOMFactory();
        Element rootElement = this.createElement(rootNode);
        Document document = this.factory.document(rootElement);
        this.setAttributes(rootNode, rootElement);
        this.createSubnodes(rootElement, rootNode.getChildren());
        return document;
    }

    private Element createElement(TagNode node) {
        Element element;
        String name = node.getName();
        boolean nsAware = this.props.isNamespacesAware();
        String prefix = Utils.getXmlNSPrefix(name);
        Map<String, String> nsDeclarations = node.getNamespaceDeclarations();
        String nsURI = null;
        if (prefix != null) {
            name = Utils.getXmlName(name);
            if (nsAware) {
                if (nsDeclarations != null) {
                    nsURI = nsDeclarations.get(prefix);
                }
                if (nsURI == null) {
                    nsURI = node.getNamespaceURIOnPath(prefix);
                }
                if (nsURI == null) {
                    nsURI = prefix;
                }
            }
        } else if (nsAware) {
            if (nsDeclarations != null) {
                nsURI = nsDeclarations.get("");
            }
            if (nsURI == null) {
                nsURI = node.getNamespaceURIOnPath(prefix);
            }
        }
        if (nsAware && nsURI != null) {
            Namespace ns = prefix == null ? Namespace.getNamespace(nsURI) : Namespace.getNamespace(prefix, nsURI);
            element = this.factory.element(name, ns);
        } else {
            element = this.factory.element(name);
        }
        if (nsAware) {
            this.defineNamespaceDeclarations(node, element);
        }
        return element;
    }

    private void defineNamespaceDeclarations(TagNode node, Element element) {
        Map<String, String> nsDeclarations = node.getNamespaceDeclarations();
        if (nsDeclarations != null) {
            for (Map.Entry<String, String> nsEntry : nsDeclarations.entrySet()) {
                String nsPrefix = nsEntry.getKey();
                String nsURI = nsEntry.getValue();
                Namespace ns = nsPrefix == null || "".equals(nsPrefix) ? Namespace.getNamespace(nsURI) : Namespace.getNamespace(nsPrefix, nsURI);
                element.addNamespaceDeclaration(ns);
            }
        }
    }

    private void setAttributes(TagNode node, Element element) {
        for (Map.Entry<String, String> entry : node.getAttributes().entrySet()) {
            String attrName = entry.getKey();
            String attrValue = entry.getValue();
            if (this.escapeXml) {
                attrValue = Utils.escapeXml(attrValue, this.props, true);
            }
            String attPrefix = Utils.getXmlNSPrefix(attrName);
            Namespace ns = null;
            if (attPrefix != null) {
                attrName = Utils.getXmlName(attrName);
                if (this.props.isNamespacesAware()) {
                    String nsURI = node.getNamespaceURIOnPath(attPrefix);
                    if (nsURI == null) {
                        nsURI = attPrefix;
                    }
                    ns = Namespace.getNamespace(attPrefix, nsURI);
                }
            }
            if (ns == null) {
                element.setAttribute(attrName, attrValue);
                continue;
            }
            element.setAttribute(attrName, attrValue, ns);
        }
    }

    private void createSubnodes(Element element, List tagChildren) {
        if (tagChildren != null) {
            for (Object item : tagChildren) {
                if (item instanceof CommentNode) {
                    CommentNode commentNode = (CommentNode)item;
                    Comment comment = this.factory.comment(commentNode.getContent().toString());
                    element.addContent(comment);
                    continue;
                }
                if (item instanceof ContentNode) {
                    boolean specialCase;
                    String nodeName = element.getName();
                    String content = item.toString();
                    boolean bl = specialCase = this.props.isUseCdataForScriptAndStyle() && ("script".equalsIgnoreCase(nodeName) || "style".equalsIgnoreCase(nodeName));
                    if (this.escapeXml && !specialCase) {
                        content = Utils.escapeXml(content, this.props, true);
                    }
                    Text text = specialCase ? this.factory.cdata(content) : this.factory.text(content);
                    element.addContent(text);
                    continue;
                }
                if (item instanceof TagNode) {
                    TagNode subTagNode = (TagNode)item;
                    Element subelement = this.createElement(subTagNode);
                    this.setAttributes(subTagNode, subelement);
                    this.createSubnodes(subelement, subTagNode.getChildren());
                    element.addContent(subelement);
                    continue;
                }
                if (!(item instanceof List)) continue;
                List sublist = (List)item;
                this.createSubnodes(element, sublist);
            }
        }
    }
}

