/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.xwiki.shaded.htmlcleaner.BaseToken;
import org.xwiki.shaded.htmlcleaner.CommentNode;
import org.xwiki.shaded.htmlcleaner.ContentNode;
import org.xwiki.shaded.htmlcleaner.DoctypeToken;
import org.xwiki.shaded.htmlcleaner.HtmlNode;
import org.xwiki.shaded.htmlcleaner.Serializer;
import org.xwiki.shaded.htmlcleaner.TagNodeVisitor;
import org.xwiki.shaded.htmlcleaner.TagToken;
import org.xwiki.shaded.htmlcleaner.TagTransformation;
import org.xwiki.shaded.htmlcleaner.Utils;
import org.xwiki.shaded.htmlcleaner.XPather;
import org.xwiki.shaded.htmlcleaner.XPatherException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagNode
extends TagToken
implements HtmlNode {
    private TagNode parent = null;
    private Map<String, String> attributes = new LinkedHashMap<String, String>();
    private List children = new ArrayList();
    private DoctypeToken docType = null;
    private Map<String, String> nsDeclarations = null;
    private List<BaseToken> itemsToMove = null;
    private transient boolean isFormed = false;

    public TagNode(String name) {
        super(name == null ? null : name.toLowerCase());
    }

    public boolean setName(String name) {
        if (Utils.isValidXmlIdentifier(name)) {
            this.name = name;
            return true;
        }
        return false;
    }

    public String getAttributeByName(String attName) {
        return attName != null ? this.attributes.get(attName.toLowerCase()) : null;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String attName) {
        return attName != null ? this.attributes.containsKey(attName.toLowerCase()) : false;
    }

    @Deprecated
    public void addAttribute(String attName, String attValue) {
        this.setAttribute(attName, attValue);
    }

    @Override
    public void setAttribute(String attName, String attValue) {
        if (attName != null && !"".equals(attName.trim())) {
            if ("xmlns".equals(attName = attName.toLowerCase())) {
                this.addNamespaceDeclaration("", attValue);
            } else if (attName.startsWith("xmlns:")) {
                this.addNamespaceDeclaration(attName.substring(6), attValue);
            } else {
                this.attributes.put(attName, attValue == null ? "" : attValue);
            }
        }
    }

    public void addNamespaceDeclaration(String nsPrefix, String nsURI) {
        if (this.nsDeclarations == null) {
            this.nsDeclarations = new TreeMap<String, String>();
        }
        this.nsDeclarations.put(nsPrefix, nsURI);
    }

    public Map<String, String> getNamespaceDeclarations() {
        return this.nsDeclarations;
    }

    public void removeAttribute(String attName) {
        if (attName != null && !"".equals(attName.trim())) {
            this.attributes.remove(attName.toLowerCase());
        }
    }

    public List getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    void setChildren(List children) {
        this.children = children;
    }

    public List getChildTagList() {
        ArrayList childTagList = new ArrayList();
        for (int i = 0; i < this.children.size(); ++i) {
            Object item = this.children.get(i);
            if (!(item instanceof TagNode)) continue;
            childTagList.add(item);
        }
        return childTagList;
    }

    public TagNode[] getChildTags() {
        List childTagList = this.getChildTagList();
        TagNode[] childrenArray = new TagNode[childTagList.size()];
        for (int i = 0; i < childTagList.size(); ++i) {
            childrenArray[i] = (TagNode)childTagList.get(i);
        }
        return childrenArray;
    }

    public StringBuffer getText() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.children.size(); ++i) {
            Object item = this.children.get(i);
            if (item instanceof ContentNode) {
                text.append(item.toString());
                continue;
            }
            if (!(item instanceof TagNode)) continue;
            StringBuffer subtext = ((TagNode)item).getText();
            text.append(subtext);
        }
        return text;
    }

    public TagNode getParent() {
        return this.parent;
    }

    public DoctypeToken getDocType() {
        return this.docType;
    }

    public void setDocType(DoctypeToken docType) {
        this.docType = docType;
    }

    public void addChild(Object child) {
        if (child == null) {
            return;
        }
        if (child instanceof List) {
            this.addChildren((List)child);
        } else {
            this.children.add(child);
            if (child instanceof TagNode) {
                TagNode childTagNode = (TagNode)child;
                childTagNode.parent = this;
            }
        }
    }

    public void addChildren(List newChildren) {
        if (newChildren != null) {
            for (Object child : newChildren) {
                this.addChild(child);
            }
        }
    }

    private TagNode findElement(ITagNodeCondition condition, boolean isRecursive) {
        if (condition == null) {
            return null;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            TagNode inner;
            Object item = this.children.get(i);
            if (!(item instanceof TagNode)) continue;
            TagNode currNode = (TagNode)item;
            if (condition.satisfy(currNode)) {
                return currNode;
            }
            if (!isRecursive || (inner = currNode.findElement(condition, isRecursive)) == null) continue;
            return inner;
        }
        return null;
    }

    private List getElementList(ITagNodeCondition condition, boolean isRecursive) {
        LinkedList<TagNode> result = new LinkedList<TagNode>();
        if (condition == null) {
            return result;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            List innerList;
            Object item = this.children.get(i);
            if (!(item instanceof TagNode)) continue;
            TagNode currNode = (TagNode)item;
            if (condition.satisfy(currNode)) {
                result.add(currNode);
            }
            if (!isRecursive || (innerList = currNode.getElementList(condition, isRecursive)) == null || innerList.size() <= 0) continue;
            result.addAll(innerList);
        }
        return result;
    }

    private TagNode[] getElements(ITagNodeCondition condition, boolean isRecursive) {
        List list = this.getElementList(condition, isRecursive);
        TagNode[] array = new TagNode[list == null ? 0 : list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = (TagNode)list.get(i);
        }
        return array;
    }

    public List getAllElementsList(boolean isRecursive) {
        return this.getElementList(new TagAllCondition(), isRecursive);
    }

    public TagNode[] getAllElements(boolean isRecursive) {
        return this.getElements(new TagAllCondition(), isRecursive);
    }

    public TagNode findElementByName(String findName, boolean isRecursive) {
        return this.findElement(new TagNodeNameCondition(findName), isRecursive);
    }

    public List getElementListByName(String findName, boolean isRecursive) {
        return this.getElementList(new TagNodeNameCondition(findName), isRecursive);
    }

    public TagNode[] getElementsByName(String findName, boolean isRecursive) {
        return this.getElements(new TagNodeNameCondition(findName), isRecursive);
    }

    public TagNode findElementHavingAttribute(String attName, boolean isRecursive) {
        return this.findElement(new TagNodeAttExistsCondition(attName), isRecursive);
    }

    public List getElementListHavingAttribute(String attName, boolean isRecursive) {
        return this.getElementList(new TagNodeAttExistsCondition(attName), isRecursive);
    }

    public TagNode[] getElementsHavingAttribute(String attName, boolean isRecursive) {
        return this.getElements(new TagNodeAttExistsCondition(attName), isRecursive);
    }

    public TagNode findElementByAttValue(String attName, String attValue, boolean isRecursive, boolean isCaseSensitive) {
        return this.findElement(new TagNodeAttValueCondition(attName, attValue, isCaseSensitive), isRecursive);
    }

    public List getElementListByAttValue(String attName, String attValue, boolean isRecursive, boolean isCaseSensitive) {
        return this.getElementList(new TagNodeAttValueCondition(attName, attValue, isCaseSensitive), isRecursive);
    }

    public TagNode[] getElementsByAttValue(String attName, String attValue, boolean isRecursive, boolean isCaseSensitive) {
        return this.getElements(new TagNodeAttValueCondition(attName, attValue, isCaseSensitive), isRecursive);
    }

    public Object[] evaluateXPath(String xPathExpression) throws XPatherException {
        return new XPather(xPathExpression).evaluateAgainstNode(this);
    }

    public boolean removeFromTree() {
        if (this.parent != null) {
            boolean existed = this.parent.removeChild(this);
            this.parent = null;
            return existed;
        }
        return false;
    }

    public boolean removeChild(Object child) {
        return this.children.remove(child);
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    public void replaceChild(HtmlNode childToReplace, HtmlNode replacement) {
        if (replacement == null) {
            return;
        }
        ListIterator<HtmlNode> it = this.children.listIterator();
        while (it.hasNext()) {
            Object curr = it.next();
            if (curr != childToReplace) continue;
            it.set(replacement);
            break;
        }
    }

    public int getChildIndex(HtmlNode child) {
        int index = 0;
        for (Object curr : this.children) {
            if (curr == child) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void insertChild(int index, HtmlNode childToAdd) {
        this.children.add(index, childToAdd);
    }

    public void insertChildBefore(HtmlNode node, HtmlNode nodeToInsert) {
        int index = this.getChildIndex(node);
        if (index >= 0) {
            this.insertChild(index, nodeToInsert);
        }
    }

    public void insertChildAfter(HtmlNode node, HtmlNode nodeToInsert) {
        int index = this.getChildIndex(node);
        if (index >= 0) {
            this.insertChild(index + 1, nodeToInsert);
        }
    }

    void addItemForMoving(BaseToken item) {
        if (this.itemsToMove == null) {
            this.itemsToMove = new ArrayList<BaseToken>();
        }
        this.itemsToMove.add(item);
    }

    List<BaseToken> getItemsToMove() {
        return this.itemsToMove;
    }

    void setItemsToMove(List<BaseToken> itemsToMove) {
        this.itemsToMove = itemsToMove;
    }

    boolean isFormed() {
        return this.isFormed;
    }

    void setFormed(boolean isFormed) {
        this.isFormed = isFormed;
    }

    void setFormed() {
        this.setFormed(true);
    }

    void transformAttributes(TagTransformation tagTrans) {
        boolean isPreserveSourceAtts = tagTrans.isPreserveSourceAttributes();
        boolean hasAttTransforms = tagTrans.hasAttributeTransformations();
        if (hasAttTransforms || !isPreserveSourceAtts) {
            LinkedHashMap<String, String> newAttributes;
            LinkedHashMap<String, String> linkedHashMap = newAttributes = isPreserveSourceAtts ? new LinkedHashMap<String, String>(this.attributes) : new LinkedHashMap();
            if (hasAttTransforms) {
                Map map = tagTrans.getAttributeTransformations();
                for (Map.Entry entry : map.entrySet()) {
                    String attName = (String)entry.getKey();
                    String template = (String)entry.getValue();
                    if (template == null) {
                        newAttributes.remove(attName);
                        continue;
                    }
                    String attValue = Utils.evaluateTemplate(template, this.attributes);
                    newAttributes.put(attName, attValue);
                }
            }
            this.attributes = newAttributes;
        }
    }

    public void traverse(TagNodeVisitor visitor) {
        this.traverseInternally(visitor);
    }

    private boolean traverseInternally(TagNodeVisitor visitor) {
        if (visitor != null) {
            boolean hasParent = this.parent != null;
            boolean toContinue = visitor.visit(this.parent, this);
            if (!toContinue) {
                return false;
            }
            if (hasParent && this.parent == null) {
                return true;
            }
            for (Object child : this.children.toArray()) {
                if (child instanceof TagNode) {
                    toContinue = ((TagNode)child).traverseInternally(visitor);
                } else if (child instanceof ContentNode) {
                    toContinue = visitor.visit(this, (ContentNode)child);
                } else if (child instanceof CommentNode) {
                    toContinue = visitor.visit(this, (CommentNode)child);
                }
                if (toContinue) continue;
                return false;
            }
        }
        return true;
    }

    void collectNamespacePrefixesOnPath(Set<String> prefixes) {
        Map<String, String> nsDeclarations = this.getNamespaceDeclarations();
        if (nsDeclarations != null) {
            for (String prefix : nsDeclarations.keySet()) {
                prefixes.add(prefix);
            }
        }
        if (this.parent != null) {
            this.parent.collectNamespacePrefixesOnPath(prefixes);
        }
    }

    String getNamespaceURIOnPath(String nsPrefix) {
        if (this.nsDeclarations != null) {
            for (Map.Entry<String, String> nsEntry : this.nsDeclarations.entrySet()) {
                String currName = nsEntry.getKey();
                if (!currName.equals(nsPrefix) && (!"".equals(currName) || nsPrefix != null)) continue;
                return nsEntry.getValue();
            }
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURIOnPath(nsPrefix);
        }
        return null;
    }

    @Override
    public void serialize(Serializer serializer, Writer writer) throws IOException {
        serializer.serialize(this, writer);
    }

    TagNode makeCopy() {
        TagNode copy = new TagNode(this.name);
        copy.attributes.putAll(this.attributes);
        return copy;
    }

    public class TagNodeAttValueCondition
    implements ITagNodeCondition {
        private String attName;
        private String attValue;
        private boolean isCaseSensitive;

        public TagNodeAttValueCondition(String attName, String attValue, boolean isCaseSensitive) {
            this.attName = attName;
            this.attValue = attValue;
            this.isCaseSensitive = isCaseSensitive;
        }

        public boolean satisfy(TagNode tagNode) {
            if (tagNode == null || this.attName == null || this.attValue == null) {
                return false;
            }
            return this.isCaseSensitive ? this.attValue.equals(tagNode.getAttributeByName(this.attName)) : this.attValue.equalsIgnoreCase(tagNode.getAttributeByName(this.attName));
        }
    }

    public class TagNodeAttExistsCondition
    implements ITagNodeCondition {
        private String attName;

        public TagNodeAttExistsCondition(String attName) {
            this.attName = attName;
        }

        public boolean satisfy(TagNode tagNode) {
            return tagNode == null ? false : tagNode.attributes.containsKey(this.attName.toLowerCase());
        }
    }

    public class TagNodeNameCondition
    implements ITagNodeCondition {
        private String name;

        public TagNodeNameCondition(String name) {
            this.name = name;
        }

        public boolean satisfy(TagNode tagNode) {
            return tagNode == null ? false : tagNode.name.equalsIgnoreCase(this.name);
        }
    }

    public class TagAllCondition
    implements ITagNodeCondition {
        public boolean satisfy(TagNode tagNode) {
            return true;
        }
    }

    public static interface ITagNodeCondition {
        public boolean satisfy(TagNode var1);
    }
}

