/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.htmlcleaner;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xwiki.shaded.htmlcleaner.CleanerProperties;
import org.xwiki.shaded.htmlcleaner.CleanerTransformations;
import org.xwiki.shaded.htmlcleaner.SpecialEntity;
import org.xwiki.shaded.htmlcleaner.TagTransformation;

public class Utils {
    public static String VAR_START = "${";
    public static String VAR_END = "}";
    public static final Map<Character, String> RESERVED_XML_CHARS = new HashMap<Character, String>();

    public static String ltrim(String s) {
        int index;
        if (s == null) {
            return null;
        }
        int len = s.length();
        for (index = 0; index < len && Character.isWhitespace(s.charAt(index)); ++index) {
        }
        return index >= len ? "" : s.substring(index);
    }

    public static String rtrim(String s) {
        int len;
        int index;
        if (s == null) {
            return null;
        }
        for (index = len = s.length(); index > 0 && Character.isWhitespace(s.charAt(index - 1)); --index) {
        }
        return index <= 0 ? "" : s.substring(0, index);
    }

    public static String getCharsetFromContentTypeString(String contentType) {
        String charset;
        String pattern;
        Matcher matcher;
        if (contentType != null && (matcher = Pattern.compile(pattern = "charset=([a-z\\d\\-]*)", 2).matcher(contentType)).find() && Charset.isSupported(charset = matcher.group(1))) {
            return charset;
        }
        return null;
    }

    public static String getCharsetFromContent(URL url) throws IOException {
        byte[] chunk;
        InputStream stream = url.openStream();
        int bytesRead = stream.read(chunk = new byte[2048]);
        if (bytesRead > 0) {
            String charset;
            String startContent = new String(chunk);
            String pattern = "\\<meta\\s*http-equiv=[\\\"\\']content-type[\\\"\\']\\s*content\\s*=\\s*[\"']text/html\\s*;\\s*charset=([a-z\\d\\-]*)[\\\"\\'\\>]";
            Matcher matcher = Pattern.compile(pattern, 2).matcher(startContent);
            if (matcher.find() && Charset.isSupported(charset = matcher.group(1))) {
                return charset;
            }
        }
        return null;
    }

    public static boolean isHexadecimalDigit(char ch) {
        return Character.isDigit(ch) || ch == 'A' || ch == 'a' || ch == 'B' || ch == 'b' || ch == 'C' || ch == 'c' || ch == 'D' || ch == 'd' || ch == 'E' || ch == 'e' || ch == 'F' || ch == 'f';
    }

    public static boolean isValidXmlChar(char ch) {
        return ch >= ' ' && ch <= '\ud7ff' || ch == '\t' || ch == '\n' || ch == '\r' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff';
    }

    public static boolean isReservedXmlChar(char ch) {
        return RESERVED_XML_CHARS.containsKey(Character.valueOf(ch));
    }

    public static boolean isValidInt(String s, int radix) {
        try {
            Integer.parseInt(s, radix);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String escapeXml(String s, CleanerProperties props, boolean isDomCreation) {
        boolean advanced = props.isAdvancedXmlEscape();
        boolean recognizeUnicodeChars = props.isRecognizeUnicodeChars();
        boolean translateSpecialEntities = props.isTranslateSpecialEntities();
        if (s != null) {
            int len = s.length();
            StringBuilder result = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if (ch == '&') {
                    String entityKey;
                    SpecialEntity entity;
                    String seq;
                    int semiIndex;
                    if ((advanced || recognizeUnicodeChars) && i < len - 2 && s.charAt(i + 1) == '#') {
                        char currCh;
                        int charIndex;
                        boolean isHex = Character.toLowerCase(s.charAt(i + 2)) == 'x';
                        int radix = isHex ? 16 : 10;
                        String unicode = "";
                        for (charIndex = i + (isHex ? 3 : 2); charIndex < len && (currCh = s.charAt(charIndex)) != ';'; ++charIndex) {
                            if (Utils.isValidInt(unicode + currCh, radix)) {
                                unicode = unicode + currCh;
                                continue;
                            }
                            --charIndex;
                            break;
                        }
                        if (Utils.isValidInt(unicode, radix)) {
                            char unicodeChar = (char)Integer.parseInt(unicode, radix);
                            if (!Utils.isValidXmlChar(unicodeChar)) {
                                i = charIndex;
                                continue;
                            }
                            if (!Utils.isReservedXmlChar(unicodeChar)) {
                                result.append(recognizeUnicodeChars ? String.valueOf(unicodeChar) : "&#" + unicode + ";");
                                i = charIndex;
                                continue;
                            }
                            i = charIndex;
                            result.append("&#" + unicode + ";");
                            continue;
                        }
                        result.append("&amp;");
                        continue;
                    }
                    if (translateSpecialEntities && (semiIndex = (seq = s.substring(i, i + Math.min(SpecialEntity.getMaxEntityLength() + 2, len - i))).indexOf(59)) > 0 && (entity = SpecialEntity.getEntity(entityKey = seq.substring(1, semiIndex))) != null) {
                        result.append(props.isTransSpecialEntitiesToNCR() ? entity.getDecimalNCR() : Character.valueOf(entity.getCharacter()));
                        i += entityKey.length() + 1;
                        continue;
                    }
                    if (advanced) {
                        String sub = s.substring(i);
                        boolean isReservedSeq = false;
                        for (Map.Entry<Character, String> entry : RESERVED_XML_CHARS.entrySet()) {
                            String seq2 = entry.getValue();
                            if (!sub.startsWith(seq2)) continue;
                            result.append(isDomCreation ? (Serializable)entry.getKey() : (props.transResCharsToNCR ? "&#" + entry.getKey().charValue() + ";" : seq2));
                            i += seq2.length() - 1;
                            isReservedSeq = true;
                            break;
                        }
                        if (isReservedSeq) continue;
                        result.append(isDomCreation ? "&" : (props.transResCharsToNCR ? "&#38;" : RESERVED_XML_CHARS.get(Character.valueOf('&'))));
                        continue;
                    }
                    result.append("&amp;");
                    continue;
                }
                if (Utils.isReservedXmlChar(ch)) {
                    result.append(props.transResCharsToNCR ? "&#" + ch + ";" : (isDomCreation ? Character.valueOf(ch) : (Serializable)((Object)RESERVED_XML_CHARS.get(Character.valueOf(ch)))));
                    continue;
                }
                result.append(ch);
            }
            return result.toString();
        }
        return null;
    }

    public static boolean isWhitespaceString(Object object) {
        if (object != null) {
            String s = object.toString();
            return s != null && "".equals(s.trim());
        }
        return false;
    }

    public static boolean isIdentifierHelperChar(char ch) {
        return ':' == ch || '.' == ch || '-' == ch || '_' == ch;
    }

    public static boolean isValidXmlIdentifier(String s) {
        if (s != null) {
            int len = s.length();
            if (len == 0) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if ((i != 0 || Character.isUnicodeIdentifierStart(ch) || ch == '_') && (Character.isUnicodeIdentifierStart(ch) || Character.isDigit(ch) || Utils.isIdentifierHelperChar(ch))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEmptyString(Object o) {
        return o == null || "".equals(o.toString().trim());
    }

    public static String evaluateTemplate(String template, Map variables) {
        if (template == null) {
            return template;
        }
        StringBuilder result = new StringBuilder();
        int startIndex = template.indexOf(VAR_START);
        int endIndex = -1;
        while (startIndex >= 0 && startIndex < template.length()) {
            result.append(template.substring(endIndex + 1, startIndex));
            endIndex = template.indexOf(VAR_END, startIndex);
            if (endIndex > startIndex) {
                String varName = template.substring(startIndex + VAR_START.length(), endIndex);
                String resultObj = variables != null ? variables.get(varName.toLowerCase()) : "";
                result.append(resultObj == null ? "" : resultObj.toString());
            }
            startIndex = template.indexOf(VAR_START, Math.max(endIndex + VAR_END.length(), startIndex + 1));
        }
        result.append(template.substring(endIndex + 1));
        return result.toString();
    }

    public static String[] tokenize(String s, String delimiters) {
        if (s == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters);
        String[] result = new String[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            result[index++] = tokenizer.nextToken();
        }
        return result;
    }

    public static void updateTagTransformations(CleanerTransformations transformations, String key, String value) {
        int index = key.indexOf(46);
        if (index <= 0) {
            String destTag = null;
            boolean preserveSourceAtts = true;
            if (value != null) {
                String[] tokens = Utils.tokenize(value, ",;");
                if (tokens.length > 0) {
                    destTag = tokens[0];
                }
                if (tokens.length > 1) {
                    preserveSourceAtts = "true".equalsIgnoreCase(tokens[1]) || "yes".equalsIgnoreCase(tokens[1]) || "1".equals(tokens[1]);
                }
            }
            TagTransformation newTagTrans = new TagTransformation(key, destTag, preserveSourceAtts);
            transformations.addTransformation(newTagTrans);
        } else {
            String[] parts = Utils.tokenize(key, ".");
            String tagName = parts[0];
            TagTransformation trans = transformations.getTransformation(tagName);
            if (trans != null) {
                trans.addAttributeTransformation(parts[1], value);
            }
        }
    }

    public static boolean isFullUrl(String link) {
        if (link == null) {
            return false;
        }
        return (link = link.trim().toLowerCase()).startsWith("http://") || link.startsWith("https://") || link.startsWith("file://");
    }

    public static String fullUrl(String pageUrl, String link) {
        if (Utils.isFullUrl(link)) {
            return link;
        }
        if (link != null && link.startsWith("?")) {
            int qindex = pageUrl.indexOf(63);
            int len = pageUrl.length();
            if (qindex < 0) {
                return pageUrl + link;
            }
            if (qindex == len - 1) {
                return pageUrl.substring(0, len - 1) + link;
            }
            return pageUrl + "&" + link.substring(1);
        }
        boolean isLinkAbsolute = link.startsWith("/");
        if (!Utils.isFullUrl(pageUrl)) {
            pageUrl = "http://" + pageUrl;
        }
        int slashIndex = isLinkAbsolute ? pageUrl.indexOf("/", 8) : pageUrl.lastIndexOf("/");
        pageUrl = slashIndex <= 8 ? pageUrl + "/" : pageUrl.substring(0, slashIndex + 1);
        return isLinkAbsolute ? pageUrl + link.substring(1) : pageUrl + link;
    }

    public static String getXmlNSPrefix(String name) {
        int colIndex = name.indexOf(58);
        if (colIndex > 0) {
            return name.substring(0, colIndex);
        }
        return null;
    }

    public static String getXmlName(String name) {
        int colIndex = name.indexOf(58);
        if (colIndex > 0 && colIndex < name.length() - 1) {
            return name.substring(colIndex + 1);
        }
        return name;
    }

    static {
        RESERVED_XML_CHARS.put(Character.valueOf('&'), "&amp;");
        RESERVED_XML_CHARS.put(Character.valueOf('<'), "&lt;");
        RESERVED_XML_CHARS.put(Character.valueOf('>'), "&gt;");
        RESERVED_XML_CHARS.put(Character.valueOf('\"'), "&quot;");
        RESERVED_XML_CHARS.put(Character.valueOf('\''), "&apos;");
    }
}

