/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.htmlcleaner;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.xwiki.shaded.htmlcleaner.CleanerProperties;
import org.xwiki.shaded.htmlcleaner.Serializer;
import org.xwiki.shaded.htmlcleaner.TagInfo;
import org.xwiki.shaded.htmlcleaner.TagNode;
import org.xwiki.shaded.htmlcleaner.Utils;

public abstract class XmlSerializer
extends Serializer {
    protected XmlSerializer(CleanerProperties props) {
        super(props);
    }

    @Deprecated
    public void writeXmlToStream(TagNode tagNode, OutputStream out, String charset) throws IOException {
        super.writeToStream(tagNode, out, charset);
    }

    @Deprecated
    public void writeXmlToStream(TagNode tagNode, OutputStream out) throws IOException {
        super.writeToStream(tagNode, out);
    }

    @Deprecated
    public void writeXmlToFile(TagNode tagNode, String fileName, String charset) throws IOException {
        super.writeToFile(tagNode, fileName, charset);
    }

    @Deprecated
    public void writeXmlToFile(TagNode tagNode, String fileName) throws IOException {
        super.writeToFile(tagNode, fileName);
    }

    @Deprecated
    public String getXmlAsString(TagNode tagNode, String charset) throws IOException {
        return super.getAsString(tagNode, charset);
    }

    @Deprecated
    public String getXmlAsString(TagNode tagNode) throws IOException {
        return super.getAsString(tagNode);
    }

    @Deprecated
    public void writeXml(TagNode tagNode, Writer writer, String charset) throws IOException {
        super.write(tagNode, writer, charset);
    }

    protected String escapeXml(String xmlContent) {
        return Utils.escapeXml(xmlContent, this.props, false);
    }

    protected boolean dontEscape(TagNode tagNode) {
        return this.props.isUseCdataForScriptAndStyle() && this.isScriptOrStyle(tagNode);
    }

    protected boolean isMinimizedTagSyntax(TagNode tagNode) {
        TagInfo tagInfo = this.props.getTagInfoProvider().getTagInfo(tagNode.getName());
        return tagNode.getChildren().size() == 0 && (this.props.isUseEmptyElementTags() || tagInfo != null && tagInfo.isEmptyTag());
    }

    protected void serializeOpenTag(TagNode tagNode, Writer writer, boolean newLine) throws IOException {
        Map<String, String> nsDeclarations;
        String tagName = tagNode.getName();
        if (Utils.isEmptyString(tagName)) {
            return;
        }
        boolean nsAware = this.props.isNamespacesAware();
        HashSet<String> definedNSPrefixes = null;
        TreeSet<String> additionalNSDeclNeeded = null;
        String tagPrefix = Utils.getXmlNSPrefix(tagName);
        if (tagPrefix != null) {
            if (nsAware) {
                definedNSPrefixes = new HashSet<String>();
                tagNode.collectNamespacePrefixesOnPath(definedNSPrefixes);
                if (!definedNSPrefixes.contains(tagPrefix)) {
                    additionalNSDeclNeeded = new TreeSet<String>();
                    additionalNSDeclNeeded.add(tagPrefix);
                }
            } else {
                tagName = Utils.getXmlName(tagName);
            }
        }
        writer.write("<" + tagName);
        for (Map.Entry<String, String> entry : tagNode.getAttributes().entrySet()) {
            String attName = entry.getKey();
            String attPrefix = Utils.getXmlNSPrefix(attName);
            if (attPrefix != null) {
                if (nsAware) {
                    if (definedNSPrefixes == null) {
                        definedNSPrefixes = new HashSet();
                        tagNode.collectNamespacePrefixesOnPath(definedNSPrefixes);
                    }
                    if (!definedNSPrefixes.contains(attPrefix)) {
                        if (additionalNSDeclNeeded == null) {
                            additionalNSDeclNeeded = new TreeSet();
                        }
                        additionalNSDeclNeeded.add(attPrefix);
                    }
                } else {
                    attName = Utils.getXmlName(attName);
                }
            }
            writer.write(" " + attName + "=\"" + this.escapeXml(entry.getValue()) + "\"");
        }
        if (nsAware && (nsDeclarations = tagNode.getNamespaceDeclarations()) != null) {
            for (Map.Entry<String, String> entry : nsDeclarations.entrySet()) {
                String prefix = entry.getKey();
                String att = "xmlns";
                if (prefix.length() > 0) {
                    att = att + ":" + prefix;
                }
                writer.write(" " + att + "=\"" + this.escapeXml(entry.getValue()) + "\"");
            }
        }
        if (additionalNSDeclNeeded != null) {
            for (String prefix : additionalNSDeclNeeded) {
                writer.write(" xmlns:" + prefix + "=\"" + prefix + "\"");
            }
        }
        if (this.isMinimizedTagSyntax(tagNode)) {
            writer.write(" />");
            if (newLine) {
                writer.write("\n");
            }
        } else if (this.dontEscape(tagNode)) {
            writer.write("><![CDATA[");
        } else {
            writer.write(">");
        }
    }

    protected void serializeEndTag(TagNode tagNode, Writer writer, boolean newLine) throws IOException {
        String tagName = tagNode.getName();
        if (Utils.isEmptyString(tagName)) {
            return;
        }
        if (this.dontEscape(tagNode)) {
            writer.write("]]>");
        }
        if (Utils.getXmlNSPrefix(tagName) != null && !this.props.isNamespacesAware()) {
            tagName = Utils.getXmlName(tagName);
        }
        writer.write("</" + tagName + ">");
        if (newLine) {
            writer.write("\n");
        }
    }
}

