/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.javacc.jjtree;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import org.xwiki.shaded.javacc.jjtree.JJTreeIOException;
import org.xwiki.shaded.javacc.jjtree.JJTreeOptions;
import org.xwiki.shaded.javacc.parser.JavaCCGlobals;

final class IO {
    private String ifn = "<uninitialized input>";
    private String ofn;
    private Reader in;
    private PrintWriter out;
    private PrintStream msg = System.out;
    private PrintStream err = System.err;

    IO() {
    }

    String getInputFileName() {
        return this.ifn;
    }

    Reader getIn() {
        return this.in;
    }

    String getOutputFileName() {
        return this.ofn;
    }

    PrintWriter getOut() {
        return this.out;
    }

    PrintStream getMsg() {
        return this.msg;
    }

    PrintStream getErr() {
        return this.err;
    }

    void print(String string) {
        this.out.print(string);
    }

    void println(String string) {
        this.out.println(string);
    }

    void println() {
        this.out.println();
    }

    void closeAll() {
        if (this.out != null) {
            this.out.close();
        }
        if (this.msg != null) {
            this.msg.flush();
        }
        if (this.err != null) {
            this.err.flush();
        }
    }

    private String create_output_file_name(String string) {
        String string2 = JJTreeOptions.getOutputFile();
        if (string2.equals("")) {
            String string3;
            int n;
            int n2 = string.lastIndexOf(File.separatorChar);
            if (n2 >= 0) {
                string = string.substring(n2 + 1);
            }
            string2 = (n = string.lastIndexOf(46)) == -1 ? string + ".jj" : ((string3 = string.substring(n)).equals(".jj") ? string + ".jj" : string.substring(0, n) + ".jj");
        }
        return string2;
    }

    void setInput(String string) throws JJTreeIOException {
        try {
            File file = new File(string);
            if (!file.exists()) {
                throw new JJTreeIOException("File " + string + " not found.");
            }
            if (file.isDirectory()) {
                throw new JJTreeIOException(string + " is a directory. Please use a valid file name.");
            }
            if (JavaCCGlobals.isGeneratedBy("JJTree", string)) {
                throw new JJTreeIOException(string + " was generated by jjtree.  Cannot run jjtree again.");
            }
            this.ifn = file.getPath();
            this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.ifn), JJTreeOptions.getGrammarEncoding()));
        }
        catch (NullPointerException nullPointerException) {
            throw new JJTreeIOException(nullPointerException.toString());
        }
        catch (SecurityException securityException) {
            throw new JJTreeIOException("Security violation while trying to open " + string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JJTreeIOException("File " + string + " not found.");
        }
        catch (IOException iOException) {
            throw new JJTreeIOException(iOException.toString());
        }
    }

    void setOutput() throws JJTreeIOException {
        try {
            JavaCCGlobals.createOutputDir(JJTreeOptions.getJJTreeOutputDirectory());
            File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), this.create_output_file_name(this.ifn));
            this.ofn = file.toString();
            this.out = new PrintWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            throw new JJTreeIOException("Can't create output file " + this.ofn);
        }
    }
}

