/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.javacc.jjtree;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xwiki.shaded.javacc.jjtree.ASTNodeDescriptor;
import org.xwiki.shaded.javacc.jjtree.IO;
import org.xwiki.shaded.javacc.jjtree.JJTreeGlobals;
import org.xwiki.shaded.javacc.jjtree.JJTreeOptions;
import org.xwiki.shaded.javacc.parser.Options;
import org.xwiki.shaded.javacc.parser.OutputFile;
import org.xwiki.shaded.javacc.utils.JavaFileGenerator;

final class NodeFiles {
    static final String nodeVersion = "4.3";
    static Set nodesGenerated = new HashSet();

    private NodeFiles() {
    }

    static void ensure(IO iO, String string) {
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".java");
        if (!string.equals("Node")) {
            if (string.equals("SimpleNode")) {
                NodeFiles.ensure(iO, "Node");
            } else {
                NodeFiles.ensure(iO, "SimpleNode");
            }
        }
        if (!string.equals("Node") && !JJTreeOptions.getBuildNodeFiles()) {
            return;
        }
        if (file.exists() && nodesGenerated.contains(file.getName())) {
            return;
        }
        try {
            String[] stringArray = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
            OutputFile outputFile = new OutputFile(file, nodeVersion, stringArray);
            outputFile.setToolName("JJTree");
            nodesGenerated.add(file.getName());
            if (!outputFile.needToWrite) {
                return;
            }
            if (string.equals("Node")) {
                NodeFiles.generateNode_java(outputFile);
            } else if (string.equals("SimpleNode")) {
                NodeFiles.generateSimpleNode_java(outputFile);
            } else {
                NodeFiles.generateMULTINode_java(outputFile, string);
            }
            outputFile.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    static void generatePrologue(PrintWriter printWriter) {
        if (!JJTreeGlobals.nodePackageName.equals("")) {
            printWriter.println("package " + JJTreeGlobals.nodePackageName + ";");
            printWriter.println();
            if (!JJTreeGlobals.nodePackageName.equals(JJTreeGlobals.packageName)) {
                printWriter.println("import " + JJTreeGlobals.packageName + ".*;");
                printWriter.println();
            }
        }
    }

    static String nodeConstants() {
        return JJTreeGlobals.parserName + "TreeConstants";
    }

    static void generateTreeConstants_java() {
        String string = NodeFiles.nodeConstants();
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".java");
        try {
            String string2;
            int n;
            OutputFile outputFile = new OutputFile(file);
            PrintWriter printWriter = outputFile.getPrintWriter();
            List list = ASTNodeDescriptor.getNodeIds();
            List list2 = ASTNodeDescriptor.getNodeNames();
            NodeFiles.generatePrologue(printWriter);
            printWriter.println("public interface " + string);
            printWriter.println("{");
            for (n = 0; n < list.size(); ++n) {
                string2 = (String)list.get(n);
                printWriter.println("  public int " + string2 + " = " + n + ";");
            }
            printWriter.println();
            printWriter.println();
            printWriter.println("  public String[] jjtNodeName = {");
            for (n = 0; n < list2.size(); ++n) {
                string2 = (String)list2.get(n);
                printWriter.println("    \"" + string2 + "\",");
            }
            printWriter.println("  };");
            printWriter.println("}");
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    static String visitorClass() {
        return JJTreeGlobals.parserName + "Visitor";
    }

    static void generateVisitor_java() {
        if (!JJTreeOptions.getVisitor()) {
            return;
        }
        String string = NodeFiles.visitorClass();
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".java");
        try {
            OutputFile outputFile = new OutputFile(file);
            PrintWriter printWriter = outputFile.getPrintWriter();
            List list = ASTNodeDescriptor.getNodeNames();
            NodeFiles.generatePrologue(printWriter);
            printWriter.println("public interface " + string);
            printWriter.println("{");
            String string2 = NodeFiles.mergeVisitorException();
            String string3 = "Object";
            if (!JJTreeOptions.getVisitorDataType().equals("")) {
                string3 = JJTreeOptions.getVisitorDataType();
            }
            printWriter.println("  public " + JJTreeOptions.getVisitorReturnType() + " visit(SimpleNode node, " + string3 + " data)" + string2 + ";");
            if (JJTreeOptions.getMulti()) {
                for (int i = 0; i < list.size(); ++i) {
                    String string4 = (String)list.get(i);
                    if (string4.equals("void")) continue;
                    String string5 = JJTreeOptions.getNodePrefix() + string4;
                    printWriter.println("  public " + JJTreeOptions.getVisitorReturnType() + " visit(" + string5 + " node, " + string3 + " data)" + string2 + ";");
                }
            }
            printWriter.println("}");
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    private static String mergeVisitorException() {
        String string = JJTreeOptions.getVisitorException();
        if (!"".equals(string)) {
            string = " throws " + string;
        }
        return string;
    }

    private static void generateNode_java(OutputFile outputFile) throws IOException {
        PrintWriter printWriter = outputFile.getPrintWriter();
        NodeFiles.generatePrologue(printWriter);
        HashMap<String, String> hashMap = new HashMap<String, String>(Options.getOptions());
        hashMap.put("PARSER_NAME", JJTreeGlobals.parserName);
        JavaFileGenerator javaFileGenerator = new JavaFileGenerator("/templates/Node.template", hashMap);
        javaFileGenerator.generate(printWriter);
        printWriter.close();
    }

    private static void generateSimpleNode_java(OutputFile outputFile) throws IOException {
        PrintWriter printWriter = outputFile.getPrintWriter();
        NodeFiles.generatePrologue(printWriter);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(Options.getOptions());
        hashMap.put("PARSER_NAME", JJTreeGlobals.parserName);
        hashMap.put("VISITOR_RETURN_TYPE_VOID", JJTreeOptions.getVisitorReturnType().equals("void"));
        JavaFileGenerator javaFileGenerator = new JavaFileGenerator("/templates/SimpleNode.template", hashMap);
        javaFileGenerator.generate(printWriter);
        printWriter.close();
    }

    private static void generateMULTINode_java(OutputFile outputFile, String string) throws IOException {
        PrintWriter printWriter = outputFile.getPrintWriter();
        NodeFiles.generatePrologue(printWriter);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(Options.getOptions());
        hashMap.put("PARSER_NAME", JJTreeGlobals.parserName);
        hashMap.put("NODE_TYPE", string);
        hashMap.put("VISITOR_RETURN_TYPE_VOID", JJTreeOptions.getVisitorReturnType().equals("void"));
        JavaFileGenerator javaFileGenerator = new JavaFileGenerator("/templates/MultiNode.template", hashMap);
        javaFileGenerator.generate(printWriter);
        printWriter.close();
    }
}

