/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.shaded.xml.sax.InputSource;
import org.xwiki.shaded.xml.sax.SAXException;
import org.xwiki.xml.EntityResolver;

@Component
@Singleton
public class LocalEntityResolver
implements EntityResolver {
    @Inject
    private Logger logger;

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source = null;
        try {
            URI uri = new URI(systemId);
            if ("http".equals(uri.getScheme()) || "file".equals(uri.getScheme())) {
                String filename = new File(uri.getPath()).getName();
                InputStream istream = this.getClass().getClassLoader().getResourceAsStream(filename);
                if (istream != null) {
                    source = new InputSource(istream);
                } else {
                    this.logger.warn("Failed to load resource [{}] locally. Will try to get it online at [{}]", (Object)filename, (Object)systemId);
                }
            } else {
                this.logger.debug("Unknown URI scheme [{}] for entity [{}]. Assuming the entity is already resolved and looking for it in the file system.", (Object)uri.getScheme(), (Object)systemId);
                InputStream istream = this.getClass().getClassLoader().getResourceAsStream(systemId);
                if (istream != null) {
                    source = new InputSource(istream);
                } else {
                    this.logger.warn("Failed to load resource [{}]", (Object)systemId);
                }
            }
        }
        catch (URISyntaxException e) {
            this.logger.warn("Invalid URI [{}]. Reason [{}]", (Object)systemId, (Object)e.getMessage());
        }
        return source;
    }
}

