/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml;

import java.util.Map;
import org.xwiki.rendering.internal.renderer.ParametersPrinter;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;

public class XHTMLMacroRenderer {
    private static final String COMMENT_SEPARATOR = "|-|";
    private static final ParametersPrinter PARAMETERS_PRINTER = new ParametersPrinter('\\', new String[0]);

    public void render(XHTMLWikiPrinter printer, String name, Map<String, String> parameters, String content) {
        this.beginRender(printer, name, parameters, content);
        this.endRender(printer);
    }

    public void beginRender(XHTMLWikiPrinter printer, String name, Map<String, String> parameters, String content) {
        StringBuilder buffer = new StringBuilder("startmacro:");
        buffer.append(name);
        buffer.append(COMMENT_SEPARATOR);
        if (!parameters.isEmpty()) {
            buffer.append(PARAMETERS_PRINTER.print(parameters));
        }
        if (content != null) {
            buffer.append(COMMENT_SEPARATOR);
            buffer.append(content);
        }
        printer.printXMLComment(buffer.toString(), true);
    }

    public void endRender(XHTMLWikiPrinter printer) {
        printer.printXMLComment("stopmacro");
    }
}

