/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.confluencexhtml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.AttachmentTagHandler;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.ConfluenceXWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.ImageTagHandler;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.LinkTagHandler;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.MacroTagHandler;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.PageTagHandler;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.ParameterTagHandler;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.PlainTextBodyTagHandler;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.PlainTextLinkBodyTagHandler;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.RichTextBodyTagHandler;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.SpaceTagHandler;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.URLTagHandler;
import org.xwiki.rendering.internal.parser.confluencexhtml.wikimodel.UserTagHandler;
import org.xwiki.rendering.internal.parser.wikimodel.AbstractWikiModelParser;
import org.xwiki.rendering.internal.parser.wikimodel.WikiModelStreamParser;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiHeaderTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiReferenceTagHandler;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.rendering.wikimodel.IWikiParser;
import org.xwiki.rendering.wikimodel.xhtml.XhtmlParser;

@Component
@Named(value="confluence+xhtml/1.0")
@Singleton
public class ConfluenceXHTMLParser
extends AbstractWikiModelParser {
    @Inject
    @Named(value="xdom+xml/current")
    private StreamParser xmlParser;
    @Inject
    @Named(value="xdom+xml/current")
    private PrintRendererFactory xmlRenderer;
    @Inject
    @Named(value="link")
    private ResourceReferenceParser linkReferenceParser;
    @Inject
    @Named(value="image")
    private ResourceReferenceParser imageReferenceParser;
    @Inject
    @Named(value="plain/1.0")
    private StreamParser plainParser;

    public Syntax getSyntax() {
        return Syntax.CONFLUENCEXHTML_1_0;
    }

    public StreamParser getLinkLabelParser() {
        return this.xmlParser;
    }

    public IWikiParser createWikiModelParser() throws ParseException {
        XhtmlParser parser = new XhtmlParser();
        parser.setNamespacesEnabled(false);
        HashMap<String, Object> handlers = new HashMap<String, Object>();
        XWikiHeaderTagHandler handler = new XWikiHeaderTagHandler();
        handlers.put("h1", handler);
        handlers.put("h2", handler);
        handlers.put("h3", handler);
        handlers.put("h4", handler);
        handlers.put("h5", handler);
        handlers.put("h6", handler);
        handlers.put("a", new XWikiReferenceTagHandler((WikiModelStreamParser)this, this.xmlRenderer));
        handlers.put("ac:macro", (Object)new MacroTagHandler());
        handlers.put("ac:structured-macro", (Object)new MacroTagHandler());
        handlers.put("ac:parameter", (Object)new ParameterTagHandler());
        handlers.put("ac:plain-text-body", (Object)new PlainTextBodyTagHandler());
        handlers.put("ac:rich-text-body", (Object)new RichTextBodyTagHandler());
        handlers.put("ac:image", (Object)new ImageTagHandler());
        handlers.put("ri:url", (Object)new URLTagHandler());
        handlers.put("ac:link", (Object)new LinkTagHandler());
        handlers.put("ri:page", (Object)new PageTagHandler());
        handlers.put("ri:space", (Object)new SpaceTagHandler());
        handlers.put("ri:user", (Object)new UserTagHandler());
        handlers.put("ac:plain-text-link-body", (Object)new PlainTextLinkBodyTagHandler());
        handlers.put("ri:attachment", (Object)new AttachmentTagHandler());
        parser.setExtraHandlers(handlers);
        return parser;
    }

    protected void parse(Reader source, Listener listener, IdGenerator idGenerator) throws ParseException {
        String content;
        try {
            content = IOUtils.toString((Reader)source);
        }
        catch (IOException e) {
            throw new ParseException("Failed to read source", (Throwable)e);
        }
        content = "<void>" + content + "</void>";
        content = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">" + content;
        super.parse((Reader)new StringReader(content), listener, idGenerator);
    }

    public ResourceReferenceParser getLinkReferenceParser() {
        return this.linkReferenceParser;
    }

    public ResourceReferenceParser getImageReferenceParser() {
        return this.imageReferenceParser;
    }

    public XWikiGeneratorListener createXWikiGeneratorListener(Listener listener, IdGenerator idGenerator) {
        return new ConfluenceXWikiGeneratorListener(this.getLinkLabelParser(), listener, this.getLinkReferenceParser(), this.getImageReferenceParser(), this.plainRendererFactory, idGenerator, this.getSyntax(), this.plainParser);
    }
}

