/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.markdown11;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.pegdown.ast.InlineHtmlNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.SuperNode;
import org.xwiki.rendering.internal.parser.markdown.AbstractTablePegdownVisitor;
import org.xwiki.rendering.internal.parser.markdown11.ast.MacroNode;
import org.xwiki.rendering.internal.parser.markdown11.ast.MacroParameterNode;
import org.xwiki.rendering.internal.parser.markdown11.ast.SubscriptNode;
import org.xwiki.rendering.internal.parser.markdown11.ast.SuperscriptNode;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.syntax.Syntax;

public abstract class AbstractPluginsPegdownVisitor
extends AbstractTablePegdownVisitor {
    public void visit(Node node) {
        if (node instanceof SuperscriptNode) {
            this.visit((SuperscriptNode)node);
        } else if (node instanceof SubscriptNode) {
            this.visit((SubscriptNode)node);
        } else if (node instanceof MacroNode) {
            this.visit((MacroNode)node);
        } else {
            throw new RuntimeException("Don't know how to handle node " + node);
        }
    }

    public void visit(SuperscriptNode node) {
        this.handleFormatted(node, Format.SUPERSCRIPT);
    }

    public void visit(SubscriptNode node) {
        this.handleFormatted(node, Format.SUBSCRIPT);
    }

    public void visit(MacroNode node) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(node.getParameters().size());
        for (MacroParameterNode param : node.getParameters()) {
            parameters.put(param.getName(), param.getValue());
        }
        String content = this.extractText((Node)node);
        content = content.length() > 0 ? content : null;
        this.getListener().onMacro(node.getMacroId(), parameters, content, node.isInline());
    }

    private void handleFormatted(SuperNode node, Format format) {
        this.getListener().beginFormat(format, Collections.EMPTY_MAP);
        this.visitChildren((Node)node);
        this.getListener().endFormat(format, Collections.EMPTY_MAP);
    }

    public void visit(InlineHtmlNode inlineHtmlNode) {
        this.getListener().onRawText(inlineHtmlNode.getText(), Syntax.XHTML_1_0);
    }
}

