/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.internal.parser.wikimodel.xhtml;

import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.xhtml.handler.HeaderTagHandler;
import org.wikimodel.wem.xhtml.impl.XhtmlHandler.TagStack.TagContext;

/**
 * Override the default implementation of hte WikiModel XHTML parser for handling HTML headers. We need to do this in
 * order to handle the <code>id</code> attribute that we generate in our XHTML rendered.
 * 
 * @version $Id: XWikiHeaderTagHandler.java 18208 2009-04-02 15:05:14Z vmassol $
 * @since 1.6RC1
 */
public class XWikiHeaderTagHandler extends HeaderTagHandler
{
    /**
     * {@inheritDoc}
     * 
     * @see HeaderTagHandler#begin(TagContext)
     */
    @Override
    protected void begin(TagContext context)
    {
        String tag = context.getName();
        int level = Integer.parseInt(tag.substring(1, 2));
        sendEmptyLines(context);

        // TODO: If there's an ID attribute then check if it corresponds to the default header ID generated by the
        // XWiki ID generator. If so remove it so that it's not displayed. We need to do this because the
        // XWiki HTML renderer automatically generates an ID for headers.
        WikiParameters params = context.getParams();
        if (params.getParameter("id") != null) {
            params = params.remove("id");
        }

        context.getScannerContext().beginHeader(level, params);
    }
}
