/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.xdomxml10.internal.renderer.parameter;

import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xwiki.rendering.xdomxml10.internal.XDOMXMLConstants;

public abstract class AbstractSerializer {
    public static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();

    public void serializeParameter(String name, Map<?, ?> map, boolean type, ContentHandler contentHandler) {
        Attributes attributes;
        if (type) {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute(null, null, "type", null, "stringmap");
            attributes = attributesImpl;
        } else {
            attributes = EMPTY_ATTRIBUTES;
        }
        this.startElement(name, attributes, contentHandler);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getValue() == null || entry.getKey() == null) continue;
            this.serializeParameter(entry.getKey().toString(), entry.getValue().toString(), null, contentHandler);
        }
        this.endElement(name, contentHandler);
    }

    public void serializeParameter(String name, char value, boolean type, ContentHandler contentHandler) {
        this.serializeParameter(name, String.valueOf(value), "char", contentHandler);
    }

    public void serializeParameter(String name, int value, boolean type, ContentHandler contentHandler) {
        this.serializeParameter(name, String.valueOf(value), "int", contentHandler);
    }

    public void serializeParameter(String name, boolean value, boolean type, ContentHandler contentHandler) {
        this.serializeParameter(name, String.valueOf(value), "bool", contentHandler);
    }

    public void serializeParameter(String name, String value, String type, ContentHandler contentHandler) {
        Attributes attributes;
        String nodeName;
        if (this.isValidNodeName(name)) {
            nodeName = name;
            if (type == null) {
                attributes = EMPTY_ATTRIBUTES;
            } else {
                AttributesImpl attributesImpl = new AttributesImpl();
                attributesImpl.addAttribute(null, null, "type", null, type);
                attributes = attributesImpl;
            }
        } else {
            nodeName = "entry";
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute(null, null, "name", null, name);
            attributes = attributesImpl;
        }
        this.startElement(nodeName, attributes, contentHandler);
        this.characters(value, contentHandler);
        this.endElement(nodeName, contentHandler);
    }

    public boolean isValidNodeName(String name) {
        return XDOMXMLConstants.VALID_ELEMENTNAME.matcher(name).matches();
    }

    public void startElement(String elementName, Attributes attributes, ContentHandler contentHandler) {
        try {
            contentHandler.startElement("", elementName, elementName, attributes);
        }
        catch (SAXException e) {
            throw new RuntimeException("Failed to send sax event", e);
        }
    }

    public void characters(String str, ContentHandler contentHandler) {
        try {
            contentHandler.characters(str.toCharArray(), 0, str.length());
        }
        catch (SAXException e) {
            throw new RuntimeException("Failed to send sax event", e);
        }
    }

    public void endElement(String elementName, ContentHandler contentHandler) {
        try {
            contentHandler.endElement("", elementName, elementName);
        }
        catch (SAXException e) {
            throw new RuntimeException("Failed to send sax event", e);
        }
    }
}

