/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import java.util.Collections;
import org.wikimodel.wem.IWemListener;
import org.wikimodel.wem.WikiParameter;
import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.WikiReference;
import org.wikimodel.wem.impl.WikiScannerContext;
import org.wikimodel.wem.xhtml.handler.ReferenceTagHandler;
import org.wikimodel.wem.xhtml.impl.XhtmlHandler;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.XHTMLParser;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;

public class XWikiReferenceTagHandler
extends ReferenceTagHandler {
    private XHTMLParser parser;
    private PrintRendererFactory xwikiSyntaxPrintRendererFactory;

    public XWikiReferenceTagHandler(XHTMLParser parser, PrintRendererFactory xwikiSyntaxPrintRendererFactory) {
        this.parser = parser;
        this.xwikiSyntaxPrintRendererFactory = xwikiSyntaxPrintRendererFactory;
    }

    public void initialize(XhtmlHandler.TagStack stack) {
        stack.setStackParameter("isInLink", (Object)false);
        stack.setStackParameter("isFreeStandingLink", (Object)false);
        stack.setStackParameter("linkParameters", (Object)WikiParameters.EMPTY);
    }

    protected void begin(XhtmlHandler.TagStack.TagContext context) {
        boolean isInLink = (Boolean)context.getTagStack().getStackParameter("isInLink");
        if (isInLink) {
            XWikiGeneratorListener listener = (XWikiGeneratorListener)context.getTagStack().getStackParameter("linkListener");
            context.getTagStack().pushScannerContext(new WikiScannerContext((IWemListener)listener));
            context.getScannerContext().beginDocument();
            if (this.isFreeStandingReference(context)) {
                context.getTagStack().setStackParameter("isFreeStandingLink", (Object)true);
            } else {
                context.getTagStack().setStackParameter("linkParameters", (Object)this.removeMeaningfulParameters(context.getParams()));
            }
            this.setAccumulateContent(false);
        } else if (!this.isFreeStandingReference(context)) {
            WikiParameter ref = context.getParams().getParameter("href");
            if (ref != null) {
                DefaultWikiPrinter printer = new DefaultWikiPrinter();
                PrintRenderer linkLabelRenderer = this.xwikiSyntaxPrintRendererFactory.createRenderer((WikiPrinter)printer);
                linkLabelRenderer.beginDocument(MetaData.EMPTY);
                XWikiGeneratorListener xwikiListener = this.parser.createXWikiGeneratorListener((Listener)linkLabelRenderer, null);
                context.getTagStack().pushScannerContext(new WikiScannerContext((IWemListener)xwikiListener));
                context.getScannerContext().beginDocument();
            } else {
                WikiParameter idName = context.getParams().getParameter("id");
                if (idName == null) {
                    idName = context.getParams().getParameter("name");
                }
                if (idName != null) {
                    WikiParameter parameter = new WikiParameter("name", idName.getValue());
                    WikiParameters parameters = new WikiParameters(Collections.singletonList(parameter));
                    context.getScannerContext().onExtensionBlock("xwiki_id", parameters);
                }
            }
        } else {
            super.begin(context);
        }
    }

    protected void end(XhtmlHandler.TagStack.TagContext context) {
        boolean isInLink = (Boolean)context.getTagStack().getStackParameter("isInLink");
        if (isInLink) {
            context.getScannerContext().endDocument();
            context.getTagStack().popScannerContext();
        } else if (!this.isFreeStandingReference(context)) {
            WikiParameters parameters = context.getParams();
            WikiParameter ref = parameters.getParameter("href");
            if (ref != null) {
                context.getScannerContext().endDocument();
                WikiScannerContext scannerContext = context.getTagStack().popScannerContext();
                XWikiGeneratorListener xwikiListener = (XWikiGeneratorListener)scannerContext.getfListener();
                PrintRenderer linkLabelRenderer = (PrintRenderer)xwikiListener.getListener();
                linkLabelRenderer.endDocument(MetaData.EMPTY);
                String label = linkLabelRenderer.getPrinter().toString();
                WikiReference reference = new WikiReference(ref.getValue(), label, this.removeMeaningfulParameters(parameters));
                context.getScannerContext().onReference(reference);
            }
        } else {
            super.end(context);
        }
    }
}

