/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml.link;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkRenderer;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;
import org.xwiki.rendering.renderer.reference.ResourceReferenceSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Named(value="annotated")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class AnnotatedXHTMLLinkRenderer
implements XHTMLLinkRenderer {
    @Inject
    @Named(value="xhtmlmarker")
    private ResourceReferenceSerializer xhtmlMarkerSerializer;
    @Inject
    private XHTMLLinkRenderer defaultLinkRenderer;

    @Override
    public void setXHTMLWikiPrinter(XHTMLWikiPrinter printer) {
        this.defaultLinkRenderer.setXHTMLWikiPrinter(printer);
    }

    @Override
    public void setHasLabel(boolean hasLabel) {
        this.defaultLinkRenderer.setHasLabel(hasLabel);
    }

    public void beginLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        StringBuffer buffer = new StringBuffer("startwikilink:");
        buffer.append(this.xhtmlMarkerSerializer.serialize(reference));
        this.getXHTMLWikiPrinter().printXMLComment(buffer.toString(), true);
        this.defaultLinkRenderer.beginLink(reference, isFreeStandingURI, parameters);
    }

    public void endLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.defaultLinkRenderer.endLink(reference, isFreeStandingURI, parameters);
        this.getXHTMLWikiPrinter().printXMLComment("stopwikilink");
    }

    @Override
    public XHTMLWikiPrinter getXHTMLWikiPrinter() {
        return this.defaultLinkRenderer.getXHTMLWikiPrinter();
    }
}

