/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml.link;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.renderer.xhtml.link.AbstractXHTMLLinkTypeRenderer;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.reference.link.LinkLabelGenerator;
import org.xwiki.rendering.wiki.WikiModel;

@Component
@Named(value="doc")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DocumentXHTMLLinkTypeRenderer
extends AbstractXHTMLLinkTypeRenderer
implements Initializable {
    private static final String WIKILINK = "wikilink";
    private WikiModel wikiModel;
    @Inject
    private LinkLabelGenerator linkLabelGenerator;

    public void initialize() throws InitializationException {
        try {
            this.wikiModel = (WikiModel)this.componentManager.lookup(WikiModel.class);
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
    }

    @Override
    public void beginLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        if (this.wikiModel == null) {
            super.beginLink(reference, isFreeStandingURI, parameters);
        } else {
            this.beginInternalLink(reference, isFreeStandingURI, parameters);
        }
    }

    @Override
    protected String computeLabel(ResourceReference reference) {
        return this.linkLabelGenerator.generate(reference);
    }

    @Override
    protected void beginLinkExtraAttributes(ResourceReference reference, Map<String, String> spanAttributes, Map<String, String> anchorAttributes) {
        if (StringUtils.isEmpty((String)reference.getReference())) {
            this.renderAutoLink(reference, spanAttributes, anchorAttributes);
        } else {
            anchorAttributes.put("href", reference.getReference());
        }
    }

    private void beginInternalLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        LinkedHashMap<String, String> spanAttributes = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> anchorAttributes = new LinkedHashMap<String, String>();
        anchorAttributes.putAll(parameters);
        if (StringUtils.isEmpty((String)reference.getReference()) || this.wikiModel.isDocumentAvailable(reference)) {
            spanAttributes.put("class", WIKILINK);
            anchorAttributes.put("href", this.wikiModel.getDocumentViewURL(reference));
        } else {
            spanAttributes.put("class", "wikicreatelink");
            anchorAttributes.put("href", this.wikiModel.getDocumentEditURL(reference));
        }
        this.getXHTMLWikiPrinter().printXMLStartElement("span", spanAttributes);
        this.getXHTMLWikiPrinter().printXMLStartElement("a", anchorAttributes);
    }

    private void renderAutoLink(ResourceReference reference, Map<String, String> spanAttributes, Map<String, String> aAttributes) {
        spanAttributes.put("class", WIKILINK);
        StringBuilder buffer = new StringBuilder();
        String queryString = reference.getParameter("queryString");
        if (queryString != null) {
            buffer.append('?');
            buffer.append(queryString);
        }
        buffer.append('#');
        String anchor = reference.getParameter("anchor");
        if (anchor != null) {
            buffer.append(anchor);
        }
        aAttributes.put("href", buffer.toString());
    }
}

