/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.rendering.internal.parser.wikimodel.DefaultXWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiWikiReference;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.rendering.wikimodel.WikiReference;

public class XHTMLXWikiGeneratorListener
extends DefaultXWikiGeneratorListener {
    private static final Pattern URL_SCHEME_PATTERN = Pattern.compile("[a-zA-Z0-9+.-]*://");

    public XHTMLXWikiGeneratorListener(StreamParser parser, Listener listener, ResourceReferenceParser linkReferenceParser, ResourceReferenceParser imageReferenceParser, PrintRendererFactory plainRendererFactory, IdGenerator idGenerator, Syntax syntax) {
        super(parser, listener, linkReferenceParser, imageReferenceParser, plainRendererFactory, idGenerator, syntax);
    }

    public void onReference(WikiReference reference) {
        boolean isFreeStanding;
        ResourceReference resourceReference;
        if (!(reference instanceof XWikiWikiReference)) {
            resourceReference = this.computeResourceReference(reference.getLink());
            isFreeStanding = false;
        } else {
            XWikiWikiReference xwikiReference = (XWikiWikiReference)reference;
            resourceReference = xwikiReference.getReference();
            isFreeStanding = xwikiReference.isFreeStanding();
            this.flushFormat();
        }
        Pair parameters = this.convertAndSeparateParameters(reference.getParameters());
        resourceReference.setParameters((Map)parameters.getLeft());
        this.onReference(resourceReference, reference.getLabel(), isFreeStanding, (Map)parameters.getRight());
    }

    public void onImage(WikiReference reference) {
        if (!(reference instanceof XWikiWikiReference)) {
            super.onImage(reference);
        } else {
            XWikiWikiReference xwikiReference = (XWikiWikiReference)reference;
            ResourceReference resourceReference = xwikiReference.getReference();
            this.flushFormat();
            this.onImage(resourceReference, xwikiReference.isFreeStanding(), this.convertParameters(xwikiReference.getParameters()));
        }
    }

    private ResourceReference computeResourceReference(String rawReference) {
        Matcher matcher = URL_SCHEME_PATTERN.matcher(rawReference);
        ResourceReference reference = matcher.lookingAt() ? new ResourceReference(rawReference, ResourceType.URL) : new ResourceReference(rawReference, ResourceType.PATH);
        return reference;
    }
}

