/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml.image;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.renderer.xhtml.image.XHTMLImageRenderer;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;
import org.xwiki.rendering.renderer.reference.link.URILabelGenerator;
import org.xwiki.rendering.wiki.WikiModel;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultXHTMLImageRenderer
implements XHTMLImageRenderer,
Initializable {
    private XHTMLWikiPrinter xhtmlPrinter;
    private WikiModel wikiModel;
    @Inject
    private ComponentManager componentManager;

    public void initialize() throws InitializationException {
        try {
            this.wikiModel = (WikiModel)this.componentManager.getInstance(WikiModel.class);
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
    }

    @Override
    public void setXHTMLWikiPrinter(XHTMLWikiPrinter printer) {
        this.xhtmlPrinter = printer;
    }

    @Override
    public XHTMLWikiPrinter getXHTMLWikiPrinter() {
        return this.xhtmlPrinter;
    }

    public void onImage(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        try {
            String imageURL = this.getImageURL(reference, parameters);
            attributes.put("src", imageURL);
            if (isFreeStandingURI) {
                attributes.put("class", "wikimodel-freestanding");
            }
            attributes.putAll(parameters);
            if (!parameters.containsKey("alt")) {
                attributes.put("alt", this.computeAltAttributeValue(reference));
            }
            this.getXHTMLWikiPrinter().printXMLElement("img", attributes);
        }
        catch (Throwable e) {
            this.getXHTMLWikiPrinter().printXMLStartElement("span", (String[][])new String[][]{{"class", "xwikirenderingerror"}});
            this.getXHTMLWikiPrinter().printXML(e.getMessage());
            this.getXHTMLWikiPrinter().printXMLEndElement("span");
            this.getXHTMLWikiPrinter().printXMLStartElement("span", (String[][])new String[][]{{"class", "xwikirenderingerrordescription hidden"}});
            this.getXHTMLWikiPrinter().printXMLStartElement("tt", (String[][])new String[][]{{"class", "wikimodel-verbatim"}});
            this.getXHTMLWikiPrinter().printXML(ExceptionUtils.getStackTrace((Throwable)e));
            this.getXHTMLWikiPrinter().printXMLEndElement("tt");
            this.getXHTMLWikiPrinter().printXMLEndElement("span");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getImageURL(ResourceReference reference, Map<String, String> parameters) {
        if (!reference.getType().equals((Object)ResourceType.ATTACHMENT)) {
            if (!reference.getType().equals((Object)ResourceType.ICON)) return reference.getReference();
        }
        if (this.wikiModel == null) throw new IllegalArgumentException("Invalid Image type. In non wiki mode, all image types must be URL images.");
        return this.wikiModel.getImageURL(reference, parameters);
    }

    private String computeAltAttributeValue(ResourceReference reference) {
        String label;
        try {
            URILabelGenerator uriLabelGenerator = (URILabelGenerator)this.componentManager.getInstance(URILabelGenerator.class, reference.getType().getScheme());
            label = uriLabelGenerator.generateLabel(reference);
        }
        catch (ComponentLookupException e) {
            label = reference.getReference();
        }
        return label;
    }
}

