/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml;

import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.parser.wikimodel.AbstractWikiModelParser;
import org.xwiki.rendering.internal.parser.wikimodel.WikiModelStreamParser;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XHTMLXWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiCommentHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiHeaderTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiImageTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiReferenceTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiSpanTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiTableDataTagHandler;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.rendering.wikimodel.IWikiParser;
import org.xwiki.rendering.wikimodel.xhtml.XhtmlParser;
import org.xwiki.rendering.wikimodel.xhtml.handler.CommentHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.DivisionTagHandler;
import org.xwiki.xml.XMLReaderFactory;

@Component
@Named(value="xhtml/1.0")
@Singleton
public class XHTMLParser
extends AbstractWikiModelParser {
    @Inject
    @Named(value="xdom+xml/current")
    private StreamParser xmlParser;
    @Inject
    @Named(value="xdom+xml/current")
    private PrintRendererFactory xmlRenderer;
    @Inject
    @Named(value="link")
    private ResourceReferenceParser linkReferenceParser;
    @Inject
    @Named(value="image")
    private ResourceReferenceParser imageReferenceParser;
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="xhtmlmarker")
    private ResourceReferenceParser xhtmlMarkerResourceReferenceParser;
    @Inject
    @Named(value="xwiki")
    private XMLReaderFactory xmlReaderFactory;

    public Syntax getSyntax() {
        return Syntax.XHTML_1_0;
    }

    public StreamParser getLinkLabelParser() {
        return this.xmlParser;
    }

    public IWikiParser createWikiModelParser() throws ParseException {
        HashMap<String, Object> handlers = new HashMap<String, Object>();
        XWikiHeaderTagHandler handler = new XWikiHeaderTagHandler();
        handlers.put("h1", (Object)handler);
        handlers.put("h2", (Object)handler);
        handlers.put("h3", (Object)handler);
        handlers.put("h4", (Object)handler);
        handlers.put("h5", (Object)handler);
        handlers.put("h6", (Object)handler);
        handlers.put("a", (Object)new XWikiReferenceTagHandler((WikiModelStreamParser)this, this.xmlRenderer));
        handlers.put("img", (Object)new XWikiImageTagHandler());
        handlers.put("span", (Object)new XWikiSpanTagHandler());
        handlers.put("div", new DivisionTagHandler("xwiki-document"));
        handlers.put("th", (Object)new XWikiTableDataTagHandler());
        XhtmlParser parser = new XhtmlParser();
        parser.setExtraHandlers(handlers);
        parser.setCommentHandler((CommentHandler)new XWikiCommentHandler(this.componentManager, this, this.xmlRenderer, this.xhtmlMarkerResourceReferenceParser));
        try {
            parser.setXmlReader(this.xmlReaderFactory.createXMLReader());
        }
        catch (Exception e) {
            throw new ParseException("Failed to create XML reader", (Throwable)e);
        }
        return parser;
    }

    public ResourceReferenceParser getLinkReferenceParser() {
        return this.linkReferenceParser;
    }

    public ResourceReferenceParser getImageReferenceParser() {
        return this.imageReferenceParser;
    }

    public XWikiGeneratorListener createXWikiGeneratorListener(Listener listener, IdGenerator idGenerator) {
        return new XHTMLXWikiGeneratorListener(this.getLinkLabelParser(), listener, this.getLinkReferenceParser(), this.getImageReferenceParser(), this.plainRendererFactory, idGenerator, this.getSyntax());
    }
}

