/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml.link;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkTypeRenderer;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultXHTMLLinkRenderer
implements XHTMLLinkRenderer {
    @Inject
    private XHTMLLinkTypeRenderer defaultLinkTypeRenderer;
    @Inject
    @Named(value="context")
    protected Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Logger logger;
    private XHTMLWikiPrinter xhtmlPrinter;
    private boolean hasLabel;

    @Override
    public void setHasLabel(boolean hasLabel) {
        this.hasLabel = hasLabel;
    }

    @Override
    public void setXHTMLWikiPrinter(XHTMLWikiPrinter printer) {
        this.xhtmlPrinter = printer;
    }

    @Override
    public XHTMLWikiPrinter getXHTMLWikiPrinter() {
        return this.xhtmlPrinter;
    }

    public void beginLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.getXHTMLLinkTypeRenderer(reference).beginLink(reference, freestanding, parameters);
    }

    public void endLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.getXHTMLLinkTypeRenderer(reference).endLink(reference, freestanding, parameters);
    }

    private XHTMLLinkTypeRenderer getXHTMLLinkTypeRenderer(ResourceReference reference) {
        XHTMLLinkTypeRenderer renderer = this.defaultLinkTypeRenderer;
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        if (componentManager.hasComponent(XHTMLLinkTypeRenderer.class, reference.getType().getScheme())) {
            try {
                renderer = (XHTMLLinkTypeRenderer)((ComponentManager)this.componentManagerProvider.get()).getInstance(XHTMLLinkTypeRenderer.class, reference.getType().getScheme());
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to initialize XHTML link type renderer", (Throwable)e);
            }
        }
        renderer.setHasLabel(this.hasLabel);
        renderer.setXHTMLWikiPrinter(this.getXHTMLWikiPrinter());
        return renderer;
    }
}

