/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml.image;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.annotation.Default;
import org.xwiki.rendering.internal.renderer.xhtml.image.XHTMLImageRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.image.XHTMLImageTypeRenderer;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultXHTMLImageRenderer
implements XHTMLImageRenderer {
    @Inject
    private XHTMLImageTypeRenderer defaultImageTypeRenderer;
    @Inject
    @Named(value="context")
    protected Provider<ComponentManager> componentManagerProvider;
    private XHTMLWikiPrinter xhtmlPrinter;

    @Override
    public void setXHTMLWikiPrinter(XHTMLWikiPrinter printer) {
        this.xhtmlPrinter = printer;
    }

    @Override
    public XHTMLWikiPrinter getXHTMLWikiPrinter() {
        return this.xhtmlPrinter;
    }

    public void onImage(ResourceReference reference, boolean freestanding, @Default(value="") Map<String, String> parameters) {
        this.getXHTMLImageTypeRenderer(reference).onImage(reference, freestanding, parameters);
    }

    private XHTMLImageTypeRenderer getXHTMLImageTypeRenderer(ResourceReference reference) {
        XHTMLImageTypeRenderer renderer;
        try {
            renderer = (XHTMLImageTypeRenderer)((ComponentManager)this.componentManagerProvider.get()).getInstance(XHTMLImageTypeRenderer.class, reference.getType().getScheme());
        }
        catch (ComponentLookupException e) {
            renderer = this.defaultImageTypeRenderer;
        }
        renderer.setXHTMLWikiPrinter(this.getXHTMLWikiPrinter());
        return renderer;
    }
}

