/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10.velocity;

import java.util.ArrayList;
import java.util.List;
import org.xwiki.component.logging.Logger;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.parser.xwiki10.HTMLFilter;
import org.xwiki.rendering.internal.parser.xwiki10.velocity.ExtendedVelocityParserContext;
import org.xwiki.rendering.parser.xwiki10.macro.VelocityMacroConverter;
import org.xwiki.velocity.internal.util.InvalidVelocityException;
import org.xwiki.velocity.internal.util.VelocityBlock;
import org.xwiki.velocity.internal.util.VelocityParser;
import org.xwiki.velocity.internal.util.VelocityParserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedVelocityParser
extends VelocityParser {
    private ComponentManager componentManager;

    public ExtendedVelocityParser(ComponentManager componentManager, Logger logger) {
        super(logger);
        this.componentManager = componentManager;
    }

    public int getDirective(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) throws InvalidVelocityException {
        int i = currentIndex + 1;
        ExtendedVelocityParserContext econtext = (ExtendedVelocityParserContext)context;
        StringBuffer directiveNameBuffer = new StringBuffer();
        i = this.getDirectiveName(array, i, directiveNameBuffer, null, context);
        String directiveName = directiveNameBuffer.toString();
        StringBuffer directiveBuffer = new StringBuffer();
        if (VELOCITYDIRECTIVE_ALL.contains(directiveName)) {
            if (VELOCITYDIRECTIVE_END.contains(directiveName)) {
                if ("macro".equals(context.getCurrentElement().getName())) {
                    HTMLFilter.appendHTMLClose(directiveBuffer, econtext.getFilterContext(), true);
                }
                context.popVelocityElement();
            }
            directiveBuffer.append(array, currentIndex, i - currentIndex);
            if (!VELOCITYDIRECTIVE_NOPARAM.contains(directiveName)) {
                if ((i = this.getSpaces(array, i, directiveBuffer, context)) < array.length && array[i] == '(') {
                    i = this.getMethodParameters(array, i, directiveBuffer, context);
                } else {
                    throw new InvalidVelocityException();
                }
            }
            i = this.getDirectiveEndOfLine(array, i, directiveBuffer, context);
            econtext.setVelocity(true);
            context.setType(VelocityBlock.VelocityType.DIRECTIVE);
            if (VELOCITYDIRECTIVE_BEGIN.contains(directiveName)) {
                context.pushVelocityElement(new VelocityBlock(directiveName, VelocityBlock.VelocityType.DIRECTIVE));
                if ("macro".equals(directiveName)) {
                    HTMLFilter.appendHTMLOpen(directiveBuffer, econtext.getFilterContext(), true);
                }
            }
        } else {
            directiveBuffer.append(array, currentIndex, i - currentIndex);
            i = this.getSpaces(array, i, directiveBuffer, context);
            if (i < array.length && array[i] == '(') {
                ((ExtendedVelocityParserContext)context).setInline(true);
                ArrayList<String> parameters = new ArrayList<String>();
                i = this.getMacroParameters(array, i, directiveBuffer, parameters, econtext);
                String convertedMacro = this.convertMacro(directiveName, parameters, econtext);
                if (convertedMacro != null) {
                    directiveBuffer.setLength(0);
                    directiveBuffer.append(convertedMacro);
                } else {
                    econtext.setVelocity(true);
                    context.setType(VelocityBlock.VelocityType.MACRO);
                }
            } else {
                throw new InvalidVelocityException();
            }
        }
        velocityBlock.append(directiveBuffer);
        return i;
    }

    public String convertMacro(String name, List<String> parameters, ExtendedVelocityParserContext context) {
        String convertedMacro;
        block5: {
            convertedMacro = null;
            try {
                VelocityMacroConverter currentMacro = (VelocityMacroConverter)this.componentManager.lookup(VelocityMacroConverter.class, name);
                convertedMacro = currentMacro.convert(name, parameters, context.getFilterContext());
                if (convertedMacro != null) {
                    context.setInline(currentMacro.isInline());
                    context.setProtectedBlock(currentMacro.protectResult());
                    context.setConversion(true);
                }
            }
            catch (ComponentLookupException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Can't find macro converter [" + name + "]", (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isDebugEnabled()) break block5;
                this.getLogger().debug("Failed to convert macro [" + name + "]", (Throwable)e);
            }
        }
        return convertedMacro;
    }

    public int getMacroParameters(char[] array, int currentIndex, StringBuffer velocityBlock, List<String> parameterList, ExtendedVelocityParserContext context) {
        velocityBlock.append('(');
        int i = currentIndex + 1;
        boolean isVelocity = false;
        while (i < array.length) {
            if ((i = this.getMacroParametersSeparator(array, i, velocityBlock, context)) >= array.length) continue;
            if (array[i] == ')') {
                velocityBlock.append(')');
                ++i;
                break;
            }
            StringBuffer parameterBlock = new StringBuffer();
            i = this.getMacroParameter(array, i, parameterBlock, context);
            isVelocity |= context.isVelocity();
            parameterList.add(parameterBlock.toString());
            velocityBlock.append(parameterBlock);
        }
        context.setVelocity(isVelocity);
        return i;
    }

    public int getSimpleComment(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) {
        ((ExtendedVelocityParserContext)context).setVelocity(true);
        ((ExtendedVelocityParserContext)context).setInline(true);
        return super.getSimpleComment(array, currentIndex, velocityBlock, context);
    }

    public int getMultilinesComment(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) {
        ((ExtendedVelocityParserContext)context).setVelocity(true);
        ((ExtendedVelocityParserContext)context).setInline(true);
        return super.getMultilinesComment(array, currentIndex, velocityBlock, context);
    }

    public int getEscape(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) {
        char escapeChar = array[currentIndex];
        int i = currentIndex + 1;
        boolean isVelocity = false;
        boolean escaped = false;
        while (i < array.length) {
            if (!escaped) {
                if (array[i] == '\\') {
                    escaped = true;
                } else if (array[i] == '$') {
                    try {
                        i = this.getVar(array, i, null, context);
                        isVelocity = true;
                        continue;
                    }
                    catch (InvalidVelocityException e) {
                        this.getLogger().debug("Not a valid variable at char [" + i + "]", (Throwable)e);
                    }
                } else if (array[i] == escapeChar) {
                    ++i;
                    break;
                }
            } else {
                escaped = false;
            }
            ++i;
        }
        if (velocityBlock != null) {
            velocityBlock.append(array, currentIndex, i - currentIndex);
        }
        ((ExtendedVelocityParserContext)context).setVelocity(isVelocity);
        return i;
    }

    public int getVar(char[] array, int currentIndex, StringBuffer velocityBlock, VelocityParserContext context) throws InvalidVelocityException {
        StringBuffer varName = new StringBuffer();
        int i = super.getVar(array, currentIndex, varName, null, context);
        if (velocityBlock != null) {
            if ("msg".equals(varName.toString())) {
                velocityBlock.append("{{html clean=\"false\"}}");
                velocityBlock.append(array, currentIndex, i - currentIndex);
                velocityBlock.append("{{/html}}");
            } else {
                velocityBlock.append(array, currentIndex, i - currentIndex);
            }
        }
        ((ExtendedVelocityParserContext)context).setVelocity(true);
        return i;
    }
}

