/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;

@Component
@Named(value="spacescleanning")
@Singleton
public class SpacesCleaningFilter
extends AbstractFilter
implements Initializable {
    private static final Pattern SPACES_PATTERN = Pattern.compile("([^ ])[ \\t]+([^ ])");

    public void initialize() throws InitializationException {
        this.setPriority(4001);
    }

    @Override
    public String filter(String content, FilterContext filterContext) {
        return SPACES_PATTERN.matcher(content).replaceAll("$1 $2");
    }
}

