/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.parser.xwiki10.VelocityFilter;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.util.CleanUtil;

@Component
@Named(value="section")
@Singleton
public class SectionSyntaxFilter
extends AbstractFilter
implements Initializable {
    private static final Pattern SECTIONSYNTAX_PATTERN = Pattern.compile("^(" + VelocityFilter.SPACEGROUP_OC_SPATTERN + ")?(1(\\.1){0,5}+)[ \\t]++(.++)$", 8);

    public void initialize() throws InitializationException {
        this.setPriority(1000);
    }

    @Override
    public String filter(String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = SECTIONSYNTAX_PATTERN.matcher(content);
        int currentIndex = 0;
        while (matcher.find()) {
            String before = content.substring(currentIndex, matcher.start());
            before = before + matcher.group(1);
            if (currentIndex > 0) {
                before = CleanUtil.removeLeadingNewLines(before);
                before = "\n\n" + before;
            }
            result.append(before);
            CleanUtil.setTrailingNewLines(result, 2);
            String headerSyntax = filterContext.addProtectedContent(StringUtils.repeat((char)'=', (int)((matcher.group(2).length() + 1) / 2)), false);
            String headerContent = headerSyntax + ' ' + matcher.group(4) + ' ' + headerSyntax;
            result.append(CleanUtil.extractVelocity(headerContent, filterContext));
            currentIndex = matcher.end();
        }
        if (currentIndex == 0) {
            return content;
        }
        String end = content.substring(currentIndex);
        if (currentIndex > 0) {
            end = CleanUtil.removeLeadingNewLines(end);
            end = "\n\n" + end;
        }
        result.append(end);
        return result.toString();
    }
}

