/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.parser.XDOMGeneratorListener;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.parser.xwiki10.Filter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.util.CleanUtil;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;

@Component
@Named(value="xwiki/1.0")
@Singleton
public class XWikiParser
implements StreamParser,
Parser,
Initializable {
    private static final Syntax SYNTAX = new Syntax(SyntaxType.XWIKI, "1.0");
    @Inject
    @Named(value="xwiki/2.0")
    private StreamParser xwiki20Parser;
    @Inject
    private List<Filter> filters;

    public void initialize() throws InitializationException {
        Collections.sort(this.filters, new Comparator<Filter>(){

            @Override
            public int compare(Filter filter1, Filter filter2) {
                return filter1.getPriority() - filter2.getPriority();
            }
        });
    }

    public Syntax getSyntax() {
        return SYNTAX;
    }

    public XDOM parse(Reader source) throws ParseException {
        XDOMGeneratorListener listener = new XDOMGeneratorListener();
        this.parse(source, (Listener)listener);
        return listener.getXDOM();
    }

    public String xwiki10To20(Reader source) throws ParseException {
        String content;
        try {
            content = IOUtils.toString((Reader)source);
        }
        catch (IOException e) {
            throw new ParseException("Failed to read source", (Throwable)e);
        }
        FilterContext filterContext = new FilterContext();
        for (Filter filter : this.filters) {
            content = filter.filter(content, filterContext);
        }
        content = filterContext.unProtect(content);
        content = CleanUtil.removeLeadingNewLines(content);
        content = CleanUtil.removeTrailingNewLines(content);
        return content;
    }

    public void parse(Reader source, Listener listener) throws ParseException {
        String content20 = this.xwiki10To20(source);
        this.xwiki20Parser.parse((Reader)new StringReader(content20), listener);
    }
}

