/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10.macro;

import java.util.StringTokenizer;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.macro.AbstractRadeoxMacroConverter;
import org.xwiki.rendering.parser.xwiki10.macro.RadeoxMacroParameters;

@Component
@Named(value="table")
@Singleton
public class TableRadeoxMacroConverter
extends AbstractRadeoxMacroConverter {
    @Override
    public String convert(String name, RadeoxMacroParameters parameters, String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(content, "|\n", true);
        String lastToken = null;
        boolean firstCell = true;
        int nbLines = 0;
        while (tokenizer.hasMoreTokens()) {
            String value;
            String token = tokenizer.nextToken();
            if (token.indexOf(91) != -1 && token.indexOf(93) == -1) {
                String linkToken = "";
                while (token.indexOf(93) == -1 && tokenizer.hasMoreTokens()) {
                    linkToken = linkToken + token;
                    token = tokenizer.nextToken();
                }
                token = linkToken + token;
            }
            if ("\n".equals(token)) {
                String string = lastToken = lastToken == null ? "" : lastToken;
                if (!lastToken.endsWith("\\")) {
                    if (("".equals(lastToken) || "|".equals(lastToken)) && !firstCell) {
                        result.append(filterContext.addProtectedContent(nbLines == 1 ? "|=" : "|", false));
                        result.append(" ");
                    }
                    if (nbLines > 0) {
                        result.append('\n');
                    }
                    ++nbLines;
                } else {
                    String cell = lastToken;
                    while (cell.endsWith("\\") && tokenizer.hasMoreTokens() && !"|".equals(token = tokenizer.nextToken())) {
                        cell = cell + token;
                    }
                    firstCell = false;
                    result.append(filterContext.addProtectedContent(nbLines == 1 ? "|=" : "|", false));
                    result.append(cell.trim());
                    if (!tokenizer.hasMoreTokens()) {
                        result.append('\n');
                        ++nbLines;
                    }
                }
            } else if (!"|".equals(token)) {
                if (!token.endsWith("\\")) {
                    result.append(filterContext.addProtectedContent(nbLines == 1 ? "|=" : "|", false));
                    value = token.trim();
                    result.append(value.length() > 0 ? value : " ");
                    firstCell = false;
                } else if (!tokenizer.hasMoreTokens()) {
                    while (token.endsWith("\\")) {
                        token = token.substring(0, token.length() - 1);
                    }
                    result.append(filterContext.addProtectedContent(nbLines == 1 ? "|=" : "|", false));
                    value = token.trim();
                    result.append(value.length() > 0 ? value : " ");
                }
            } else if ("|".equals(token)) {
                if ((null == lastToken || "".equals(lastToken)) && !firstCell || "|".equals(lastToken)) {
                    result.append(filterContext.addProtectedContent(nbLines == 1 ? "|=" : "|", false));
                    result.append(" ");
                    firstCell = false;
                } else if (lastToken.endsWith("\\")) {
                    result.append(filterContext.addProtectedContent(nbLines == 1 ? "|=" : "|", false));
                    value = lastToken.trim();
                    result.append(value.length() > 0 ? value : " ");
                    firstCell = false;
                }
            }
            lastToken = token;
        }
        return result.toString();
    }

    @Override
    public boolean supportContent() {
        return true;
    }

    @Override
    public boolean isInline() {
        return false;
    }

    @Override
    public boolean protectResult() {
        return false;
    }
}

