/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki20;

import org.junit.Assert;
import org.junit.Test;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.InterWikiResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.wiki.WikiModel;
import org.xwiki.test.jmock.AbstractComponentTestCase;

public class XWiki20LinkReferenceParserTest
extends AbstractComponentTestCase {
    protected ResourceReferenceParser parser;

    protected void registerComponents() throws Exception {
        this.registerMockComponent(WikiModel.class);
        this.parser = (ResourceReferenceParser)this.getComponentManager().getInstance(ResourceReferenceParser.class, "xwiki/2.0/link");
    }

    @Test
    public void testParseLinksWhenInWikiModeCommon() throws Exception {
        ResourceReference reference = this.parser.parse("");
        Assert.assertEquals((Object)"", (Object)reference.getReference());
        Assert.assertFalse((boolean)reference.isTyped());
        Assert.assertEquals((Object)ResourceType.DOCUMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"Typed = [false] Type = [doc] Reference = []", (Object)reference.toString());
        reference = this.parser.parse("Hello World");
        Assert.assertEquals((Object)"Hello World", (Object)reference.getReference());
        Assert.assertFalse((boolean)reference.isTyped());
        Assert.assertEquals((Object)ResourceType.DOCUMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"Typed = [false] Type = [doc] Reference = [Hello World]", (Object)reference.toString());
        reference = this.parser.parse("http://xwiki.org");
        Assert.assertEquals((Object)"http://xwiki.org", (Object)reference.getReference());
        Assert.assertFalse((boolean)reference.isTyped());
        Assert.assertEquals((Object)ResourceType.URL, (Object)reference.getType());
        Assert.assertEquals((Object)"Typed = [false] Type = [url] Reference = [http://xwiki.org]", (Object)reference.toString());
        reference = this.parser.parse("mailto:john@smith.com?subject=test");
        Assert.assertEquals((Object)"john@smith.com?subject=test", (Object)reference.getReference());
        Assert.assertTrue((boolean)reference.isTyped());
        Assert.assertEquals((Object)ResourceType.MAILTO, (Object)reference.getType());
        Assert.assertEquals((Object)"Typed = [true] Type = [mailto] Reference = [john@smith.com?subject=test]", (Object)reference.toString());
        reference = this.parser.parse("attach:some:content");
        Assert.assertEquals((Object)"some:content", (Object)reference.getReference());
        Assert.assertTrue((boolean)reference.isTyped());
        Assert.assertEquals((Object)ResourceType.ATTACHMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"Typed = [true] Type = [attach] Reference = [some:content]", (Object)reference.toString());
        reference = this.parser.parse("mywiki:http://xwiki.org");
        Assert.assertEquals((Object)"mywiki:http://xwiki.org", (Object)reference.getReference());
        Assert.assertFalse((boolean)reference.isTyped());
        Assert.assertEquals((Object)ResourceType.DOCUMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"Typed = [false] Type = [doc] Reference = [mywiki:http://xwiki.org]", (Object)reference.toString());
    }

    @Test
    public void testParseLinksWhenInWikiMode() throws Exception {
        ResourceReference reference = this.parser.parse("Hello World?xredirect=../whatever");
        Assert.assertEquals((Object)"Hello World", (Object)reference.getReference());
        Assert.assertEquals((Object)"xredirect=../whatever", (Object)((DocumentResourceReference)reference).getQueryString());
        Assert.assertFalse((boolean)reference.isTyped());
        Assert.assertEquals((Object)ResourceType.DOCUMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"Typed = [false] Type = [doc] Reference = [Hello World] Parameters = [[queryString] = [xredirect=../whatever]]", (Object)reference.toString());
        reference = this.parser.parse("HelloWorld?xredirect=http://xwiki.org");
        Assert.assertEquals((Object)"HelloWorld", (Object)reference.getReference());
        Assert.assertEquals((Object)"xredirect=http://xwiki.org", (Object)((DocumentResourceReference)reference).getQueryString());
        Assert.assertFalse((boolean)reference.isTyped());
        Assert.assertEquals((Object)ResourceType.DOCUMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"Typed = [false] Type = [doc] Reference = [HelloWorld] Parameters = [[queryString] = [xredirect=http://xwiki.org]]", (Object)reference.toString());
        reference = this.parser.parse("#anchor");
        Assert.assertEquals((Object)"anchor", (Object)((DocumentResourceReference)reference).getAnchor());
        Assert.assertFalse((boolean)reference.isTyped());
        Assert.assertEquals((Object)ResourceType.DOCUMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"Typed = [false] Type = [doc] Reference = [] Parameters = [[anchor] = [anchor]]", (Object)reference.toString());
        reference = this.parser.parse("Hello#anchor");
        Assert.assertEquals((Object)"Hello", (Object)reference.getReference());
        Assert.assertEquals((Object)"anchor", (Object)((DocumentResourceReference)reference).getAnchor());
        Assert.assertFalse((boolean)reference.isTyped());
        Assert.assertEquals((Object)ResourceType.DOCUMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"Typed = [false] Type = [doc] Reference = [Hello] Parameters = [[anchor] = [anchor]]", (Object)reference.toString());
        reference = this.parser.parse("HelloWorld#anchor?param1=1&param2=2@wikipedia");
        Assert.assertEquals((Object)"HelloWorld#anchor?param1=1&param2=2", (Object)reference.getReference());
        Assert.assertEquals((Object)"wikipedia", (Object)((InterWikiResourceReference)reference).getInterWikiAlias());
        Assert.assertTrue((boolean)reference.isTyped());
        Assert.assertEquals((Object)ResourceType.INTERWIKI, (Object)reference.getType());
        Assert.assertEquals((Object)"Typed = [true] Type = [interwiki] Reference = [HelloWorld#anchor?param1=1&param2=2] Parameters = [[interWikiAlias] = [wikipedia]]", (Object)reference.toString());
        reference = this.parser.parse("doc:whatever");
        Assert.assertEquals((Object)"doc:whatever", (Object)reference.getReference());
        Assert.assertFalse((boolean)reference.isTyped());
        Assert.assertEquals((Object)ResourceType.DOCUMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"Typed = [false] Type = [doc] Reference = [doc:whatever]", (Object)reference.toString());
    }

    @Test
    public void testParseLinksWithEscapes() throws Exception {
        ResourceReference reference = this.parser.parse("\\.\\#notanchor");
        Assert.assertEquals((Object)ResourceType.DOCUMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"\\.#notanchor", (Object)reference.getReference());
        Assert.assertNull((Object)((DocumentResourceReference)reference).getAnchor());
        reference = this.parser.parse("page\\?notquerystring");
        Assert.assertEquals((Object)ResourceType.DOCUMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"page?notquerystring", (Object)reference.getReference());
        Assert.assertNull((Object)((DocumentResourceReference)reference).getQueryString());
        reference = this.parser.parse("page\\\\#anchor\\\\?querystring\\\\");
        Assert.assertEquals((Object)ResourceType.DOCUMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"page\\\\", (Object)reference.getReference());
        Assert.assertEquals((Object)"anchor\\", (Object)((DocumentResourceReference)reference).getAnchor());
        Assert.assertEquals((Object)"querystring\\", (Object)((DocumentResourceReference)reference).getQueryString());
        reference = this.parser.parse("pa\\.ge\\?query\\#anchor\\@notinterwiki");
        Assert.assertEquals((Object)ResourceType.DOCUMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"pa\\.ge?query#anchor@notinterwiki", (Object)reference.getReference());
        reference = this.parser.parse("page\\\\#anchor\\\\?querystring\\\\@alias\\\\");
        Assert.assertEquals((Object)ResourceType.INTERWIKI, (Object)reference.getType());
        Assert.assertEquals((Object)"page\\#anchor\\?querystring\\", (Object)reference.getReference());
        Assert.assertEquals((Object)"alias\\", (Object)((InterWikiResourceReference)reference).getInterWikiAlias());
        reference = this.parser.parse("something\\\\@inter\\@wikilink");
        Assert.assertEquals((Object)ResourceType.INTERWIKI, (Object)reference.getType());
        Assert.assertEquals((Object)"something\\", (Object)reference.getReference());
        Assert.assertEquals((Object)"inter@wikilink", (Object)((InterWikiResourceReference)reference).getInterWikiAlias());
    }
}

