/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xwiki20.reference;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.internal.parser.plain.PlainTextStreamParser;
import org.xwiki.rendering.internal.renderer.ParametersPrinter;
import org.xwiki.rendering.internal.renderer.xwiki20.XWikiSyntaxEscapeWikiPrinter;
import org.xwiki.rendering.internal.renderer.xwiki20.XWikiSyntaxListenerChain;
import org.xwiki.rendering.listener.QueueListener;
import org.xwiki.rendering.listener.chaining.EventType;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.reference.ResourceReferenceSerializer;

public class XWikiSyntaxResourceRenderer {
    protected static final String PARAMETER_SEPARATOR = "||";
    protected static final ParametersPrinter PARAMETERS_PRINTER = new ParametersPrinter('~', new String[]{"||", "]]", ">>"});
    private Deque<Boolean> forceFullSyntax = new ArrayDeque<Boolean>();
    private XWikiSyntaxListenerChain listenerChain;
    private ResourceReferenceSerializer referenceSerializer;

    public XWikiSyntaxResourceRenderer(XWikiSyntaxListenerChain listenerChain, ResourceReferenceSerializer referenceSerializer) {
        this.listenerChain = listenerChain;
        this.referenceSerializer = referenceSerializer;
        this.forceFullSyntax.push(false);
    }

    public String serialize(ResourceReference reference, boolean isFreeStanding) {
        String result = this.referenceSerializer.serialize(reference);
        if (!isFreeStanding) {
            result = result.replace("~", "~~").replace(">>", "~>~>").replace(PARAMETER_SEPARATOR, "~|~|");
        }
        return result;
    }

    public void beginRenderLink(XWikiSyntaxEscapeWikiPrinter printer, ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        boolean isLastSyntax = printer.getBuffer().length() == 0;
        printer.flush();
        if (this.forceFullSyntax(printer, isLastSyntax, freestanding, parameters)) {
            this.forceFullSyntax.push(true);
            printer.print("[[");
        } else {
            this.forceFullSyntax.push(false);
        }
    }

    public boolean forceFullSyntax(XWikiSyntaxEscapeWikiPrinter printer, boolean freestanding, Map<String, String> parameters) {
        return this.forceFullSyntax(printer, true, freestanding, parameters);
    }

    public boolean forceFullSyntax(XWikiSyntaxEscapeWikiPrinter printer, boolean isLastSyntax, boolean freestanding, Map<String, String> parameters) {
        QueueListener.Event nextEvent = this.listenerChain.getLookaheadChainingListener().getNextEvent();
        return !freestanding || !parameters.isEmpty() || !isLastSyntax && !printer.isAfterWhiteSpace() && !PlainTextStreamParser.SPECIALSYMBOL_PATTERN.matcher(String.valueOf(printer.getLastPrinted().charAt(printer.getLastPrinted().length() - 1))).matches() || nextEvent != null && nextEvent.eventType != EventType.ON_SPACE && nextEvent.eventType != EventType.ON_NEW_LINE && nextEvent.eventType != EventType.END_PARAGRAPH && nextEvent.eventType != EventType.END_LINK && nextEvent.eventType != EventType.END_LIST_ITEM && nextEvent.eventType != EventType.END_DEFINITION_DESCRIPTION && nextEvent.eventType != EventType.END_DEFINITION_TERM && nextEvent.eventType != EventType.END_QUOTATION_LINE && nextEvent.eventType != EventType.END_SECTION;
    }

    public void renderLinkContent(XWikiSyntaxEscapeWikiPrinter printer, String label) {
        if (!StringUtils.isEmpty((CharSequence)label)) {
            printer.print(label);
            printer.print(">>");
        }
    }

    public void endRenderLink(XWikiSyntaxEscapeWikiPrinter printer, ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        printer.print(this.serialize(reference, freestanding));
        this.printParameters(printer, reference, parameters);
        if (this.forceFullSyntax.peek().booleanValue() || !freestanding) {
            printer.print("]]");
        }
        this.forceFullSyntax.pop();
    }

    protected void printParameters(XWikiSyntaxEscapeWikiPrinter printer, ResourceReference resourceReference, Map<String, String> parameters) {
        if (!parameters.isEmpty()) {
            printer.print(PARAMETER_SEPARATOR);
            printer.print(PARAMETERS_PRINTER.print(parameters));
        }
    }
}

