/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki21;

import java.util.Map;
import org.xwiki.rendering.internal.parser.wikimodel.DefaultXWikiGeneratorListener;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.IdGenerator;

public class XWiki21XWikiGeneratorListener
extends DefaultXWikiGeneratorListener {
    private static final String QUERY_STRING = "queryString";
    private static final String ANCHOR = "anchor";

    public XWiki21XWikiGeneratorListener(StreamParser parser, Listener listener, ResourceReferenceParser linkReferenceParser, ResourceReferenceParser imageReferenceParser, PrintRendererFactory plainRendererFactory, IdGenerator idGenerator, Syntax syntax) {
        super(parser, listener, linkReferenceParser, imageReferenceParser, plainRendererFactory, idGenerator, syntax);
    }

    protected void onReference(ResourceReference reference, String label, boolean isFreeStandingURI, Map<String, String> parameters) {
        String queryString;
        ResourceType resourceType = reference.getType();
        if (ResourceType.DOCUMENT.equals((Object)resourceType) || ResourceType.SPACE.equals((Object)resourceType)) {
            String anchor;
            String queryString2 = parameters.remove(QUERY_STRING);
            if (queryString2 != null) {
                reference.setParameter(QUERY_STRING, queryString2);
            }
            if ((anchor = parameters.remove(ANCHOR)) != null) {
                reference.setParameter(ANCHOR, anchor);
            }
        } else if (ResourceType.ATTACHMENT.equals((Object)resourceType) && (queryString = parameters.remove(QUERY_STRING)) != null) {
            reference.setParameter(QUERY_STRING, queryString);
        }
        super.onReference(reference, label, isFreeStandingURI, parameters);
    }

    protected void onImage(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        String queryString;
        if (ResourceType.ATTACHMENT.equals((Object)reference.getType()) && (queryString = parameters.remove(QUERY_STRING)) != null) {
            reference.setParameter(QUERY_STRING, queryString);
        }
        super.onImage(reference, isFreeStandingURI, parameters);
    }
}

