/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.cts;

import java.lang.reflect.Method;
import java.util.List;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.test.cts.Initialized;
import org.xwiki.rendering.test.cts.TestData;
import org.xwiki.test.annotation.AllComponents;
import org.xwiki.test.annotation.ComponentList;
import org.xwiki.test.jmock.XWikiComponentInitializer;
import org.xwiki.test.mockito.MockitoComponentManager;

public class RenderingTestClassRunner
extends BlockJUnit4ClassRunner {
    private XWikiComponentInitializer componentInitializer = new XWikiComponentInitializer();
    private final MockitoComponentManager mockitoComponentManager = new MockitoComponentManager();
    private Object testInstance;
    private TestData testData;
    private String metadataSyntaxId;

    RenderingTestClassRunner(Object testInstance, Class<?> testClass, TestData testData, String metadataSyntaxId) throws InitializationError {
        super(testClass);
        this.testInstance = testInstance;
        this.testData = testData;
        this.metadataSyntaxId = metadataSyntaxId;
    }

    public Object createTest() throws Exception {
        return this.getTestClass().getOnlyConstructor().newInstance(this.testData, this.metadataSyntaxId, this.getComponentManager());
    }

    protected String getName() {
        return this.testData.computeTestName();
    }

    protected String testName(FrameworkMethod method) {
        return this.getName();
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
    }

    protected Statement classBlock(RunNotifier notifier) {
        return this.childrenInvoker(notifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        this.initializeComponentManager(notifier);
        try {
            for (Method klassMethod : this.testInstance.getClass().getMethods()) {
                Initialized componentManagerAnnotation = klassMethod.getAnnotation(Initialized.class);
                if (componentManagerAnnotation == null) continue;
                klassMethod.invoke(this.testInstance, this.getComponentManager());
            }
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)new RuntimeException("Failed to call Component Manager initialization method", e)));
        }
        try {
            super.runChild(method, notifier);
        }
        finally {
            try {
                this.componentInitializer.shutdown();
            }
            catch (Exception e) {
                notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)new RuntimeException("Failed to shutdown Component Manager", e)));
            }
        }
    }

    private void initializeComponentManager(RunNotifier notifier) {
        try {
            if (this.isLegacyMode()) {
                this.componentInitializer.initializeConfigurationSource();
                this.componentInitializer.initializeExecution();
            } else {
                this.mockitoComponentManager.initializeTest(this.testInstance, new Object[0]);
                this.mockitoComponentManager.registerMemoryConfigurationSource();
            }
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)new RuntimeException("Failed to initialize Component Manager", e)));
        }
    }

    private boolean isLegacyMode() {
        boolean isLegacyMode = true;
        for (Method klassMethod : this.testInstance.getClass().getMethods()) {
            Initialized componentManagerAnnotation = klassMethod.getAnnotation(Initialized.class);
            if (componentManagerAnnotation == null) continue;
            if (!MockitoComponentManager.class.isAssignableFrom(klassMethod.getParameterTypes()[0])) break;
            isLegacyMode = false;
            break;
        }
        if (isLegacyMode && (this.testInstance.getClass().getAnnotation(AllComponents.class) != null || this.testInstance.getClass().getAnnotation(ComponentList.class) != null)) {
            isLegacyMode = false;
        }
        return isLegacyMode;
    }

    private ComponentManager getComponentManager() throws Exception {
        if (this.isLegacyMode()) {
            return this.componentInitializer.getComponentManager();
        }
        return this.mockitoComponentManager;
    }
}

