/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.integration;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.test.integration.SyntaxWrappingListener;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationManager;
import org.xwiki.test.internal.MockConfigurationSource;

public abstract class AbstractRenderingTest {
    private static final String SPECIAL_SYNTAX_START = "${{{";
    private static final String SPECIAL_SYNTAX_END = "}}}";
    private String input;
    private String expected;
    private String parserId;
    private String targetSyntaxId;
    private boolean streaming;
    private List<String> transformations;
    private Map<String, ?> configuration;
    private ComponentManager componentManager;

    public AbstractRenderingTest(String input, String expected, String parserId, String targetSyntaxId, boolean streaming, List<String> transformations, Map<String, ?> configuration, ComponentManager componentManager) {
        this.input = input;
        this.expected = expected;
        this.parserId = parserId;
        this.targetSyntaxId = targetSyntaxId;
        this.streaming = streaming;
        this.transformations = transformations;
        this.configuration = configuration;
        this.componentManager = componentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        MockConfigurationSource mockConfigurationSource;
        ConfigurationSource configurationSource;
        HashMap<String, Object> originalConfiguration = new HashMap<String, Object>();
        if (this.configuration != null && (configurationSource = (ConfigurationSource)this.getComponentManager().getInstance(ConfigurationSource.class)) instanceof MockConfigurationSource) {
            mockConfigurationSource = (MockConfigurationSource)configurationSource;
            for (Map.Entry<String, ?> entry : this.configuration.entrySet()) {
                originalConfiguration.put(entry.getKey(), mockConfigurationSource.getProperty(entry.getKey()));
                mockConfigurationSource.setProperty(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.runTestInternal();
        }
        catch (Throwable throwable) {
            ConfigurationSource configurationSource2;
            if (this.configuration != null && (configurationSource2 = (ConfigurationSource)this.getComponentManager().getInstance(ConfigurationSource.class)) instanceof MockConfigurationSource) {
                MockConfigurationSource mockConfigurationSource2 = (MockConfigurationSource)configurationSource2;
                for (Map.Entry entry : originalConfiguration.entrySet()) {
                    if (entry.getValue() == null) {
                        mockConfigurationSource2.removeProperty((String)entry.getKey());
                        continue;
                    }
                    mockConfigurationSource2.setProperty((String)entry.getKey(), entry.getValue());
                }
            }
            throw throwable;
        }
        if (this.configuration != null && (configurationSource = (ConfigurationSource)this.getComponentManager().getInstance(ConfigurationSource.class)) instanceof MockConfigurationSource) {
            mockConfigurationSource = (MockConfigurationSource)configurationSource;
            for (Map.Entry<String, Object> entry : originalConfiguration.entrySet()) {
                if (entry.getValue() == null) {
                    mockConfigurationSource.removeProperty(entry.getKey());
                    continue;
                }
                mockConfigurationSource.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestInternal() throws Exception {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        StreamParser streamParser = (StreamParser)this.getComponentManager().getInstance(StreamParser.class, this.parserId);
        ExecutionContext executionContext = new ExecutionContext();
        ExecutionContextManager executionContextManager = (ExecutionContextManager)this.componentManager.getInstance(ExecutionContextManager.class);
        executionContextManager.initialize(executionContext);
        RenderingContext renderingContext = (RenderingContext)this.componentManager.getInstance(RenderingContext.class);
        ((MutableRenderingContext)renderingContext).push(renderingContext.getTransformation(), renderingContext.getXDOM(), streamParser.getSyntax(), renderingContext.getTransformationId(), renderingContext.isRestricted(), this.getRendererSyntax());
        try {
            if (!this.streaming) {
                Parser parser = (Parser)this.getComponentManager().getInstance(Parser.class, this.parserId);
                XDOM xdom = parser.parse((Reader)new StringReader(this.input));
                if (this.transformations != null) {
                    this.runTransformations(xdom, streamParser);
                }
                BlockRenderer renderer = (BlockRenderer)this.getComponentManager().getInstance(BlockRenderer.class, this.targetSyntaxId);
                if (xdom.getMetaData() != null) {
                    HashMap metadataMap = new HashMap(xdom.getMetaData().getMetaData());
                    metadataMap.remove("syntax");
                    xdom = new XDOM(xdom.getChildren(), new MetaData(metadataMap));
                }
                renderer.render((Block)xdom, (WikiPrinter)printer);
            } else {
                PrintRendererFactory streamRendererFactory = (PrintRendererFactory)this.getComponentManager().getInstance(PrintRendererFactory.class, this.targetSyntaxId);
                SyntaxWrappingListener listener = new SyntaxWrappingListener();
                listener.setWrappedListener((Listener)streamRendererFactory.createRenderer((WikiPrinter)printer));
                streamParser.parse((Reader)new StringReader(this.input), (Listener)listener);
            }
        }
        finally {
            ((MutableRenderingContext)renderingContext).pop();
            Execution execution = (Execution)this.componentManager.getInstance(Execution.class);
            execution.removeContext();
        }
        this.assertExpectedResult(this.expected, printer.toString());
    }

    private void runTransformations(XDOM xdom, StreamParser streamParser) throws Exception {
        TransformationContext txContext = new TransformationContext(xdom, streamParser.getSyntax());
        txContext.setTargetSyntax(this.getRendererSyntax());
        txContext.setId("test");
        if (this.transformations.isEmpty()) {
            TransformationManager transformationManager = (TransformationManager)this.getComponentManager().getInstance(TransformationManager.class);
            transformationManager.performTransformations((Block)xdom, txContext);
        } else {
            for (String txHint : this.transformations) {
                Transformation transformation = (Transformation)this.getComponentManager().getInstance(Transformation.class, txHint);
                transformation.transform((Block)xdom, txContext);
            }
        }
    }

    private Syntax getRendererSyntax() throws Exception {
        Syntax syntax;
        if (this.getComponentManager().hasComponent(PrintRendererFactory.class, this.targetSyntaxId)) {
            PrintRendererFactory streamRendererFactory = (PrintRendererFactory)this.getComponentManager().getInstance(PrintRendererFactory.class, this.targetSyntaxId);
            syntax = streamRendererFactory.getSyntax();
        } else {
            syntax = Syntax.valueOf((String)this.targetSyntaxId);
        }
        return syntax;
    }

    private void assertExpectedResult(String expected, String result) {
        StringBuilder builder = new StringBuilder();
        this.normalizeExpectedValue(builder, expected);
        Pattern pattern = Pattern.compile(builder.toString(), 32);
        Matcher matcher = pattern.matcher(result);
        if (!matcher.matches()) {
            this.throwAssertionException("", expected, result);
        }
    }

    protected abstract void throwAssertionException(String var1, String var2, String var3);

    private void normalizeExpectedValue(StringBuilder builder, String expected) {
        String fullSpecialSyntaxStart = String.format("%sregex:", SPECIAL_SYNTAX_START);
        int pos = expected.indexOf(fullSpecialSyntaxStart);
        if (pos > -1) {
            builder.append(Pattern.quote(expected.substring(0, pos)));
            int pos2 = this.findPositionOfRegexEnd(expected, pos + fullSpecialSyntaxStart.length());
            if (pos2 == -1) {
                throw new RuntimeException("Invalid regex declaration: missing closing part }}}");
            }
            builder.append(expected.substring(pos + fullSpecialSyntaxStart.length(), pos2));
            this.normalizeExpectedValue(builder, expected.substring(pos2 + 3));
        } else {
            builder.append(Pattern.quote(expected));
        }
    }

    private int findPositionOfRegexEnd(String expected, int pos) {
        int result = expected.indexOf(SPECIAL_SYNTAX_END, pos);
        if (result > -1 && expected.charAt(result - 1) == '\\') {
            result = this.findPositionOfRegexEnd(expected, result + 1);
        }
        return result;
    }

    public ComponentManager getComponentManager() throws Exception {
        return this.componentManager;
    }
}

