/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.integration;

import com.google.common.base.Predicate;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.xwiki.rendering.test.integration.TestData;
import org.xwiki.rendering.test.integration.TestDataParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDataGenerator {
    private TestDataParser parser = new TestDataParser();

    public Collection<Object[]> generateData(String testPackage, String pattern) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls((Collection)ClasspathHelper.getUrlsForPackagePrefix((String)"")).filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)testPackage))));
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (String testResourceName : reflections.getResources(Pattern.compile(pattern))) {
            data.addAll(this.parseSingleResource(testResourceName));
        }
        return data;
    }

    private Collection<Object[]> parseSingleResource(String testResourceName) {
        TestData data;
        String resourceName = "/" + testResourceName;
        try {
            InputStream source = this.getClass().getResourceAsStream(resourceName);
            if (source == null) {
                throw new RuntimeException("Failed to find test file [" + resourceName + "]");
            }
            data = this.parser.parse(source, resourceName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read test data from [" + resourceName + "]", e);
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Map.Entry<String, String> entry : data.inputs.entrySet()) {
            for (String targetSyntaxId : data.expectations.keySet()) {
                String parserId = entry.getKey();
                String input = entry.getValue();
                if ("xhtml/1.0".equals(parserId) && !input.startsWith("<?xml") && !input.startsWith("<!DOCTYPE")) {
                    input = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html>" + input + "</html>";
                }
                Object[] singleResult = new Object[]{this.computeTestName(testResourceName, parserId, targetSyntaxId), input, data.expectations.get(targetSyntaxId), parserId, targetSyntaxId, data.streaming, data.runTransformations, data.configuration};
                result.add(singleResult);
            }
        }
        return result;
    }

    private String computeTestName(String prefix, String parserId, String targetSyntaxId) {
        return prefix + " [" + parserId + ", " + targetSyntaxId + "]";
    }
}

