/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.integration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.StringTokenizer;
import org.xwiki.rendering.test.integration.TestData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDataParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestData parse(InputStream source, String resourceName) throws IOException {
        TestData data = new TestData();
        BufferedReader reader = new BufferedReader(new InputStreamReader(source, "UTF-8"));
        try {
            String line;
            Map<String, String> map = null;
            String keyName = null;
            boolean skip = false;
            StringBuffer buffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(".")) {
                    StringTokenizer st;
                    if (line.startsWith(".#")) {
                        if (!line.toLowerCase().contains("todo")) continue;
                        System.out.println(line);
                        continue;
                    }
                    if (line.startsWith(".streaming")) {
                        data.streaming = true;
                        continue;
                    }
                    if (line.startsWith(".runTransformations")) {
                        data.runTransformations = true;
                        continue;
                    }
                    if (line.startsWith(".configuration")) {
                        st = new StringTokenizer(line.substring(".configuration".length() + 1), "=");
                        data.configuration.put(st.nextToken(), st.nextToken());
                        continue;
                    }
                    if (map != null) {
                        if (!skip) {
                            this.saveBuffer(buffer, map, data.inputs, keyName);
                        }
                        buffer.setLength(0);
                    }
                    map = (st = new StringTokenizer(line.substring(1), "|")).nextToken().equalsIgnoreCase("input") ? data.inputs : data.expectations;
                    keyName = st.nextToken();
                    skip = false;
                    if (!st.hasMoreTokens()) continue;
                    skip = true;
                    System.out.println("[WARNING] Skipping test for [" + keyName + "] in resource [" + resourceName + "] since it has been marked as skipped in the test. This needs to be " + "reviewed and fixed.");
                    continue;
                }
                buffer.append(line).append('\n');
            }
            if (!skip) {
                this.saveBuffer(buffer, map, data.inputs, keyName);
            }
        }
        finally {
            reader.close();
        }
        return data;
    }

    private void saveBuffer(StringBuffer buffer, Map<String, String> map, Map<String, String> inputs, String keyName) {
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == '\n') {
            buffer.setLength(buffer.length() - 1);
        }
        map.put(keyName, buffer.toString());
    }
}

