/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.integration;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.xwiki.rendering.test.integration.RenderingTest;
import org.xwiki.rendering.test.integration.TestDataGenerator;
import org.xwiki.test.XWikiComponentInitializer;

public class RenderingTestSuite
extends Suite {
    private static final TestDataGenerator GENERATOR = new TestDataGenerator();
    private static final String DEFAULT_PATTERN = ".*\\.test";
    private final Object klassInstance;
    private final ArrayList<Runner> runners = new ArrayList();

    public RenderingTestSuite(Class<?> klass) throws Throwable {
        super(RenderingTest.class, Collections.emptyList());
        try {
            this.klassInstance = klass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to construct instance of [" + klass.getName() + "]", e);
        }
        Scope scopeAnnotation = klass.getAnnotation(Scope.class);
        String packagePrefix = "";
        String pattern = DEFAULT_PATTERN;
        if (scopeAnnotation != null) {
            packagePrefix = scopeAnnotation.value();
            pattern = scopeAnnotation.pattern();
        }
        List parametersList = (List)GENERATOR.generateData(packagePrefix, pattern);
        for (int i = 0; i < parametersList.size(); ++i) {
            this.runners.add((Runner)new TestClassRunnerForParameters(this.getTestClass().getJavaClass(), parametersList, i));
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    public Description getDescription() {
        return Description.createSuiteDescription((Class)this.getTestClass().getJavaClass());
    }

    private class TestClassRunnerForParameters
    extends BlockJUnit4ClassRunner {
        private final int parameterSetNumber;
        private final XWikiComponentInitializer componentInitializer;
        private final List<Object[]> parameterList;

        TestClassRunnerForParameters(Class<?> type, List<Object[]> parameterList, int i) throws InitializationError {
            super(type);
            this.componentInitializer = new XWikiComponentInitializer();
            this.parameterList = parameterList;
            this.parameterSetNumber = i;
        }

        public Object createTest() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.computeParams());
        }

        private Object[] computeParams() throws Exception {
            Object[] originalObjects = this.parameterList.get(this.parameterSetNumber);
            Object[] newObjects = new Object[originalObjects.length];
            System.arraycopy(originalObjects, 1, newObjects, 0, originalObjects.length - 1);
            newObjects[originalObjects.length - 1] = this.componentInitializer.getComponentManager();
            return newObjects;
        }

        protected String getName() {
            return (String)this.parameterList.get(this.parameterSetNumber)[0];
        }

        protected String testName(FrameworkMethod method) {
            return this.getName();
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runChild(FrameworkMethod method, RunNotifier notifier) {
            try {
                this.componentInitializer.initializeConfigurationSource();
                this.componentInitializer.initializeExecution();
            }
            catch (Exception e) {
                notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)new RuntimeException("Failed to initialize Component Manager", e)));
            }
            try {
                for (Method klassMethod : RenderingTestSuite.this.klassInstance.getClass().getMethods()) {
                    Initialized componentManagerAnnotation = klassMethod.getAnnotation(Initialized.class);
                    if (componentManagerAnnotation == null) continue;
                    klassMethod.invoke(RenderingTestSuite.this.klassInstance, this.componentInitializer.getComponentManager());
                }
            }
            catch (Exception e) {
                notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)new RuntimeException("Failed to call Component Manager initialization method", e)));
            }
            try {
                super.runChild(method, notifier);
            }
            finally {
                try {
                    this.componentInitializer.shutdown();
                }
                catch (Exception e) {
                    notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)new RuntimeException("Failed to shutdown Component Manager", e)));
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Scope {
        public String value() default "";

        public String pattern() default ".*\\.test";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Initialized {
    }
}

