/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.integration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.StringTokenizer;
import org.xwiki.rendering.test.integration.TestData;

public class TestDataParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestData parse(InputStream source, String resourceName) throws IOException {
        TestData data = new TestData();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(source, "UTF-8"));){
            String line;
            String action = null;
            String keyName = null;
            boolean skip = false;
            StringBuffer buffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(".")) {
                    StringTokenizer st;
                    if (line.startsWith(".#")) continue;
                    if (line.startsWith(".streaming")) {
                        data.streaming = true;
                        continue;
                    }
                    if (line.startsWith(".runTransformations")) {
                        data.runTransformations = true;
                        continue;
                    }
                    if (line.startsWith(".configuration")) {
                        st = new StringTokenizer(line.substring(".configuration".length() + 1), "=");
                        data.configuration.put(st.nextToken(), st.nextToken());
                        continue;
                    }
                    if (!skip) {
                        this.saveData(action, buffer, data, keyName);
                    }
                    buffer.setLength(0);
                    st = new StringTokenizer(line.substring(1), "|");
                    action = st.nextToken();
                    keyName = st.nextToken();
                    skip = false;
                    if (!st.hasMoreTokens()) continue;
                    skip = true;
                    System.out.println("[WARNING] Skipping test for [" + keyName + "] in resource [" + resourceName + "] since it has been marked as skipped in the test. This needs to be reviewed and fixed.");
                    continue;
                }
                buffer.append(line).append('\n');
            }
            if (!skip) {
                this.saveData(action, buffer, data, keyName);
            }
        }
        return data;
    }

    private void saveData(String action, StringBuffer buffer, TestData data, String keyName) {
        if (action != null) {
            if (action.equalsIgnoreCase("input")) {
                this.saveBuffer(buffer, data.inputs, keyName);
            } else if (action.equalsIgnoreCase("expect")) {
                this.saveBuffer(buffer, data.expectations, keyName);
            } else if (action.equalsIgnoreCase("inputexpect")) {
                this.saveBuffer(buffer, data.inputs, keyName);
                this.saveBuffer(buffer, data.expectations, keyName);
            }
        }
    }

    private void saveBuffer(StringBuffer buffer, Map<String, String> map, String keyName) {
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == '\n') {
            buffer.setLength(buffer.length() - 1);
        }
        map.put(keyName, buffer.toString());
    }
}

