/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.macro;

import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.macro.AbstractNoParameterMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="testinlineeditingmacro")
@Singleton
public class TestInlineEditingMacro
extends AbstractNoParameterMacro {
    public TestInlineEditingMacro() {
        super("Macro Inline Editing", "", (ContentDescriptor)new DefaultContentDescriptor("content", true, Block.LIST_BLOCK_TYPE));
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(Object parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        WordBlock wordBlock = new WordBlock(content);
        Object contentBlock = context.isInline() ? wordBlock : new ParagraphBlock(Collections.singletonList(wordBlock));
        return Collections.singletonList(new MetaDataBlock(Collections.singletonList(contentBlock), this.getNonGeneratedContentMetaData()));
    }
}

