/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.internal.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.util.ParserUtils;

@Component
@Singleton
public class DefaultMacroContentParser
implements MacroContentParser {
    @Inject
    private ComponentManager componentManager;
    private ParserUtils parserUtils = new ParserUtils();

    @Override
    public List<Block> parse(String content, MacroTransformationContext macroContext, boolean transform, boolean removeTopLevelParagraph) throws MacroExecutionException {
        return this.parseXDOM(content, macroContext, transform, removeTopLevelParagraph).getChildren();
    }

    @Override
    public XDOM parseXDOM(String content, MacroTransformationContext macroContext, boolean transform, boolean removeTopLevelParagraph) throws MacroExecutionException {
        if (StringUtils.isEmpty((String)content)) {
            return new XDOM(Collections.emptyList());
        }
        Syntax syntax = this.getCurrentSyntax(macroContext);
        if (syntax == null) {
            throw new MacroExecutionException("Invalid Transformation: missing Syntax");
        }
        try {
            XDOM result = this.getSyntaxParser(syntax).parse((Reader)new StringReader(content));
            if (transform && macroContext.getTransformation() != null) {
                TransformationContext txContext = new TransformationContext(result, syntax);
                txContext.setId(macroContext.getId());
                try {
                    macroContext.getTransformation().transform((Block)result, txContext);
                }
                catch (Exception e) {
                    throw new MacroExecutionException("Failed to perform transformation", e);
                }
            }
            if (removeTopLevelParagraph) {
                ArrayList children = new ArrayList(result.getChildren());
                this.parserUtils.removeTopLevelParagraph(children);
                result.setChildren(children);
            }
            return result;
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "]", e);
        }
    }

    private Parser getSyntaxParser(Syntax syntax) throws MacroExecutionException {
        try {
            return (Parser)this.componentManager.lookup(Parser.class, syntax.toIdString());
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find source parser for syntax [" + syntax + "]", e);
        }
    }

    protected Syntax getCurrentSyntax(MacroTransformationContext context) {
        MetaDataBlock metaDataBlock;
        Syntax currentSyntax = context.getSyntax();
        MacroBlock currentMacroBlock = context.getCurrentMacroBlock();
        if (currentMacroBlock != null && (metaDataBlock = (MetaDataBlock)currentMacroBlock.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("syntax"), Block.Axes.ANCESTOR_OR_SELF)) != null) {
            currentSyntax = (Syntax)metaDataBlock.getMetaData().getMetaData("syntax");
        }
        return currentSyntax;
    }
}

