/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.macro;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.BeanManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.VerbatimBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.AbstractTransformation;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;

@Component
@Named(value="macro")
@Singleton
public class MacroTransformation
extends AbstractTransformation {
    private int maxMacroExecutions = 1000;
    @Inject
    private MacroManager macroManager;
    @Inject
    private BeanManager beanManager;
    @Inject
    private Logger logger;

    public int getPriority() {
        return 100;
    }

    public void transform(Block rootBlock, TransformationContext context) throws TransformationException {
        MacroTransformationContext macroContext = new MacroTransformationContext(context);
        macroContext.setTransformation((Transformation)this);
        List macroBlocks = rootBlock.getChildrenByType(MacroBlock.class, true);
        for (int executions = 0; !macroBlocks.isEmpty() && executions < this.maxMacroExecutions; ++executions) {
            this.transformOnce(rootBlock, macroContext, context.getSyntax());
            macroBlocks = rootBlock.getChildrenByType(MacroBlock.class, true);
        }
    }

    private void transformOnce(Block rootBlock, MacroTransformationContext context, Syntax syntax) {
        List<Block> newBlocks;
        MacroHolder macroHolder = this.getHighestPriorityMacro(rootBlock, syntax);
        if (macroHolder == null) {
            return;
        }
        if (macroHolder.macroBlock.isInline()) {
            context.setInline(true);
            if (!macroHolder.macro.supportsInlineMode()) {
                this.generateError(macroHolder.macroBlock, "Not an inline macro", "This macro can only be used by itself on a new line");
                this.logger.debug("The [" + macroHolder.macroBlock.getId() + "] macro doesn't support inline mode.");
                return;
            }
        } else {
            context.setInline(false);
        }
        try {
            Object macroParameters;
            context.setCurrentMacroBlock(macroHolder.macroBlock);
            try {
                macroParameters = macroHolder.macro.getDescriptor().getParametersBeanClass().newInstance();
                this.beanManager.populate(macroParameters, macroHolder.macroBlock.getParameters());
            }
            catch (Throwable e) {
                this.generateError(macroHolder.macroBlock, "Invalid macro parameters used for the \"" + macroHolder.macroBlock.getId() + "\" macro", e);
                this.logger.debug("Invalid macro parameter for the [" + macroHolder.macroBlock.getId() + "] macro. Internal error: [" + e.getMessage() + "]");
                return;
            }
            newBlocks = macroHolder.macro.execute(macroParameters, macroHolder.macroBlock.getContent(), context);
        }
        catch (Throwable e) {
            this.generateError(macroHolder.macroBlock, "Failed to execute the [" + macroHolder.macroBlock.getId() + "] macro", e);
            this.logger.debug("Failed to execute the [" + macroHolder.macroBlock.getId() + "]macro. Internal error [" + e.getMessage() + "]");
            return;
        }
        Block resultBlock = this.wrapInMacroMarker(macroHolder.macroBlock, newBlocks);
        macroHolder.macroBlock.getParent().replaceChild(resultBlock, (Block)macroHolder.macroBlock);
    }

    private MacroHolder getHighestPriorityMacro(Block rootBlock, Syntax syntax) {
        ArrayList<MacroHolder> macroHolders = new ArrayList<MacroHolder>();
        for (MacroBlock macroBlock : rootBlock.getChildrenByType(MacroBlock.class, true)) {
            try {
                Macro<?> macro = this.macroManager.getMacro(new MacroId(macroBlock.getId(), syntax));
                macroHolders.add(new MacroHolder(macro, macroBlock));
            }
            catch (MacroLookupException e) {
                this.generateError(macroBlock, "Unknown macro: " + macroBlock.getId(), "The \"" + macroBlock.getId() + "\" macro is not in the list of registered macros. Verify the " + "spelling or contact your administrator.");
                this.logger.debug("Failed to locate the [" + macroBlock.getId() + "] macro. Ignoring it.");
            }
        }
        Collections.sort(macroHolders);
        return macroHolders.size() > 0 ? (MacroHolder)macroHolders.get(0) : null;
    }

    private Block wrapInMacroMarker(MacroBlock macroBlockToWrap, List<Block> newBlocks) {
        return new MacroMarkerBlock(macroBlockToWrap.getId(), macroBlockToWrap.getParameters(), macroBlockToWrap.getContent(), newBlocks, macroBlockToWrap.isInline());
    }

    private void generateError(MacroBlock macroToReplace, String message, String description) {
        ArrayList<Block> errorBlocks = new ArrayList<Block>();
        Map<String, String> errorBlockParams = Collections.singletonMap("class", "xwikirenderingerror");
        Map<String, String> errorDescriptionBlockParams = Collections.singletonMap("class", "xwikirenderingerrordescription hidden");
        VerbatimBlock descriptionBlock = new VerbatimBlock(description, macroToReplace.isInline());
        if (macroToReplace.isInline()) {
            errorBlocks.add((Block)new FormatBlock(Arrays.asList(new WordBlock(message)), Format.NONE, errorBlockParams));
            errorBlocks.add((Block)new FormatBlock(Arrays.asList(descriptionBlock), Format.NONE, errorDescriptionBlockParams));
        } else {
            errorBlocks.add((Block)new GroupBlock(Arrays.asList(new WordBlock(message)), errorBlockParams));
            errorBlocks.add((Block)new GroupBlock(Arrays.asList(descriptionBlock), errorDescriptionBlockParams));
        }
        macroToReplace.getParent().replaceChild(this.wrapInMacroMarker(macroToReplace, errorBlocks), (Block)macroToReplace);
    }

    private void generateError(MacroBlock macroToReplace, String message, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        this.generateError(macroToReplace, message, writer.getBuffer().toString());
    }

    private class MacroHolder
    implements Comparable<MacroHolder> {
        Macro<?> macro;
        MacroBlock macroBlock;

        public MacroHolder(Macro<?> macro, MacroBlock macroBlock) {
            this.macro = macro;
            this.macroBlock = macroBlock;
        }

        @Override
        public int compareTo(MacroHolder holder) {
            return this.macro.compareTo(holder.macro);
        }
    }
}

