/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.macro;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.BeanManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.internal.transformation.macro.MacroErrorManager;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.MacroNotFoundException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.AbstractTransformation;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;

@Component
@Named(value="macro")
@Singleton
public class MacroTransformation
extends AbstractTransformation {
    private int maxRecursions = 1000;
    @Inject
    private MacroManager macroManager;
    @Inject
    private BeanManager beanManager;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private Logger logger;
    private MacroErrorManager macroErrorManager = new MacroErrorManager();

    public int getPriority() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void transform(Block rootBlock, TransformationContext context) throws TransformationException {
        macroContext = new MacroTransformationContext(context);
        macroContext.setTransformation((Transformation)this);
        recursions = 0;
        while (recursions < this.maxRecursions) {
            block14: {
                priorityMacroBlockMatcher = new PriorityMacroBlockMatcher(context.getSyntax());
                rootBlock.getFirstBlock((BlockMatcher)priorityMacroBlockMatcher, Block.Axes.DESCENDANT);
                if (priorityMacroBlockMatcher.errors != null) {
                    for (MacroLookupExceptionElement error : priorityMacroBlockMatcher.errors) {
                        if (error.exception instanceof MacroNotFoundException) {
                            this.macroErrorManager.generateError(error.macroBlock, String.format("Unknown macro: %s.", new Object[]{error.macroBlock.getId()}), String.format("The \"%s\" macro is not in the list of registered macros. Verify the spelling or contact your administrator.", new Object[]{error.macroBlock.getId()}));
                            this.logger.debug("Failed to locate the [{}] macro. Ignoring it.", (Object)error.macroBlock.getId());
                            continue;
                        }
                        this.macroErrorManager.generateError(error.macroBlock, String.format("Invalid macro: %s.", new Object[]{error.macroBlock.getId()}), error.exception);
                        this.logger.debug("Failed to instantiate the [{}] macro. Ignoring it.", (Object)error.macroBlock.getId());
                    }
                }
                if ((macroBlock = priorityMacroBlockMatcher.block) == null) {
                    return;
                }
                macro = priorityMacroBlockMatcher.blockMacro;
                incrementRecursions = macroBlock.getParent() instanceof MacroMarkerBlock;
                if (!macroBlock.isInline()) break block14;
                macroContext.setInline(true);
                if (macro.supportsInlineMode()) ** GOTO lbl32
                this.macroErrorManager.generateError(macroBlock, "This is a standalone macro only and it cannot be used inline", "This macro generates standalone content. As a consequence you need to make sure to use a syntax that separates your macro from the content before and after it so that it's on a line by itself. For example in XWiki Syntax 2.0+ this means having 2 newline characters (a.k.a line breaks) separating your macro from the content before and after it.");
                this.logger.debug("The [{}] macro doesn't support inline mode.", (Object)macroBlock.getId());
                ((MutableRenderingContext)this.renderingContext).setCurrentBlock(null);
                continue;
            }
            macroContext.setInline(false);
lbl32:
            // 2 sources

            macroContext.setCurrentMacroBlock(macroBlock);
            ((MutableRenderingContext)this.renderingContext).setCurrentBlock((Block)macroBlock);
            macroParameters = macro.getDescriptor().getParametersBeanClass().newInstance();
            try {
                this.beanManager.populate(macroParameters, macroBlock.getParameters());
            }
            catch (Throwable e) {
                this.macroErrorManager.generateError(macroBlock, String.format("Invalid macro parameters used for the \"%s\" macro.", new Object[]{macroBlock.getId()}), e);
                this.logger.debug("Invalid macro parameter for the [{}] macro. Internal error: [{}].", (Object)macroBlock.getId(), (Object)e.getMessage());
                ((MutableRenderingContext)this.renderingContext).setCurrentBlock(null);
                continue;
            }
            try {
                newBlocks = macro.execute(macroParameters, macroBlock.getContent(), macroContext);
            }
            catch (Throwable e) {
                this.macroErrorManager.generateError(macroBlock, String.format("Failed to execute the [%s] macro.", new Object[]{macroBlock.getId()}), e);
                this.logger.debug("Failed to execute the [{}] macro. Internal error [{}].", (Object)macroBlock.getId(), (Object)e.getMessage());
                continue;
            }
            catch (Throwable var12_13) {
                throw var12_13;
            }
            finally {
                ((MutableRenderingContext)this.renderingContext).setCurrentBlock(null);
                continue;
            }
            resultBlock = this.wrapInMacroMarker(macroBlock, newBlocks);
            macroBlock.getParent().replaceChild(resultBlock, (Block)macroBlock);
            if (!incrementRecursions) continue;
            ++recursions;
        }
    }

    private Block wrapInMacroMarker(MacroBlock macroBlockToWrap, List<Block> newBlocks) {
        return new MacroMarkerBlock(macroBlockToWrap.getId(), macroBlockToWrap.getParameters(), macroBlockToWrap.getContent(), newBlocks, macroBlockToWrap.isInline());
    }

    public void setMaxRecursions(int maxRecursions) {
        this.maxRecursions = maxRecursions;
    }

    private class PriorityMacroBlockMatcher
    implements BlockMatcher {
        private final Syntax syntax;
        public MacroBlock block;
        public Macro<?> blockMacro;
        public List<MacroLookupExceptionElement> errors;
        private final Map<String, Macro<?>> knownMacros = new HashMap();

        public PriorityMacroBlockMatcher(Syntax syntax) {
            this.syntax = syntax;
        }

        public boolean match(Block block) {
            if (block instanceof MacroBlock) {
                MacroBlock macroBlock = (MacroBlock)block;
                try {
                    Macro<?> macro = this.knownMacros.get(macroBlock.getId());
                    if (macro == null) {
                        macro = MacroTransformation.this.macroManager.getMacro(new MacroId(macroBlock.getId(), this.syntax));
                        this.knownMacros.put(macroBlock.getId(), macro);
                    }
                    if (this.block == null || this.blockMacro.compareTo(macro) > 0) {
                        this.block = macroBlock;
                        this.blockMacro = macro;
                    }
                }
                catch (MacroLookupException e) {
                    if (this.errors == null) {
                        this.errors = new LinkedList<MacroLookupExceptionElement>();
                    }
                    this.errors.add(new MacroLookupExceptionElement(macroBlock, e));
                }
            }
            return false;
        }
    }

    private static class MacroLookupExceptionElement {
        public MacroBlock macroBlock;
        public MacroLookupException exception;

        public MacroLookupExceptionElement(MacroBlock macroBlock, MacroLookupException exception) {
            this.macroBlock = macroBlock;
            this.exception = exception;
        }
    }
}

