/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroIdFactory;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.MacroNotFoundException;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
public class DefaultMacroManager
implements MacroManager {
    @Inject
    private MacroIdFactory macroIdFactory;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;
    @Inject
    private Logger logger;

    @Override
    public Set<MacroId> getMacroIds() throws MacroLookupException {
        return this.getMacroIds(null);
    }

    @Override
    public Set<MacroId> getMacroIds(Syntax syntax) throws MacroLookupException {
        Map allMacros;
        HashSet<MacroId> result = new HashSet<MacroId>();
        try {
            allMacros = ((ComponentManager)this.componentManager.get()).getInstanceMap(Macro.class);
        }
        catch (ComponentLookupException e) {
            throw new MacroLookupException("Failed to lookup Macros", e);
        }
        for (Map.Entry entry : allMacros.entrySet()) {
            MacroId macroId;
            try {
                macroId = this.macroIdFactory.createMacroId((String)entry.getKey());
            }
            catch (ParseException e) {
                this.logger.warn("Invalid Macro descriptor format for hint [" + (String)entry.getKey() + "]. The hint should contain either the macro name only or the macro name followed by the syntax for which it is valid. In that case the macro name should be followed by a \"/\" followed by the syntax name followed by another \"/\" followed by the syntax version. For example \"html/xwiki/2.0\". This macro will not be available in the system.");
                continue;
            }
            if (syntax != null && macroId.getSyntax() != null && syntax != macroId.getSyntax()) continue;
            result.add(macroId);
        }
        return result;
    }

    @Override
    public Macro<?> getMacro(MacroId macroId) throws MacroLookupException {
        String macroHint = macroId.toString();
        ComponentManager cm = (ComponentManager)this.componentManager.get();
        try {
            if (cm.hasComponent(Macro.class, macroHint)) {
                return (Macro)cm.getInstance(Macro.class, macroHint);
            }
            if (cm.hasComponent(Macro.class, macroId.getId())) {
                return (Macro)cm.getInstance(Macro.class, macroId.getId());
            }
            throw new MacroNotFoundException(String.format("No macro [%s] could be found.", macroId.toString()));
        }
        catch (ComponentLookupException e) {
            throw new MacroLookupException(String.format("Macro [%s] failed to be instantiated.", macroId.toString()), e);
        }
    }

    @Override
    public boolean exists(MacroId macroId) {
        String macroHint = macroId.toString();
        boolean hasMacro = true;
        try {
            ((ComponentManager)this.componentManager.get()).getInstance(Macro.class, macroHint);
        }
        catch (ComponentLookupException ex) {
            hasMacro = false;
        }
        return hasMacro;
    }
}

