/* Generated By:JavaCC: Do not edit this line. XWikiScannerTokenManager.java */
/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.wikimodel.xwiki.xwiki21.javacc;
import org.xwiki.rendering.wikimodel.IWikiReferenceParser;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;
import org.xwiki.rendering.wikimodel.WikiStyle;
import org.xwiki.rendering.wikimodel.impl.IWikiScannerContext;
import org.xwiki.rendering.wikimodel.impl.WikiScannerUtil;
import org.xwiki.rendering.wikimodel.xwiki.xwiki20.XWikiReferenceParser;
import org.xwiki.rendering.wikimodel.xwiki.xwiki20.XWikiScannerUtil;
import org.xwiki.rendering.wikimodel.xwiki.xwiki20.XWikiWikiParameters;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

/** Token Manager. */
public class XWikiScannerTokenManager implements XWikiScannerConstants
{
    public static final Pattern MACRO_NAME_PATTERN = Pattern.compile("^\u005c\u005c{\u005c\u005c{[/]?[\u0000- ]*(.*?)[\u0000- \u005c\u005c}/]");

    int verbatimBlockDepth = 0;
    int tableDepth = 0;
    String macroName = "";
    int macroDepth = 0;
    void initMacro(CharSequence buf) {
        macroName = getMacroName(buf);
        macroDepth = 1;
    }
    String getMacroName(CharSequence buf) {
        Matcher matcher = MACRO_NAME_PATTERN.matcher(buf);
        if (!matcher.find()) {
            // This must not be reachable.  I.e., make sure MACRO_NAME_PATTERN matches <MACRO_START> and <MACRO_END>.
            throw new RuntimeException(String.format("Didn't match macro name pattern: [%s].", buf.toString()));
        }
        return matcher.group(1);
    }

    /*
     * The lexical scanner operates in four different categories of
     * states:
     *
     * * base states: INLINE
     * * beginning of line state: BEGINNING_OF_LINE
     * * block states: TABLE_CONTEXT, HEADER_CONTEXT
     * * special states: VERBATIM_CONTEXT, MACRO_CONTEXT
     *
     * Except for state transitions to BEGINNING_OF_LINE and to
     * special states, we need to control the state transitions in
     * java code.  For this control the state we keep two variables:
     *
     * * preceedingSpecialState
     * * stateStack
     *
     * And we use the below five operations for switching lexical state.
     * 
     * * returnFromSpecialState()        - Called to switch from a
     *                                     a special state.
     * * enterBlockState(int state)      - Called instead of switching
     *                                     to a block state directly.
     * * pushStateControl()              - Called when entering an
     *                                     embedded document.
     * * popControlState()               - Called when leaving an
     *                                     embedded document.  Restores
     *                                     control variables and switches
     *                                     back to the state the
     *                                     corresponding pushStateControl
     *                                     was called from.
     *
     */

    private class LexStateControl {
        private int preceedingSpecialState;
        LexStateControl() {
            preceedingSpecialState = INLINE;
        }
        public void clearBlockState() {
            preceedingSpecialState = INLINE;
        }
        public void returnFromSpecialState() {
            SwitchTo(preceedingSpecialState);
        }
        public void enterBlockState(int state) {
            preceedingSpecialState = state;
            SwitchTo(state);
        }
    }

    private class ControlState {
        private final int curLexState;
        private final LexStateControl lexStateControl;
        ControlState(int curLexState, LexStateControl lexStateControl) {
            this.curLexState = curLexState;
            this.lexStateControl = lexStateControl;
        }

        public int getCurLexState() {
            return this.curLexState;
        }

        public LexStateControl getLexStateControl() {
            return this.lexStateControl;
        }

    }
    private final Stack<ControlState> controlStateStack = new Stack<ControlState>();

    LexStateControl lexStateControl = new LexStateControl();

    private void clearBlockState() { lexStateControl.clearBlockState(); }
    private void returnFromSpecialState() { lexStateControl.returnFromSpecialState(); }
    private void returnFromBeginningOfLine() { returnFromSpecialState(); }
    private void enterBlockState(int state) { lexStateControl.enterBlockState(state); }

    private void pushControlState() {
        controlStateStack.push(new ControlState(curLexState, lexStateControl));
        lexStateControl = new LexStateControl();
        SwitchTo(BEGINNING_OF_LINE);
    }

    private void popControlState() {
        ControlState s = controlStateStack.pop();
        lexStateControl = s.getLexStateControl();
        SwitchTo(s.getCurLexState());
    }

    private boolean inEmbeddedDocument() {
        return controlStateStack.size() > 0;
    }

  /** Debug output. */
  public  java.io.PrintStream debugStream = System.out;
  /** Set debug output. */
  public  void setDebugStream(java.io.PrintStream ds) { debugStream = ds; }
private int jjMoveStringLiteralDfa0_0()
{
   return 1;
}
private int jjMoveStringLiteralDfa0_1()
{
   return jjMoveNfa_1(12, 0);
}
static final long[] jjbitVec0 = {
   0xfffffffffffffffeL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL
};
static final long[] jjbitVec2 = {
   0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL
};
private int jjMoveNfa_1(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 95;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 12:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(0, 5);
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 7)
                        kind = 7;
                  }
                  else if ((0xc00000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(8, 4);
                  else if ((0x2040000000000L & l) != 0L)
                     jjCheckNAddTwoStates(5, 6);
                  else if (curChar == 40)
                     jjAddStates(6, 8);
                  else if (curChar == 33)
                     jjAddStates(9, 10);
                  else if (curChar == 62)
                  {
                     if (kind > 8)
                        kind = 8;
                     jjCheckNAdd(19);
                  }
                  else if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 11;
                  else if (curChar == 61)
                  {
                     if (kind > 2)
                        kind = 2;
                     jjCheckNAddTwoStates(0, 1);
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 16;
                  else if (curChar == 42)
                     jjCheckNAddStates(11, 13);
                  break;
               case 0:
                  if (curChar != 61)
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjCheckNAddTwoStates(0, 1);
                  break;
               case 1:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjCheckNAdd(1);
                  break;
               case 2:
                  if (curChar == 42)
                     jjCheckNAddStates(11, 13);
                  break;
               case 3:
                  if ((0xc00000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(3, 4);
                  break;
               case 4:
                  if ((0x100000200L & l) != 0L && kind > 3)
                     kind = 3;
                  break;
               case 5:
                  if ((0x2040000000000L & l) != 0L)
                     jjCheckNAddTwoStates(5, 6);
                  break;
               case 6:
                  if (curChar == 46)
                     jjCheckNAddTwoStates(7, 4);
                  break;
               case 7:
                  if ((0xc00000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(7, 4);
                  break;
               case 8:
                  if ((0xc00000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(8, 4);
                  break;
               case 9:
                  if (curChar == 45)
                     jjCheckNAdd(10);
                  break;
               case 10:
                  if (curChar != 45)
                     break;
                  if (kind > 4)
                     kind = 4;
                  jjCheckNAdd(10);
                  break;
               case 11:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 13:
                  if (curChar == 61 && kind > 5)
                     kind = 5;
                  break;
               case 16:
                  if (curChar == 10 && kind > 7)
                     kind = 7;
                  break;
               case 17:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 18:
                  if ((0x2400L & l) != 0L && kind > 7)
                     kind = 7;
                  break;
               case 19:
                  if (curChar != 62)
                     break;
                  if (kind > 8)
                     kind = 8;
                  jjCheckNAdd(19);
                  break;
               case 20:
                  if (curChar == 33)
                     jjAddStates(9, 10);
                  break;
               case 21:
                  if (curChar == 33 && kind > 5)
                     kind = 5;
                  break;
               case 22:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(0, 5);
                  break;
               case 23:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(23, 0);
                  break;
               case 24:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(14, 17);
                  break;
               case 25:
                  if (curChar == 40)
                     jjAddStates(6, 8);
                  break;
               case 26:
                  if (curChar == 37)
                     jjCheckNAddStates(18, 23);
                  break;
               case 28:
                  jjCheckNAddStates(18, 23);
                  break;
               case 29:
                  if ((0xffffff5bffffffffL & l) != 0L)
                     jjCheckNAddStates(18, 23);
                  break;
               case 30:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 31:
                  if ((0xfffffd7bffffffffL & l) != 0L)
                     jjCheckNAddStates(18, 23);
                  break;
               case 32:
                  if (curChar == 34)
                     jjCheckNAddStates(24, 26);
                  break;
               case 34:
                  jjCheckNAddStates(24, 26);
                  break;
               case 35:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(24, 26);
                  break;
               case 36:
                  if (curChar == 34)
                     jjCheckNAddStates(18, 23);
                  break;
               case 37:
                  if (curChar == 39)
                     jjCheckNAddStates(27, 29);
                  break;
               case 39:
                  jjCheckNAddStates(27, 29);
                  break;
               case 40:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(27, 29);
                  break;
               case 41:
                  if (curChar == 39)
                     jjCheckNAddStates(18, 23);
                  break;
               case 42:
                  if (curChar == 37)
                     jjAddStates(30, 31);
                  break;
               case 44:
                  if (curChar == 41)
                     jjCheckNAddStates(32, 35);
                  break;
               case 45:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(32, 35);
                  break;
               case 46:
                  if (curChar == 37)
                     jjCheckNAddStates(36, 41);
                  break;
               case 48:
                  jjCheckNAddStates(36, 41);
                  break;
               case 49:
                  if ((0xffffff5bffffffffL & l) != 0L)
                     jjCheckNAddStates(36, 41);
                  break;
               case 50:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 51;
                  break;
               case 51:
                  if ((0xfffffd7bffffffffL & l) != 0L)
                     jjCheckNAddStates(36, 41);
                  break;
               case 52:
                  if (curChar == 34)
                     jjCheckNAddStates(42, 44);
                  break;
               case 54:
                  jjCheckNAddStates(42, 44);
                  break;
               case 55:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(42, 44);
                  break;
               case 56:
                  if (curChar == 34)
                     jjCheckNAddStates(36, 41);
                  break;
               case 57:
                  if (curChar == 39)
                     jjCheckNAddStates(45, 47);
                  break;
               case 59:
                  jjCheckNAddStates(45, 47);
                  break;
               case 60:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(45, 47);
                  break;
               case 61:
                  if (curChar == 39)
                     jjCheckNAddStates(36, 41);
                  break;
               case 62:
                  if (curChar == 37)
                     jjAddStates(48, 49);
                  break;
               case 64:
                  if (curChar == 41)
                     jjAddStates(50, 51);
                  break;
               case 65:
                  if (curChar == 10 && kind > 6)
                     kind = 6;
                  break;
               case 66:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 65;
                  break;
               case 67:
                  if ((0x2400L & l) != 0L && kind > 6)
                     kind = 6;
                  break;
               case 68:
                  if (curChar == 37)
                     jjCheckNAddStates(52, 57);
                  break;
               case 70:
                  jjCheckNAddStates(52, 57);
                  break;
               case 71:
                  if ((0xffffff5bffffffffL & l) != 0L)
                     jjCheckNAddStates(52, 57);
                  break;
               case 72:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 73:
                  if ((0xfffffd7bffffffffL & l) != 0L)
                     jjCheckNAddStates(52, 57);
                  break;
               case 74:
                  if (curChar == 34)
                     jjCheckNAddStates(58, 60);
                  break;
               case 76:
                  jjCheckNAddStates(58, 60);
                  break;
               case 77:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(58, 60);
                  break;
               case 78:
                  if (curChar == 34)
                     jjCheckNAddStates(52, 57);
                  break;
               case 79:
                  if (curChar == 39)
                     jjCheckNAddStates(61, 63);
                  break;
               case 81:
                  jjCheckNAddStates(61, 63);
                  break;
               case 82:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(61, 63);
                  break;
               case 83:
                  if (curChar == 39)
                     jjCheckNAddStates(52, 57);
                  break;
               case 84:
                  if (curChar == 37)
                     jjAddStates(64, 65);
                  break;
               case 86:
                  if (curChar == 41)
                     jjCheckNAddStates(66, 69);
                  break;
               case 87:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(66, 69);
                  break;
               case 88:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(89, 92);
                  break;
               case 89:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(89, 92);
                  break;
               case 90:
                  if (curChar == 40 && kind > 68)
                     kind = 68;
                  break;
               case 91:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 90;
                  break;
               case 92:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 91;
                  break;
               case 93:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 88;
                  break;
               case 94:
                  if ((0x2400L & l) != 0L)
                     jjCheckNAddTwoStates(89, 92);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 12:
                  if (curChar == 124)
                  {
                     if (kind > 5)
                        kind = 5;
                  }
                  if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 14:
                  if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 15:
                  if (curChar == 124 && kind > 5)
                     kind = 5;
                  break;
               case 27:
               case 43:
                  if (curChar == 126)
                     jjCheckNAdd(28);
                  break;
               case 28:
                  jjCheckNAddStates(18, 23);
                  break;
               case 29:
               case 31:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(18, 23);
                  break;
               case 33:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 34;
                  break;
               case 34:
                  jjCheckNAddStates(24, 26);
                  break;
               case 35:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(24, 26);
                  break;
               case 38:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 39;
                  break;
               case 39:
                  jjCheckNAddStates(27, 29);
                  break;
               case 40:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(27, 29);
                  break;
               case 47:
               case 63:
                  if (curChar == 126)
                     jjCheckNAdd(48);
                  break;
               case 48:
                  jjCheckNAddStates(36, 41);
                  break;
               case 49:
               case 51:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(36, 41);
                  break;
               case 53:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 54;
                  break;
               case 54:
                  jjCheckNAddStates(42, 44);
                  break;
               case 55:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(42, 44);
                  break;
               case 58:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 59;
                  break;
               case 59:
                  jjCheckNAddStates(45, 47);
                  break;
               case 60:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(45, 47);
                  break;
               case 69:
               case 85:
                  if (curChar == 126)
                     jjCheckNAdd(70);
                  break;
               case 70:
                  jjCheckNAddStates(52, 57);
                  break;
               case 71:
               case 73:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(52, 57);
                  break;
               case 75:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 76;
                  break;
               case 76:
                  jjCheckNAddStates(58, 60);
                  break;
               case 77:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(58, 60);
                  break;
               case 80:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 81;
                  break;
               case 81:
                  jjCheckNAddStates(61, 63);
                  break;
               case 82:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(61, 63);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 28:
               case 29:
               case 31:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(18, 23);
                  break;
               case 34:
               case 35:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(24, 26);
                  break;
               case 39:
               case 40:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(27, 29);
                  break;
               case 48:
               case 49:
               case 51:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(36, 41);
                  break;
               case 54:
               case 55:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(42, 44);
                  break;
               case 59:
               case 60:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(45, 47);
                  break;
               case 70:
               case 71:
               case 73:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(52, 57);
                  break;
               case 76:
               case 77:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(58, 60);
                  break;
               case 81:
               case 82:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(61, 63);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 95 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_6(int pos, long active0, long active1)
{
   switch (pos)
   {
      case 0:
         if ((active1 & 0x100L) != 0L)
         {
            jjmatchedKind = 90;
            return 176;
         }
         if ((active1 & 0x13f800L) != 0L)
         {
            jjmatchedKind = 90;
            return -1;
         }
         return -1;
      case 1:
         if ((active1 & 0x100L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 90;
               jjmatchedPos = 0;
            }
            return 237;
         }
         if ((active1 & 0x13f800L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 90;
               jjmatchedPos = 0;
            }
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_6(int pos, long active0, long active1)
{
   return jjMoveNfa_6(jjStopStringLiteralDfa_6(pos, active0, active1), pos + 1);
}
private int jjStopAtPos(int pos, int kind)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   return pos + 1;
}
private int jjMoveStringLiteralDfa0_6()
{
   switch(curChar)
   {
      case 35:
         return jjMoveStringLiteralDfa1_6(0x20000L);
      case 42:
         return jjMoveStringLiteralDfa1_6(0x800L);
      case 44:
         return jjMoveStringLiteralDfa1_6(0x10000L);
      case 45:
         return jjMoveStringLiteralDfa1_6(0x2000L);
      case 47:
         return jjMoveStringLiteralDfa1_6(0x1000L);
      case 92:
         return jjMoveStringLiteralDfa1_6(0x100000L);
      case 94:
         return jjMoveStringLiteralDfa1_6(0x8000L);
      case 95:
         return jjMoveStringLiteralDfa1_6(0x4000L);
      case 123:
         return jjMoveStringLiteralDfa1_6(0x100L);
      default :
         return jjMoveNfa_6(23, 0);
   }
}
private int jjMoveStringLiteralDfa1_6(long active1)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 35:
         if ((active1 & 0x20000L) != 0L)
            return jjStopAtPos(1, 81);
         break;
      case 42:
         if ((active1 & 0x800L) != 0L)
            return jjStopAtPos(1, 75);
         break;
      case 44:
         if ((active1 & 0x10000L) != 0L)
            return jjStopAtPos(1, 80);
         break;
      case 45:
         if ((active1 & 0x2000L) != 0L)
            return jjStopAtPos(1, 77);
         break;
      case 47:
         if ((active1 & 0x1000L) != 0L)
            return jjStopAtPos(1, 76);
         break;
      case 92:
         if ((active1 & 0x100000L) != 0L)
            return jjStopAtPos(1, 84);
         break;
      case 94:
         if ((active1 & 0x8000L) != 0L)
            return jjStopAtPos(1, 79);
         break;
      case 95:
         if ((active1 & 0x4000L) != 0L)
            return jjStopAtPos(1, 78);
         break;
      case 123:
         return jjMoveStringLiteralDfa2_6(active1, 0x100L);
      default :
         break;
   }
   return jjStartNfa_6(0, 0L, active1);
}
private int jjMoveStringLiteralDfa2_6(long old1, long active1)
{
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_6(0, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(1, 0L, active1);
      return 2;
   }
   switch(curChar)
   {
      case 123:
         if ((active1 & 0x100L) != 0L)
            return jjStopAtPos(2, 72);
         break;
      default :
         break;
   }
   return jjStartNfa_6(1, 0L, active1);
}
private int jjMoveNfa_6(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 237;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 237:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(70, 74);
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(75, 79);
                  break;
               case 23:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                  {
                     if (kind > 89)
                        kind = 89;
                     jjCheckNAddTwoStates(116, 117);
                  }
                  else if ((0xfc00fffe00000000L & l) != 0L)
                  {
                     if (kind > 90)
                        kind = 90;
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 88)
                        kind = 88;
                     jjCheckNAddTwoStates(234, 235);
                  }
                  else if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 86)
                        kind = 86;
                     jjCheckNAddStates(80, 85);
                  }
                  if (curChar == 13)
                     jjAddStates(86, 87);
                  else if (curChar == 40)
                     jjCheckNAddStates(88, 90);
                  else if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 114;
                  break;
               case 1:
                  if (curChar == 58)
                     jjCheckNAddStates(91, 94);
                  break;
               case 3:
               case 4:
                  jjCheckNAddStates(91, 94);
                  break;
               case 17:
               case 18:
                  jjCheckNAddStates(95, 99);
                  break;
               case 24:
                  if (curChar != 58)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 25:
                  if ((0xfffffffeffffd9ffL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 27:
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 28:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 29:
                  if ((0xfc00fffe00000000L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 35:
                  if (curChar != 58)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 36:
                  if ((0xfffffffeffffd9ffL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 38:
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 39:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 40:
                  if ((0xfc00fffe00000000L & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 47:
                  if (curChar == 58)
                     jjAddStates(100, 102);
                  break;
               case 48:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(103, 106);
                  break;
               case 49:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(107, 111);
                  break;
               case 50:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 51;
                  break;
               case 51:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 52;
                  break;
               case 52:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(107, 111);
                  break;
               case 53:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(112, 116);
                  break;
               case 54:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(112, 116);
                  break;
               case 55:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 56;
                  break;
               case 56:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 57;
                  break;
               case 57:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(112, 116);
                  break;
               case 58:
                  if (curChar != 63)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(117, 119);
                  break;
               case 59:
                  if ((0xafffefd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(117, 119);
                  break;
               case 60:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 61;
                  break;
               case 61:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 62;
                  break;
               case 62:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(117, 119);
                  break;
               case 63:
                  if (curChar != 35)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 64:
                  if ((0xafffefd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 65:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 66;
                  break;
               case 66:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 67:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 68:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 69;
                  break;
               case 69:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 70:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 71:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 72;
                  break;
               case 72:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 73:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(120, 124);
                  break;
               case 74:
                  if ((0x2bff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(120, 124);
                  break;
               case 75:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(125, 129);
                  break;
               case 76:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(125, 129);
                  break;
               case 77:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 78;
                  break;
               case 78:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 79;
                  break;
               case 79:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(125, 129);
                  break;
               case 80:
                  if ((0x2bff6fd200000000L & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 88:
                  if ((0x3ff680000000000L & l) != 0L)
                     jjCheckNAddStates(130, 132);
                  break;
               case 89:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 90;
                  break;
               case 91:
                  if ((0x3ff680000000000L & l) != 0L)
                     jjCheckNAddStates(133, 135);
                  break;
               case 92:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(136, 143);
                  break;
               case 93:
                  if ((0x2fff6fd200000000L & l) != 0L)
                     jjCheckNAddStates(144, 146);
                  break;
               case 94:
                  if (curChar == 37)
                     jjCheckNAdd(95);
                  break;
               case 95:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 96;
                  break;
               case 96:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(144, 146);
                  break;
               case 98:
                  if (curChar == 37)
                     jjCheckNAdd(99);
                  break;
               case 99:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 100;
                  break;
               case 100:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(147, 152);
                  break;
               case 101:
                  if ((0x2bff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(147, 152);
                  break;
               case 102:
                  if (curChar == 58)
                     jjCheckNAdd(103);
                  break;
               case 103:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(153, 156);
                  break;
               case 104:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(157, 161);
                  break;
               case 105:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(157, 161);
                  break;
               case 106:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 107;
                  break;
               case 107:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 108;
                  break;
               case 108:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(157, 161);
                  break;
               case 109:
                  if (curChar == 37)
                     jjCheckNAddTwoStates(95, 99);
                  break;
               case 110:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 92;
                  break;
               case 111:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 110;
                  break;
               case 112:
                  if (curChar != 41)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjCheckNAdd(113);
                  break;
               case 113:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjCheckNAdd(113);
                  break;
               case 114:
                  if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 112;
                  break;
               case 115:
                  if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 114;
                  break;
               case 116:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(116, 117);
                  break;
               case 118:
                  if ((0xfc00fffe00000000L & l) != 0L && kind > 90)
                     kind = 90;
                  break;
               case 119:
                  if (curChar == 40)
                     jjCheckNAddStates(88, 90);
                  break;
               case 120:
                  if (curChar == 37)
                     jjCheckNAddStates(162, 167);
                  break;
               case 122:
                  jjCheckNAddStates(162, 167);
                  break;
               case 123:
                  if ((0xffffff5bffffffffL & l) != 0L)
                     jjCheckNAddStates(162, 167);
                  break;
               case 124:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 125;
                  break;
               case 125:
                  if ((0xfffffd7bffffffffL & l) != 0L)
                     jjCheckNAddStates(162, 167);
                  break;
               case 126:
                  if (curChar == 34)
                     jjCheckNAddStates(168, 170);
                  break;
               case 128:
                  jjCheckNAddStates(168, 170);
                  break;
               case 129:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(168, 170);
                  break;
               case 130:
                  if (curChar == 34)
                     jjCheckNAddStates(162, 167);
                  break;
               case 131:
                  if (curChar == 39)
                     jjCheckNAddStates(171, 173);
                  break;
               case 133:
                  jjCheckNAddStates(171, 173);
                  break;
               case 134:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(171, 173);
                  break;
               case 135:
                  if (curChar == 39)
                     jjCheckNAddStates(162, 167);
                  break;
               case 136:
                  if (curChar == 37)
                     jjAddStates(174, 175);
                  break;
               case 138:
                  if (curChar == 41)
                     jjCheckNAddStates(176, 179);
                  break;
               case 139:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(176, 179);
                  break;
               case 140:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(141, 144);
                  break;
               case 141:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(141, 144);
                  break;
               case 142:
                  if (curChar == 40 && kind > 68)
                     kind = 68;
                  break;
               case 143:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 142;
                  break;
               case 144:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 143;
                  break;
               case 145:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 140;
                  break;
               case 146:
                  if ((0x2400L & l) != 0L)
                     jjCheckNAddTwoStates(141, 144);
                  break;
               case 147:
                  if (curChar == 37)
                     jjCheckNAddStates(180, 185);
                  break;
               case 149:
                  jjCheckNAddStates(180, 185);
                  break;
               case 150:
                  if ((0xffffff5bffffffffL & l) != 0L)
                     jjCheckNAddStates(180, 185);
                  break;
               case 151:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 152;
                  break;
               case 152:
                  if ((0xfffffd7bffffffffL & l) != 0L)
                     jjCheckNAddStates(180, 185);
                  break;
               case 153:
                  if (curChar == 34)
                     jjCheckNAddStates(186, 188);
                  break;
               case 155:
                  jjCheckNAddStates(186, 188);
                  break;
               case 156:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(186, 188);
                  break;
               case 157:
                  if (curChar == 34)
                     jjCheckNAddStates(180, 185);
                  break;
               case 158:
                  if (curChar == 39)
                     jjCheckNAddStates(189, 191);
                  break;
               case 160:
                  jjCheckNAddStates(189, 191);
                  break;
               case 161:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(189, 191);
                  break;
               case 162:
                  if (curChar == 39)
                     jjCheckNAddStates(180, 185);
                  break;
               case 163:
                  if (curChar == 37)
                     jjAddStates(192, 193);
                  break;
               case 165:
                  if (curChar == 41 && kind > 69)
                     kind = 69;
                  break;
               case 166:
                  if (curChar != 40)
                     break;
                  if (kind > 70)
                     kind = 70;
                  jjCheckNAdd(167);
                  break;
               case 167:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 70)
                     kind = 70;
                  jjCheckNAdd(167);
                  break;
               case 168:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 166;
                  break;
               case 169:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 86)
                     kind = 86;
                  jjCheckNAddStates(80, 85);
                  break;
               case 170:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(170, 171);
                  break;
               case 171:
                  if (curChar == 40)
                     jjCheckNAdd(168);
                  break;
               case 172:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 86)
                     kind = 86;
                  jjCheckNAddTwoStates(172, 173);
                  break;
               case 174:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(174, 115);
                  break;
               case 177:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(75, 79);
                  break;
               case 178:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(179);
                  break;
               case 179:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(194, 198);
                  break;
               case 180:
                  if ((0x100002600L & l) != 0L)
                     jjCheckNAddStates(199, 205);
                  break;
               case 181:
                  if (curChar == 34)
                     jjCheckNAddStates(206, 208);
                  break;
               case 183:
                  jjCheckNAddStates(206, 208);
                  break;
               case 184:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(206, 208);
                  break;
               case 185:
                  if (curChar == 34)
                     jjCheckNAddStates(199, 205);
                  break;
               case 186:
                  if (curChar == 39)
                     jjCheckNAddStates(209, 211);
                  break;
               case 188:
                  jjCheckNAddStates(209, 211);
                  break;
               case 189:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(209, 211);
                  break;
               case 190:
                  if (curChar == 39)
                     jjCheckNAddStates(199, 205);
                  break;
               case 192:
               case 195:
                  jjCheckNAddStates(199, 205);
                  break;
               case 193:
                  if ((0xffffff7bffffffffL & l) != 0L)
                     jjCheckNAddStates(199, 205);
                  break;
               case 200:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 199;
                  break;
               case 201:
                  if (curChar == 10)
                     jjCheckNAddStates(199, 205);
                  break;
               case 202:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 201;
                  break;
               case 204:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(70, 74);
                  break;
               case 205:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(206);
                  break;
               case 206:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(212, 216);
                  break;
               case 207:
                  if ((0x100002600L & l) != 0L)
                     jjCheckNAddStates(217, 222);
                  break;
               case 208:
                  if (curChar == 34)
                     jjCheckNAddStates(223, 225);
                  break;
               case 210:
                  jjCheckNAddStates(223, 225);
                  break;
               case 211:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(223, 225);
                  break;
               case 212:
                  if (curChar == 34)
                     jjCheckNAddStates(217, 222);
                  break;
               case 213:
                  if (curChar == 39)
                     jjCheckNAddStates(226, 228);
                  break;
               case 215:
                  jjCheckNAddStates(226, 228);
                  break;
               case 216:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(226, 228);
                  break;
               case 217:
                  if (curChar == 39)
                     jjCheckNAddStates(217, 222);
                  break;
               case 219:
               case 222:
                  jjCheckNAddStates(217, 222);
                  break;
               case 220:
                  if ((0xffffff7bffffffffL & l) != 0L)
                     jjCheckNAddStates(217, 222);
                  break;
               case 226:
                  if (curChar == 10)
                     jjCheckNAddStates(217, 222);
                  break;
               case 227:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 226;
                  break;
               case 230:
                  if (curChar == 13)
                     jjAddStates(86, 87);
                  break;
               case 231:
                  if (curChar == 10 && kind > 88)
                     kind = 88;
                  break;
               case 232:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(234, 235);
                  break;
               case 233:
                  if (curChar == 10 && kind > 93)
                     kind = 93;
                  break;
               case 234:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 233;
                  break;
               case 235:
                  if ((0x2400L & l) != 0L && kind > 93)
                     kind = 93;
                  break;
               case 236:
                  if ((0x2400L & l) == 0L)
                     break;
                  if (kind > 88)
                     kind = 88;
                  jjCheckNAddTwoStates(234, 235);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 237:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(70, 74);
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(75, 79);
                  break;
               case 23:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                  {
                     if (kind > 89)
                        kind = 89;
                     jjCheckNAddTwoStates(116, 117);
                  }
                  else if ((0x78000001f8000001L & l) != 0L)
                  {
                     if (kind > 90)
                        kind = 90;
                  }
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(130, 132);
                  else if (curChar == 126)
                     jjCheckNAddStates(229, 231);
                  else if (curChar == 123)
                     jjAddStates(232, 233);
                  else if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 0;
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 85;
                  else if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 45;
                  else if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 176:
                  if (curChar == 123)
                     jjCheckNAdd(204);
                  if (curChar == 123)
                     jjCheckNAdd(177);
                  break;
               case 0:
                  if (curChar == 91)
                     jjCheckNAddStates(95, 99);
                  break;
               case 2:
               case 7:
                  if (curChar == 126)
                     jjCheckNAdd(3);
                  break;
               case 3:
                  jjCheckNAddStates(91, 94);
                  break;
               case 4:
                  if ((0xbfffffffdfffffffL & l) != 0L)
                     jjCheckNAddStates(91, 94);
                  break;
               case 5:
                  if (curChar == 93)
                     jjCheckNAdd(4);
                  break;
               case 6:
                  if (curChar == 93)
                     jjAddStates(234, 235);
                  break;
               case 8:
                  if (curChar == 93)
                     jjCheckNAddStates(95, 99);
                  break;
               case 9:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 10:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 11:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 12:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 11;
                  break;
               case 13:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 14:
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 15:
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 16:
               case 21:
                  if (curChar == 126)
                     jjCheckNAdd(17);
                  break;
               case 17:
                  jjCheckNAddStates(95, 99);
                  break;
               case 18:
                  if ((0xbfffffffdfffffffL & l) != 0L)
                     jjCheckNAddStates(95, 99);
                  break;
               case 19:
                  if (curChar == 93)
                     jjCheckNAdd(18);
                  break;
               case 20:
                  if (curChar == 93)
                     jjAddStates(236, 237);
                  break;
               case 22:
                  if (curChar == 93 && kind > 71)
                     kind = 71;
                  break;
               case 25:
               case 27:
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 26:
                  if (curChar == 126)
                     jjAddStates(238, 240);
                  break;
               case 28:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 29:
                  if ((0x78000001f8000001L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 30:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 24;
                  break;
               case 31:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 30;
                  break;
               case 32:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 33:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 32;
                  break;
               case 34:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 36:
               case 38:
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 37:
                  if (curChar == 126)
                     jjAddStates(241, 243);
                  break;
               case 39:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 40:
                  if ((0x78000001f8000001L & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 41:
                  if (curChar == 104)
                     jjstateSet[jjnewStateCnt++] = 35;
                  break;
               case 42:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 41;
                  break;
               case 43:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 42;
                  break;
               case 44:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 43;
                  break;
               case 45:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 44;
                  break;
               case 46:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 45;
                  break;
               case 49:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(107, 111);
                  break;
               case 51:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 52;
                  break;
               case 52:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(107, 111);
                  break;
               case 54:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(112, 116);
                  break;
               case 56:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 57;
                  break;
               case 57:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(112, 116);
                  break;
               case 59:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(117, 119);
                  break;
               case 61:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 62;
                  break;
               case 62:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(117, 119);
                  break;
               case 64:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 66:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 67:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 69:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 70:
                  if ((0x7e0000007eL & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 72:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 73:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(120, 124);
                  break;
               case 74:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(120, 124);
                  break;
               case 76:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(125, 129);
                  break;
               case 78:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 79;
                  break;
               case 79:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(125, 129);
                  break;
               case 80:
                  if ((0x47fffffe87fffffeL & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 81:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 47;
                  break;
               case 82:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 81;
                  break;
               case 83:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 84:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 83;
                  break;
               case 85:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 84;
                  break;
               case 86:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 85;
                  break;
               case 87:
               case 88:
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(130, 132);
                  break;
               case 90:
               case 91:
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(133, 135);
                  break;
               case 93:
                  if ((0x47fffffe87fffffeL & l) != 0L)
                     jjCheckNAddStates(144, 146);
                  break;
               case 95:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 96;
                  break;
               case 96:
                  if ((0x7e0000007eL & l) != 0L)
                     jjCheckNAddStates(144, 146);
                  break;
               case 97:
                  if (curChar != 64)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(147, 152);
                  break;
               case 99:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 100;
                  break;
               case 100:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(147, 152);
                  break;
               case 101:
                  if ((0x47fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(147, 152);
                  break;
               case 105:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(157, 161);
                  break;
               case 107:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 108;
                  break;
               case 108:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(157, 161);
                  break;
               case 116:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(116, 117);
                  break;
               case 117:
                  if (curChar == 126)
                     jjCheckNAdd(116);
                  break;
               case 118:
                  if ((0x78000001f8000001L & l) != 0L && kind > 90)
                     kind = 90;
                  break;
               case 121:
               case 137:
                  if (curChar == 126)
                     jjCheckNAdd(122);
                  break;
               case 122:
                  jjCheckNAddStates(162, 167);
                  break;
               case 123:
               case 125:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(162, 167);
                  break;
               case 127:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 128;
                  break;
               case 128:
                  jjCheckNAddStates(168, 170);
                  break;
               case 129:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(168, 170);
                  break;
               case 132:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 133;
                  break;
               case 133:
                  jjCheckNAddStates(171, 173);
                  break;
               case 134:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(171, 173);
                  break;
               case 148:
               case 164:
                  if (curChar == 126)
                     jjCheckNAdd(149);
                  break;
               case 149:
                  jjCheckNAddStates(180, 185);
                  break;
               case 150:
               case 152:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(180, 185);
                  break;
               case 154:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 155;
                  break;
               case 155:
                  jjCheckNAddStates(186, 188);
                  break;
               case 156:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(186, 188);
                  break;
               case 159:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 160;
                  break;
               case 160:
                  jjCheckNAddStates(189, 191);
                  break;
               case 161:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(189, 191);
                  break;
               case 173:
                  if (curChar == 126)
                     jjCheckNAdd(172);
                  break;
               case 175:
                  if (curChar == 123)
                     jjAddStates(232, 233);
                  break;
               case 177:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(75, 79);
                  break;
               case 178:
                  if (curChar == 95)
                     jjCheckNAdd(179);
                  break;
               case 179:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(194, 198);
                  break;
               case 182:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 183;
                  break;
               case 183:
                  jjCheckNAddStates(206, 208);
                  break;
               case 184:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(206, 208);
                  break;
               case 187:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 188;
                  break;
               case 188:
                  jjCheckNAddStates(209, 211);
                  break;
               case 189:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(209, 211);
                  break;
               case 191:
               case 196:
                  if (curChar == 126)
                     jjCheckNAdd(192);
                  break;
               case 192:
                  jjCheckNAddStates(199, 205);
                  break;
               case 193:
               case 195:
                  if ((0x9fffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(199, 205);
                  break;
               case 194:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 195;
                  break;
               case 197:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 196;
                  break;
               case 198:
                  if (curChar == 125 && kind > 73)
                     kind = 73;
                  break;
               case 199:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 198;
                  break;
               case 203:
                  if (curChar == 123)
                     jjCheckNAdd(204);
                  break;
               case 204:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(70, 74);
                  break;
               case 205:
                  if (curChar == 95)
                     jjCheckNAdd(206);
                  break;
               case 206:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(212, 216);
                  break;
               case 209:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 210;
                  break;
               case 210:
                  jjCheckNAddStates(223, 225);
                  break;
               case 211:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(223, 225);
                  break;
               case 214:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 215;
                  break;
               case 215:
                  jjCheckNAddStates(226, 228);
                  break;
               case 216:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(226, 228);
                  break;
               case 218:
               case 224:
                  if (curChar == 126)
                     jjCheckNAdd(219);
                  break;
               case 219:
                  jjCheckNAddStates(217, 222);
                  break;
               case 220:
               case 222:
                  if ((0x9fffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(217, 222);
                  break;
               case 221:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 222;
                  break;
               case 223:
                  if (curChar == 125)
                     jjCheckNAddTwoStates(224, 225);
                  break;
               case 225:
                  if (curChar == 125 && kind > 74)
                     kind = 74;
                  break;
               case 228:
                  if (curChar == 125)
                     jjCheckNAdd(225);
                  break;
               case 229:
                  if (curChar == 126)
                     jjCheckNAddStates(229, 231);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 237:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(75, 79);
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(70, 74);
                  break;
               case 23:
               case 116:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(116, 117);
                  break;
               case 3:
               case 4:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(91, 94);
                  break;
               case 17:
               case 18:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(95, 99);
                  break;
               case 25:
               case 27:
               case 28:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 36:
               case 38:
               case 39:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 122:
               case 123:
               case 125:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(162, 167);
                  break;
               case 128:
               case 129:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(168, 170);
                  break;
               case 133:
               case 134:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(171, 173);
                  break;
               case 149:
               case 150:
               case 152:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(180, 185);
                  break;
               case 155:
               case 156:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(186, 188);
                  break;
               case 160:
               case 161:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(189, 191);
                  break;
               case 177:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(75, 79);
                  break;
               case 179:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(194, 198);
                  break;
               case 183:
               case 184:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(206, 208);
                  break;
               case 188:
               case 189:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(209, 211);
                  break;
               case 192:
               case 193:
               case 195:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(199, 205);
                  break;
               case 204:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(70, 74);
                  break;
               case 206:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(212, 216);
                  break;
               case 210:
               case 211:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(223, 225);
                  break;
               case 215:
               case 216:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(226, 228);
                  break;
               case 219:
               case 220:
               case 222:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(217, 222);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 237 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_5()
{
   return jjMoveNfa_5(0, 0);
}
private int jjMoveNfa_5(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 41;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (kind > 20)
                     kind = 20;
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 1:
                  if (curChar == 10 && kind > 20)
                     kind = 20;
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 4:
                  if ((0x3ff0000ffffd9ffL & l) != 0L && kind > 20)
                     kind = 20;
                  break;
               case 5:
                  if ((0xfc00fffe00000000L & l) != 0L && kind > 20)
                     kind = 20;
                  break;
               case 8:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(244, 248);
                  break;
               case 9:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(10);
                  break;
               case 10:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(249, 253);
                  break;
               case 11:
                  if ((0x100002600L & l) != 0L)
                     jjCheckNAddStates(254, 259);
                  break;
               case 12:
                  if (curChar == 34)
                     jjCheckNAddStates(260, 262);
                  break;
               case 14:
                  jjCheckNAddStates(260, 262);
                  break;
               case 15:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(260, 262);
                  break;
               case 16:
                  if (curChar == 34)
                     jjCheckNAddStates(254, 259);
                  break;
               case 17:
                  if (curChar == 39)
                     jjCheckNAddStates(263, 265);
                  break;
               case 19:
                  jjCheckNAddStates(263, 265);
                  break;
               case 20:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(263, 265);
                  break;
               case 21:
                  if (curChar == 39)
                     jjCheckNAddStates(254, 259);
                  break;
               case 23:
               case 26:
                  jjCheckNAddStates(254, 259);
                  break;
               case 24:
                  if ((0xffffff7bffffffffL & l) != 0L)
                     jjCheckNAddStates(254, 259);
                  break;
               case 30:
                  if (curChar == 10)
                     jjCheckNAddStates(254, 259);
                  break;
               case 31:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 30;
                  break;
               case 33:
                  if (curChar == 47)
                     jjCheckNAdd(34);
                  break;
               case 34:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(266, 269);
                  break;
               case 35:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(36);
                  break;
               case 36:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(270, 273);
                  break;
               case 37:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(37, 39);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (kind > 20)
                     kind = 20;
                  if (curChar == 123)
                     jjAddStates(274, 275);
                  else if (curChar == 126)
                     jjAddStates(276, 277);
                  break;
               case 3:
                  if (curChar == 126)
                     jjAddStates(276, 277);
                  break;
               case 4:
                  if ((0x87fffffe07fffffeL & l) != 0L && kind > 20)
                     kind = 20;
                  break;
               case 5:
                  if ((0x78000001f8000001L & l) != 0L && kind > 20)
                     kind = 20;
                  break;
               case 6:
                  if (curChar == 123)
                     jjAddStates(274, 275);
                  break;
               case 7:
                  if (curChar == 123)
                     jjCheckNAdd(8);
                  break;
               case 8:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(244, 248);
                  break;
               case 9:
                  if (curChar == 95)
                     jjCheckNAdd(10);
                  break;
               case 10:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(249, 253);
                  break;
               case 13:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 14:
                  jjCheckNAddStates(260, 262);
                  break;
               case 15:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(260, 262);
                  break;
               case 18:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 19;
                  break;
               case 19:
                  jjCheckNAddStates(263, 265);
                  break;
               case 20:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(263, 265);
                  break;
               case 22:
               case 28:
                  if (curChar == 126)
                     jjCheckNAdd(23);
                  break;
               case 23:
                  jjCheckNAddStates(254, 259);
                  break;
               case 24:
               case 26:
                  if ((0x9fffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(254, 259);
                  break;
               case 25:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 26;
                  break;
               case 27:
                  if (curChar == 125)
                     jjCheckNAddTwoStates(28, 29);
                  break;
               case 29:
                  if (curChar == 125 && kind > 18)
                     kind = 18;
                  break;
               case 32:
                  if (curChar == 125)
                     jjCheckNAdd(29);
                  break;
               case 34:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(266, 269);
                  break;
               case 35:
                  if (curChar == 95)
                     jjCheckNAdd(36);
                  break;
               case 36:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(270, 273);
                  break;
               case 38:
                  if (curChar == 125 && kind > 19)
                     kind = 19;
                  break;
               case 39:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 38;
                  break;
               case 40:
                  if (curChar == 123)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
               case 4:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 20)
                     kind = 20;
                  break;
               case 8:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(244, 248);
                  break;
               case 10:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(249, 253);
                  break;
               case 14:
               case 15:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(260, 262);
                  break;
               case 19:
               case 20:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(263, 265);
                  break;
               case 23:
               case 24:
               case 26:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(254, 259);
                  break;
               case 34:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(266, 269);
                  break;
               case 36:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(270, 273);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 41 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_4()
{
   return jjMoveNfa_4(0, 0);
}
private int jjMoveNfa_4(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 9;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
               case 8:
               case 7:
                  if (kind > 17)
                     kind = 17;
                  jjCheckNAddTwoStates(6, 8);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x97ffffffffffffffL & l) != 0L)
                  {
                     if (kind > 17)
                        kind = 17;
                     jjCheckNAddTwoStates(6, 8);
                  }
                  else if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 7;
                  else if (curChar == 125)
                  {
                     if (kind > 16)
                        kind = 16;
                     jjstateSet[jjnewStateCnt++] = 4;
                  }
                  else if (curChar == 123)
                  {
                     if (kind > 15)
                        kind = 15;
                     jjstateSet[jjnewStateCnt++] = 1;
                  }
                  break;
               case 1:
                  if (curChar != 123)
                     break;
                  if (kind > 15)
                     kind = 15;
                  jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 2:
                  if (curChar == 123 && kind > 15)
                     kind = 15;
                  break;
               case 3:
                  if (curChar != 125)
                     break;
                  if (kind > 16)
                     kind = 16;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 4:
                  if (curChar != 125)
                     break;
                  if (kind > 16)
                     kind = 16;
                  jjstateSet[jjnewStateCnt++] = 5;
                  break;
               case 5:
                  if (curChar == 125 && kind > 16)
                     kind = 16;
                  break;
               case 6:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 7:
                  if (kind > 17)
                     kind = 17;
                  jjCheckNAddTwoStates(6, 8);
                  break;
               case 8:
                  if ((0x97ffffffffffffffL & l) == 0L)
                     break;
                  if (kind > 17)
                     kind = 17;
                  jjCheckNAddTwoStates(6, 8);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
               case 8:
               case 7:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 17)
                     kind = 17;
                  jjCheckNAddTwoStates(6, 8);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 9 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_3(int pos, long active0, long active1)
{
   switch (pos)
   {
      case 0:
         if ((active1 & 0x100L) != 0L)
         {
            jjmatchedKind = 90;
            return 195;
         }
         if ((active1 & 0x13f800L) != 0L)
         {
            jjmatchedKind = 90;
            return -1;
         }
         return -1;
      case 1:
         if ((active1 & 0x100L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 90;
               jjmatchedPos = 0;
            }
            return 249;
         }
         if ((active1 & 0x13f800L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 90;
               jjmatchedPos = 0;
            }
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_3(int pos, long active0, long active1)
{
   return jjMoveNfa_3(jjStopStringLiteralDfa_3(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_3()
{
   switch(curChar)
   {
      case 35:
         return jjMoveStringLiteralDfa1_3(0x20000L);
      case 42:
         return jjMoveStringLiteralDfa1_3(0x800L);
      case 44:
         return jjMoveStringLiteralDfa1_3(0x10000L);
      case 45:
         return jjMoveStringLiteralDfa1_3(0x2000L);
      case 47:
         return jjMoveStringLiteralDfa1_3(0x1000L);
      case 92:
         return jjMoveStringLiteralDfa1_3(0x100000L);
      case 94:
         return jjMoveStringLiteralDfa1_3(0x8000L);
      case 95:
         return jjMoveStringLiteralDfa1_3(0x4000L);
      case 123:
         return jjMoveStringLiteralDfa1_3(0x100L);
      default :
         return jjMoveNfa_3(23, 0);
   }
}
private int jjMoveStringLiteralDfa1_3(long active1)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 35:
         if ((active1 & 0x20000L) != 0L)
            return jjStopAtPos(1, 81);
         break;
      case 42:
         if ((active1 & 0x800L) != 0L)
            return jjStopAtPos(1, 75);
         break;
      case 44:
         if ((active1 & 0x10000L) != 0L)
            return jjStopAtPos(1, 80);
         break;
      case 45:
         if ((active1 & 0x2000L) != 0L)
            return jjStopAtPos(1, 77);
         break;
      case 47:
         if ((active1 & 0x1000L) != 0L)
            return jjStopAtPos(1, 76);
         break;
      case 92:
         if ((active1 & 0x100000L) != 0L)
            return jjStopAtPos(1, 84);
         break;
      case 94:
         if ((active1 & 0x8000L) != 0L)
            return jjStopAtPos(1, 79);
         break;
      case 95:
         if ((active1 & 0x4000L) != 0L)
            return jjStopAtPos(1, 78);
         break;
      case 123:
         return jjMoveStringLiteralDfa2_3(active1, 0x100L);
      default :
         break;
   }
   return jjStartNfa_3(0, 0L, active1);
}
private int jjMoveStringLiteralDfa2_3(long old1, long active1)
{
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_3(0, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(1, 0L, active1);
      return 2;
   }
   switch(curChar)
   {
      case 123:
         if ((active1 & 0x100L) != 0L)
            return jjStopAtPos(2, 72);
         break;
      default :
         break;
   }
   return jjStartNfa_3(1, 0L, active1);
}
private int jjMoveNfa_3(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 249;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 23:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                  {
                     if (kind > 89)
                        kind = 89;
                     jjCheckNAddTwoStates(116, 117);
                  }
                  else if ((0xfc00fffe00000000L & l) != 0L)
                  {
                     if (kind > 90)
                        kind = 90;
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 88)
                        kind = 88;
                     jjCheckNAddStates(278, 281);
                  }
                  else if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 86)
                        kind = 86;
                     jjCheckNAddStates(282, 291);
                  }
                  if (curChar == 40)
                     jjCheckNAddStates(292, 294);
                  else if (curChar == 13)
                     jjAddStates(295, 297);
                  else if (curChar == 61)
                  {
                     if (kind > 13)
                        kind = 13;
                     jjCheckNAddStates(298, 301);
                  }
                  else if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 114;
                  break;
               case 249:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(302, 306);
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(307, 311);
                  break;
               case 1:
                  if (curChar == 58)
                     jjCheckNAddStates(91, 94);
                  break;
               case 3:
               case 4:
                  jjCheckNAddStates(91, 94);
                  break;
               case 17:
               case 18:
                  jjCheckNAddStates(95, 99);
                  break;
               case 24:
                  if (curChar != 58)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 25:
                  if ((0xfffffffeffffd9ffL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 27:
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 28:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 29:
                  if ((0xfc00fffe00000000L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 35:
                  if (curChar != 58)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 36:
                  if ((0xfffffffeffffd9ffL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 38:
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 39:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 40:
                  if ((0xfc00fffe00000000L & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 47:
                  if (curChar == 58)
                     jjAddStates(100, 102);
                  break;
               case 48:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(103, 106);
                  break;
               case 49:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(107, 111);
                  break;
               case 50:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 51;
                  break;
               case 51:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 52;
                  break;
               case 52:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(107, 111);
                  break;
               case 53:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(112, 116);
                  break;
               case 54:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(112, 116);
                  break;
               case 55:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 56;
                  break;
               case 56:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 57;
                  break;
               case 57:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(112, 116);
                  break;
               case 58:
                  if (curChar != 63)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(117, 119);
                  break;
               case 59:
                  if ((0xafffefd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(117, 119);
                  break;
               case 60:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 61;
                  break;
               case 61:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 62;
                  break;
               case 62:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(117, 119);
                  break;
               case 63:
                  if (curChar != 35)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 64:
                  if ((0xafffefd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 65:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 66;
                  break;
               case 66:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 67:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 68:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 69;
                  break;
               case 69:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 70:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 71:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 72;
                  break;
               case 72:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 73:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(120, 124);
                  break;
               case 74:
                  if ((0x2bff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(120, 124);
                  break;
               case 75:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(125, 129);
                  break;
               case 76:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(125, 129);
                  break;
               case 77:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 78;
                  break;
               case 78:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 79;
                  break;
               case 79:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(125, 129);
                  break;
               case 80:
                  if ((0x2bff6fd200000000L & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 88:
                  if ((0x3ff680000000000L & l) != 0L)
                     jjCheckNAddStates(130, 132);
                  break;
               case 89:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 90;
                  break;
               case 91:
                  if ((0x3ff680000000000L & l) != 0L)
                     jjCheckNAddStates(133, 135);
                  break;
               case 92:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(136, 143);
                  break;
               case 93:
                  if ((0x2fff6fd200000000L & l) != 0L)
                     jjCheckNAddStates(144, 146);
                  break;
               case 94:
                  if (curChar == 37)
                     jjCheckNAdd(95);
                  break;
               case 95:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 96;
                  break;
               case 96:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(144, 146);
                  break;
               case 98:
                  if (curChar == 37)
                     jjCheckNAdd(99);
                  break;
               case 99:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 100;
                  break;
               case 100:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(147, 152);
                  break;
               case 101:
                  if ((0x2bff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(147, 152);
                  break;
               case 102:
                  if (curChar == 58)
                     jjCheckNAdd(103);
                  break;
               case 103:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(153, 156);
                  break;
               case 104:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(157, 161);
                  break;
               case 105:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(157, 161);
                  break;
               case 106:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 107;
                  break;
               case 107:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 108;
                  break;
               case 108:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(157, 161);
                  break;
               case 109:
                  if (curChar == 37)
                     jjCheckNAddTwoStates(95, 99);
                  break;
               case 110:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 92;
                  break;
               case 111:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 110;
                  break;
               case 112:
                  if (curChar != 41)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjCheckNAdd(113);
                  break;
               case 113:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjCheckNAdd(113);
                  break;
               case 114:
                  if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 112;
                  break;
               case 115:
                  if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 114;
                  break;
               case 116:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(116, 117);
                  break;
               case 118:
                  if ((0xfc00fffe00000000L & l) != 0L && kind > 90)
                     kind = 90;
                  break;
               case 119:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 86)
                     kind = 86;
                  jjCheckNAddStates(282, 291);
                  break;
               case 120:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(120, 121);
                  break;
               case 121:
                  if (curChar == 61)
                     jjCheckNAddStates(312, 314);
                  break;
               case 122:
                  if (curChar == 10 && kind > 12)
                     kind = 12;
                  break;
               case 123:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 122;
                  break;
               case 124:
                  if ((0x2400L & l) != 0L && kind > 12)
                     kind = 12;
                  break;
               case 125:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(125, 126);
                  break;
               case 126:
                  if (curChar != 61)
                     break;
                  if (kind > 13)
                     kind = 13;
                  jjCheckNAdd(126);
                  break;
               case 127:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(127, 131);
                  break;
               case 128:
                  if (curChar != 40)
                     break;
                  if (kind > 70)
                     kind = 70;
                  jjCheckNAdd(129);
                  break;
               case 129:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 70)
                     kind = 70;
                  jjCheckNAdd(129);
                  break;
               case 130:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 128;
                  break;
               case 131:
                  if (curChar == 40)
                     jjCheckNAdd(130);
                  break;
               case 132:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 86)
                     kind = 86;
                  jjCheckNAddTwoStates(132, 133);
                  break;
               case 134:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(134, 115);
                  break;
               case 135:
                  if (curChar != 61)
                     break;
                  if (kind > 13)
                     kind = 13;
                  jjCheckNAddStates(298, 301);
                  break;
               case 136:
                  if (curChar == 13)
                     jjAddStates(295, 297);
                  break;
               case 137:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(138, 139);
                  break;
               case 138:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(138, 139);
                  break;
               case 139:
                  if (curChar != 61)
                     break;
                  if (kind > 14)
                     kind = 14;
                  jjCheckNAddTwoStates(139, 140);
                  break;
               case 140:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 14)
                     kind = 14;
                  jjCheckNAdd(140);
                  break;
               case 141:
                  if (curChar == 10 && kind > 88)
                     kind = 88;
                  break;
               case 142:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(144, 145);
                  break;
               case 143:
                  if (curChar == 10 && kind > 92)
                     kind = 92;
                  break;
               case 144:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 143;
                  break;
               case 145:
                  if ((0x2400L & l) != 0L && kind > 92)
                     kind = 92;
                  break;
               case 146:
                  if ((0x2400L & l) == 0L)
                     break;
                  if (kind > 88)
                     kind = 88;
                  jjCheckNAddStates(278, 281);
                  break;
               case 147:
                  if (curChar == 40)
                     jjCheckNAddStates(292, 294);
                  break;
               case 148:
                  if (curChar == 37)
                     jjCheckNAddStates(315, 320);
                  break;
               case 150:
                  jjCheckNAddStates(315, 320);
                  break;
               case 151:
                  if ((0xffffff5bffffffffL & l) != 0L)
                     jjCheckNAddStates(315, 320);
                  break;
               case 152:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 153;
                  break;
               case 153:
                  if ((0xfffffd7bffffffffL & l) != 0L)
                     jjCheckNAddStates(315, 320);
                  break;
               case 154:
                  if (curChar == 34)
                     jjCheckNAddStates(321, 323);
                  break;
               case 156:
                  jjCheckNAddStates(321, 323);
                  break;
               case 157:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(321, 323);
                  break;
               case 158:
                  if (curChar == 34)
                     jjCheckNAddStates(315, 320);
                  break;
               case 159:
                  if (curChar == 39)
                     jjCheckNAddStates(324, 326);
                  break;
               case 161:
                  jjCheckNAddStates(324, 326);
                  break;
               case 162:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(324, 326);
                  break;
               case 163:
                  if (curChar == 39)
                     jjCheckNAddStates(315, 320);
                  break;
               case 164:
                  if (curChar == 37)
                     jjAddStates(327, 328);
                  break;
               case 166:
                  if (curChar == 41)
                     jjCheckNAddStates(329, 332);
                  break;
               case 167:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(329, 332);
                  break;
               case 168:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(169, 172);
                  break;
               case 169:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(169, 172);
                  break;
               case 170:
                  if (curChar == 40 && kind > 68)
                     kind = 68;
                  break;
               case 171:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 170;
                  break;
               case 172:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 171;
                  break;
               case 173:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 168;
                  break;
               case 174:
                  if ((0x2400L & l) != 0L)
                     jjCheckNAddTwoStates(169, 172);
                  break;
               case 175:
                  if (curChar == 37)
                     jjCheckNAddStates(333, 338);
                  break;
               case 177:
                  jjCheckNAddStates(333, 338);
                  break;
               case 178:
                  if ((0xffffff5bffffffffL & l) != 0L)
                     jjCheckNAddStates(333, 338);
                  break;
               case 179:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 180;
                  break;
               case 180:
                  if ((0xfffffd7bffffffffL & l) != 0L)
                     jjCheckNAddStates(333, 338);
                  break;
               case 181:
                  if (curChar == 34)
                     jjCheckNAddStates(206, 208);
                  break;
               case 183:
                  jjCheckNAddStates(206, 208);
                  break;
               case 184:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(206, 208);
                  break;
               case 185:
                  if (curChar == 34)
                     jjCheckNAddStates(333, 338);
                  break;
               case 186:
                  if (curChar == 39)
                     jjCheckNAddStates(209, 211);
                  break;
               case 188:
                  jjCheckNAddStates(209, 211);
                  break;
               case 189:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(209, 211);
                  break;
               case 190:
                  if (curChar == 39)
                     jjCheckNAddStates(333, 338);
                  break;
               case 191:
                  if (curChar == 37)
                     jjAddStates(339, 340);
                  break;
               case 193:
                  if (curChar == 41 && kind > 69)
                     kind = 69;
                  break;
               case 196:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(307, 311);
                  break;
               case 197:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(198);
                  break;
               case 198:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(341, 345);
                  break;
               case 199:
                  if ((0x100002600L & l) != 0L)
                     jjCheckNAddStates(346, 352);
                  break;
               case 200:
                  if (curChar == 34)
                     jjCheckNAddStates(353, 355);
                  break;
               case 202:
                  jjCheckNAddStates(353, 355);
                  break;
               case 203:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(353, 355);
                  break;
               case 204:
                  if (curChar == 34)
                     jjCheckNAddStates(346, 352);
                  break;
               case 205:
                  if (curChar == 39)
                     jjCheckNAddStates(356, 358);
                  break;
               case 207:
                  jjCheckNAddStates(356, 358);
                  break;
               case 208:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(356, 358);
                  break;
               case 209:
                  if (curChar == 39)
                     jjCheckNAddStates(346, 352);
                  break;
               case 211:
               case 214:
                  jjCheckNAddStates(346, 352);
                  break;
               case 212:
                  if ((0xffffff7bffffffffL & l) != 0L)
                     jjCheckNAddStates(346, 352);
                  break;
               case 219:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 218;
                  break;
               case 220:
                  if (curChar == 10)
                     jjCheckNAddStates(346, 352);
                  break;
               case 221:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 220;
                  break;
               case 223:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(302, 306);
                  break;
               case 224:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(225);
                  break;
               case 225:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(359, 363);
                  break;
               case 226:
                  if ((0x100002600L & l) != 0L)
                     jjCheckNAddStates(364, 369);
                  break;
               case 227:
                  if (curChar == 34)
                     jjCheckNAddStates(370, 372);
                  break;
               case 229:
                  jjCheckNAddStates(370, 372);
                  break;
               case 230:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(370, 372);
                  break;
               case 231:
                  if (curChar == 34)
                     jjCheckNAddStates(364, 369);
                  break;
               case 232:
                  if (curChar == 39)
                     jjCheckNAddStates(373, 375);
                  break;
               case 234:
                  jjCheckNAddStates(373, 375);
                  break;
               case 235:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(373, 375);
                  break;
               case 236:
                  if (curChar == 39)
                     jjCheckNAddStates(364, 369);
                  break;
               case 238:
               case 241:
                  jjCheckNAddStates(364, 369);
                  break;
               case 239:
                  if ((0xffffff7bffffffffL & l) != 0L)
                     jjCheckNAddStates(364, 369);
                  break;
               case 245:
                  if (curChar == 10)
                     jjCheckNAddStates(364, 369);
                  break;
               case 246:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 245;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 23:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                  {
                     if (kind > 89)
                        kind = 89;
                     jjCheckNAddTwoStates(116, 117);
                  }
                  else if ((0x78000001f8000001L & l) != 0L)
                  {
                     if (kind > 90)
                        kind = 90;
                  }
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(130, 132);
                  else if (curChar == 126)
                     jjCheckNAddStates(376, 378);
                  else if (curChar == 123)
                     jjAddStates(379, 380);
                  else if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 0;
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 85;
                  else if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 45;
                  else if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 195:
                  if (curChar == 123)
                     jjCheckNAdd(223);
                  if (curChar == 123)
                     jjCheckNAdd(196);
                  break;
               case 249:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(302, 306);
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(307, 311);
                  break;
               case 0:
                  if (curChar == 91)
                     jjCheckNAddStates(95, 99);
                  break;
               case 2:
               case 7:
                  if (curChar == 126)
                     jjCheckNAdd(3);
                  break;
               case 3:
                  jjCheckNAddStates(91, 94);
                  break;
               case 4:
                  if ((0xbfffffffdfffffffL & l) != 0L)
                     jjCheckNAddStates(91, 94);
                  break;
               case 5:
                  if (curChar == 93)
                     jjCheckNAdd(4);
                  break;
               case 6:
                  if (curChar == 93)
                     jjAddStates(234, 235);
                  break;
               case 8:
                  if (curChar == 93)
                     jjCheckNAddStates(95, 99);
                  break;
               case 9:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 10:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 11:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 12:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 11;
                  break;
               case 13:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 14:
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 15:
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 16:
               case 21:
                  if (curChar == 126)
                     jjCheckNAdd(17);
                  break;
               case 17:
                  jjCheckNAddStates(95, 99);
                  break;
               case 18:
                  if ((0xbfffffffdfffffffL & l) != 0L)
                     jjCheckNAddStates(95, 99);
                  break;
               case 19:
                  if (curChar == 93)
                     jjCheckNAdd(18);
                  break;
               case 20:
                  if (curChar == 93)
                     jjAddStates(236, 237);
                  break;
               case 22:
                  if (curChar == 93 && kind > 71)
                     kind = 71;
                  break;
               case 25:
               case 27:
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 26:
                  if (curChar == 126)
                     jjAddStates(238, 240);
                  break;
               case 28:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 29:
                  if ((0x78000001f8000001L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 30:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 24;
                  break;
               case 31:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 30;
                  break;
               case 32:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 33:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 32;
                  break;
               case 34:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 36:
               case 38:
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 37:
                  if (curChar == 126)
                     jjAddStates(241, 243);
                  break;
               case 39:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 40:
                  if ((0x78000001f8000001L & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 41:
                  if (curChar == 104)
                     jjstateSet[jjnewStateCnt++] = 35;
                  break;
               case 42:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 41;
                  break;
               case 43:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 42;
                  break;
               case 44:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 43;
                  break;
               case 45:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 44;
                  break;
               case 46:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 45;
                  break;
               case 49:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(107, 111);
                  break;
               case 51:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 52;
                  break;
               case 52:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(107, 111);
                  break;
               case 54:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(112, 116);
                  break;
               case 56:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 57;
                  break;
               case 57:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(112, 116);
                  break;
               case 59:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(117, 119);
                  break;
               case 61:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 62;
                  break;
               case 62:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(117, 119);
                  break;
               case 64:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 66:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 67:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 69:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 70:
                  if ((0x7e0000007eL & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 72:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 73:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(120, 124);
                  break;
               case 74:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(120, 124);
                  break;
               case 76:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(125, 129);
                  break;
               case 78:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 79;
                  break;
               case 79:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(125, 129);
                  break;
               case 80:
                  if ((0x47fffffe87fffffeL & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 81:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 47;
                  break;
               case 82:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 81;
                  break;
               case 83:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 84:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 83;
                  break;
               case 85:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 84;
                  break;
               case 86:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 85;
                  break;
               case 87:
               case 88:
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(130, 132);
                  break;
               case 90:
               case 91:
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(133, 135);
                  break;
               case 93:
                  if ((0x47fffffe87fffffeL & l) != 0L)
                     jjCheckNAddStates(144, 146);
                  break;
               case 95:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 96;
                  break;
               case 96:
                  if ((0x7e0000007eL & l) != 0L)
                     jjCheckNAddStates(144, 146);
                  break;
               case 97:
                  if (curChar != 64)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(147, 152);
                  break;
               case 99:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 100;
                  break;
               case 100:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(147, 152);
                  break;
               case 101:
                  if ((0x47fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(147, 152);
                  break;
               case 105:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(157, 161);
                  break;
               case 107:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 108;
                  break;
               case 108:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(157, 161);
                  break;
               case 116:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(116, 117);
                  break;
               case 117:
                  if (curChar == 126)
                     jjCheckNAdd(116);
                  break;
               case 118:
                  if ((0x78000001f8000001L & l) != 0L && kind > 90)
                     kind = 90;
                  break;
               case 133:
                  if (curChar == 126)
                     jjCheckNAdd(132);
                  break;
               case 149:
               case 165:
                  if (curChar == 126)
                     jjCheckNAdd(150);
                  break;
               case 150:
                  jjCheckNAddStates(315, 320);
                  break;
               case 151:
               case 153:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(315, 320);
                  break;
               case 155:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 156;
                  break;
               case 156:
                  jjCheckNAddStates(321, 323);
                  break;
               case 157:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(321, 323);
                  break;
               case 160:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 161;
                  break;
               case 161:
                  jjCheckNAddStates(324, 326);
                  break;
               case 162:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(324, 326);
                  break;
               case 176:
               case 192:
                  if (curChar == 126)
                     jjCheckNAdd(177);
                  break;
               case 177:
                  jjCheckNAddStates(333, 338);
                  break;
               case 178:
               case 180:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(333, 338);
                  break;
               case 182:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 183;
                  break;
               case 183:
                  jjCheckNAddStates(206, 208);
                  break;
               case 184:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(206, 208);
                  break;
               case 187:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 188;
                  break;
               case 188:
                  jjCheckNAddStates(209, 211);
                  break;
               case 189:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(209, 211);
                  break;
               case 194:
                  if (curChar == 123)
                     jjAddStates(379, 380);
                  break;
               case 196:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(307, 311);
                  break;
               case 197:
                  if (curChar == 95)
                     jjCheckNAdd(198);
                  break;
               case 198:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(341, 345);
                  break;
               case 201:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 202;
                  break;
               case 202:
                  jjCheckNAddStates(353, 355);
                  break;
               case 203:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(353, 355);
                  break;
               case 206:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 207;
                  break;
               case 207:
                  jjCheckNAddStates(356, 358);
                  break;
               case 208:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(356, 358);
                  break;
               case 210:
               case 215:
                  if (curChar == 126)
                     jjCheckNAdd(211);
                  break;
               case 211:
                  jjCheckNAddStates(346, 352);
                  break;
               case 212:
               case 214:
                  if ((0x9fffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(346, 352);
                  break;
               case 213:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 214;
                  break;
               case 216:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 215;
                  break;
               case 217:
                  if (curChar == 125 && kind > 73)
                     kind = 73;
                  break;
               case 218:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 217;
                  break;
               case 222:
                  if (curChar == 123)
                     jjCheckNAdd(223);
                  break;
               case 223:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(302, 306);
                  break;
               case 224:
                  if (curChar == 95)
                     jjCheckNAdd(225);
                  break;
               case 225:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(359, 363);
                  break;
               case 228:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 229;
                  break;
               case 229:
                  jjCheckNAddStates(370, 372);
                  break;
               case 230:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(370, 372);
                  break;
               case 233:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 234;
                  break;
               case 234:
                  jjCheckNAddStates(373, 375);
                  break;
               case 235:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(373, 375);
                  break;
               case 237:
               case 243:
                  if (curChar == 126)
                     jjCheckNAdd(238);
                  break;
               case 238:
                  jjCheckNAddStates(364, 369);
                  break;
               case 239:
               case 241:
                  if ((0x9fffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(364, 369);
                  break;
               case 240:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 241;
                  break;
               case 242:
                  if (curChar == 125)
                     jjCheckNAddTwoStates(243, 244);
                  break;
               case 244:
                  if (curChar == 125 && kind > 74)
                     kind = 74;
                  break;
               case 247:
                  if (curChar == 125)
                     jjCheckNAdd(244);
                  break;
               case 248:
                  if (curChar == 126)
                     jjCheckNAddStates(376, 378);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 23:
               case 116:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(116, 117);
                  break;
               case 249:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(307, 311);
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(302, 306);
                  break;
               case 3:
               case 4:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(91, 94);
                  break;
               case 17:
               case 18:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(95, 99);
                  break;
               case 25:
               case 27:
               case 28:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 36:
               case 38:
               case 39:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 150:
               case 151:
               case 153:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(315, 320);
                  break;
               case 156:
               case 157:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(321, 323);
                  break;
               case 161:
               case 162:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(324, 326);
                  break;
               case 177:
               case 178:
               case 180:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(333, 338);
                  break;
               case 183:
               case 184:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(206, 208);
                  break;
               case 188:
               case 189:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(209, 211);
                  break;
               case 196:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(307, 311);
                  break;
               case 198:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(341, 345);
                  break;
               case 202:
               case 203:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(353, 355);
                  break;
               case 207:
               case 208:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(356, 358);
                  break;
               case 211:
               case 212:
               case 214:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(346, 352);
                  break;
               case 223:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(302, 306);
                  break;
               case 225:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(359, 363);
                  break;
               case 229:
               case 230:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(370, 372);
                  break;
               case 234:
               case 235:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(373, 375);
                  break;
               case 238:
               case 239:
               case 241:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(364, 369);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 249 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_2(int pos, long active0, long active1)
{
   switch (pos)
   {
      case 0:
         if ((active1 & 0x100L) != 0L)
         {
            jjmatchedKind = 90;
            return 181;
         }
         if ((active1 & 0x13f800L) != 0L)
         {
            jjmatchedKind = 90;
            return -1;
         }
         return -1;
      case 1:
         if ((active1 & 0x100L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 90;
               jjmatchedPos = 0;
            }
            return 242;
         }
         if ((active1 & 0x13f800L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 90;
               jjmatchedPos = 0;
            }
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_2(int pos, long active0, long active1)
{
   return jjMoveNfa_2(jjStopStringLiteralDfa_2(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_2()
{
   switch(curChar)
   {
      case 35:
         return jjMoveStringLiteralDfa1_2(0x20000L);
      case 42:
         return jjMoveStringLiteralDfa1_2(0x800L);
      case 44:
         return jjMoveStringLiteralDfa1_2(0x10000L);
      case 45:
         return jjMoveStringLiteralDfa1_2(0x2000L);
      case 47:
         return jjMoveStringLiteralDfa1_2(0x1000L);
      case 92:
         return jjMoveStringLiteralDfa1_2(0x100000L);
      case 94:
         return jjMoveStringLiteralDfa1_2(0x8000L);
      case 95:
         return jjMoveStringLiteralDfa1_2(0x4000L);
      case 123:
         return jjMoveStringLiteralDfa1_2(0x100L);
      default :
         return jjMoveNfa_2(1, 0);
   }
}
private int jjMoveStringLiteralDfa1_2(long active1)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 35:
         if ((active1 & 0x20000L) != 0L)
            return jjStopAtPos(1, 81);
         break;
      case 42:
         if ((active1 & 0x800L) != 0L)
            return jjStopAtPos(1, 75);
         break;
      case 44:
         if ((active1 & 0x10000L) != 0L)
            return jjStopAtPos(1, 80);
         break;
      case 45:
         if ((active1 & 0x2000L) != 0L)
            return jjStopAtPos(1, 77);
         break;
      case 47:
         if ((active1 & 0x1000L) != 0L)
            return jjStopAtPos(1, 76);
         break;
      case 92:
         if ((active1 & 0x100000L) != 0L)
            return jjStopAtPos(1, 84);
         break;
      case 94:
         if ((active1 & 0x8000L) != 0L)
            return jjStopAtPos(1, 79);
         break;
      case 95:
         if ((active1 & 0x4000L) != 0L)
            return jjStopAtPos(1, 78);
         break;
      case 123:
         return jjMoveStringLiteralDfa2_2(active1, 0x100L);
      default :
         break;
   }
   return jjStartNfa_2(0, 0L, active1);
}
private int jjMoveStringLiteralDfa2_2(long old1, long active1)
{
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_2(0, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(1, 0L, active1);
      return 2;
   }
   switch(curChar)
   {
      case 123:
         if ((active1 & 0x100L) != 0L)
            return jjStopAtPos(2, 72);
         break;
      default :
         break;
   }
   return jjStartNfa_2(1, 0L, active1);
}
private int jjMoveNfa_2(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 242;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 1:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                  {
                     if (kind > 89)
                        kind = 89;
                     jjCheckNAddTwoStates(119, 120);
                  }
                  else if ((0xfc00fffe00000000L & l) != 0L)
                  {
                     if (kind > 90)
                        kind = 90;
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 88)
                        kind = 88;
                     jjCheckNAddTwoStates(239, 240);
                  }
                  else if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 86)
                        kind = 86;
                     jjCheckNAddStates(381, 386);
                  }
                  if (curChar == 13)
                     jjAddStates(387, 388);
                  else if (curChar == 40)
                     jjCheckNAddStates(389, 391);
                  else if (curChar == 33)
                     jjAddStates(392, 393);
                  else if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 117;
                  break;
               case 242:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(394, 398);
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(399, 403);
                  break;
               case 0:
                  if (curChar == 61 && kind > 10)
                     kind = 10;
                  break;
               case 4:
                  if (curChar == 58)
                     jjCheckNAddStates(404, 407);
                  break;
               case 6:
               case 7:
                  jjCheckNAddStates(404, 407);
                  break;
               case 20:
               case 21:
                  jjCheckNAddStates(408, 412);
                  break;
               case 27:
                  if (curChar != 58)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 28:
                  if ((0xfffffffeffffd9ffL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 30:
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 31:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 32:
                  if ((0xfc00fffe00000000L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 38:
                  if (curChar != 58)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 39:
                  if ((0xfffffffeffffd9ffL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 41:
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 42:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 43:
                  if ((0xfc00fffe00000000L & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 50:
                  if (curChar == 58)
                     jjAddStates(413, 415);
                  break;
               case 51:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(416, 419);
                  break;
               case 52:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(420, 424);
                  break;
               case 53:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 54;
                  break;
               case 54:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 55;
                  break;
               case 55:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(420, 424);
                  break;
               case 56:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(425, 429);
                  break;
               case 57:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(425, 429);
                  break;
               case 58:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 59;
                  break;
               case 59:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 60;
                  break;
               case 60:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(425, 429);
                  break;
               case 61:
                  if (curChar != 63)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(430, 432);
                  break;
               case 62:
                  if ((0xafffefd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(430, 432);
                  break;
               case 63:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 64;
                  break;
               case 64:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 65;
                  break;
               case 65:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(430, 432);
                  break;
               case 66:
                  if (curChar != 35)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(67, 68);
                  break;
               case 67:
                  if ((0xafffefd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(67, 68);
                  break;
               case 68:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 69;
                  break;
               case 69:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 70:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(67, 68);
                  break;
               case 71:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 72;
                  break;
               case 72:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 73:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(74, 77);
                  break;
               case 74:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 75;
                  break;
               case 75:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 76;
                  break;
               case 76:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(433, 437);
                  break;
               case 77:
                  if ((0x2bff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(433, 437);
                  break;
               case 78:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(438, 442);
                  break;
               case 79:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(438, 442);
                  break;
               case 80:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 81;
                  break;
               case 81:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 82:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(438, 442);
                  break;
               case 83:
                  if ((0x2bff6fd200000000L & l) != 0L)
                     jjCheckNAddTwoStates(74, 77);
                  break;
               case 91:
                  if ((0x3ff680000000000L & l) != 0L)
                     jjCheckNAddStates(443, 445);
                  break;
               case 92:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 93;
                  break;
               case 94:
                  if ((0x3ff680000000000L & l) != 0L)
                     jjCheckNAddStates(446, 448);
                  break;
               case 95:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(449, 456);
                  break;
               case 96:
                  if ((0x2fff6fd200000000L & l) != 0L)
                     jjCheckNAddStates(457, 459);
                  break;
               case 97:
                  if (curChar == 37)
                     jjCheckNAdd(98);
                  break;
               case 98:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 99;
                  break;
               case 99:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(457, 459);
                  break;
               case 101:
                  if (curChar == 37)
                     jjCheckNAdd(102);
                  break;
               case 102:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 103;
                  break;
               case 103:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(460, 465);
                  break;
               case 104:
                  if ((0x2bff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(460, 465);
                  break;
               case 105:
                  if (curChar == 58)
                     jjCheckNAdd(106);
                  break;
               case 106:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(466, 469);
                  break;
               case 107:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(470, 474);
                  break;
               case 108:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(470, 474);
                  break;
               case 109:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 110;
                  break;
               case 110:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 111;
                  break;
               case 111:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(470, 474);
                  break;
               case 112:
                  if (curChar == 37)
                     jjCheckNAddTwoStates(98, 102);
                  break;
               case 113:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 95;
                  break;
               case 114:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 113;
                  break;
               case 115:
                  if (curChar != 41)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjCheckNAdd(116);
                  break;
               case 116:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjCheckNAdd(116);
                  break;
               case 117:
                  if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 115;
                  break;
               case 118:
                  if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 117;
                  break;
               case 119:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(119, 120);
                  break;
               case 121:
                  if ((0xfc00fffe00000000L & l) != 0L && kind > 90)
                     kind = 90;
                  break;
               case 122:
                  if (curChar == 33)
                     jjAddStates(392, 393);
                  break;
               case 123:
                  if (curChar == 33 && kind > 11)
                     kind = 11;
                  break;
               case 124:
                  if (curChar == 40)
                     jjCheckNAddStates(389, 391);
                  break;
               case 125:
                  if (curChar == 37)
                     jjCheckNAddStates(475, 480);
                  break;
               case 127:
                  jjCheckNAddStates(475, 480);
                  break;
               case 128:
                  if ((0xffffff5bffffffffL & l) != 0L)
                     jjCheckNAddStates(475, 480);
                  break;
               case 129:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 130;
                  break;
               case 130:
                  if ((0xfffffd7bffffffffL & l) != 0L)
                     jjCheckNAddStates(475, 480);
                  break;
               case 131:
                  if (curChar == 34)
                     jjCheckNAddStates(171, 173);
                  break;
               case 133:
                  jjCheckNAddStates(171, 173);
                  break;
               case 134:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(171, 173);
                  break;
               case 135:
                  if (curChar == 34)
                     jjCheckNAddStates(475, 480);
                  break;
               case 136:
                  if (curChar == 39)
                     jjCheckNAddStates(481, 483);
                  break;
               case 138:
                  jjCheckNAddStates(481, 483);
                  break;
               case 139:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(481, 483);
                  break;
               case 140:
                  if (curChar == 39)
                     jjCheckNAddStates(475, 480);
                  break;
               case 141:
                  if (curChar == 37)
                     jjAddStates(484, 485);
                  break;
               case 143:
                  if (curChar == 41)
                     jjCheckNAddStates(486, 489);
                  break;
               case 144:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(486, 489);
                  break;
               case 145:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(146, 149);
                  break;
               case 146:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(146, 149);
                  break;
               case 147:
                  if (curChar == 40 && kind > 68)
                     kind = 68;
                  break;
               case 148:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 147;
                  break;
               case 149:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 148;
                  break;
               case 150:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 145;
                  break;
               case 151:
                  if ((0x2400L & l) != 0L)
                     jjCheckNAddTwoStates(146, 149);
                  break;
               case 152:
                  if (curChar == 37)
                     jjCheckNAddStates(490, 495);
                  break;
               case 154:
                  jjCheckNAddStates(490, 495);
                  break;
               case 155:
                  if ((0xffffff5bffffffffL & l) != 0L)
                     jjCheckNAddStates(490, 495);
                  break;
               case 156:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 157;
                  break;
               case 157:
                  if ((0xfffffd7bffffffffL & l) != 0L)
                     jjCheckNAddStates(490, 495);
                  break;
               case 158:
                  if (curChar == 34)
                     jjCheckNAddStates(189, 191);
                  break;
               case 160:
                  jjCheckNAddStates(189, 191);
                  break;
               case 161:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(189, 191);
                  break;
               case 162:
                  if (curChar == 34)
                     jjCheckNAddStates(490, 495);
                  break;
               case 163:
                  if (curChar == 39)
                     jjCheckNAddStates(496, 498);
                  break;
               case 165:
                  jjCheckNAddStates(496, 498);
                  break;
               case 166:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(496, 498);
                  break;
               case 167:
                  if (curChar == 39)
                     jjCheckNAddStates(490, 495);
                  break;
               case 168:
                  if (curChar == 37)
                     jjAddStates(499, 500);
                  break;
               case 170:
                  if (curChar == 41 && kind > 69)
                     kind = 69;
                  break;
               case 171:
                  if (curChar != 40)
                     break;
                  if (kind > 70)
                     kind = 70;
                  jjCheckNAdd(172);
                  break;
               case 172:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 70)
                     kind = 70;
                  jjCheckNAdd(172);
                  break;
               case 173:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 171;
                  break;
               case 174:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 86)
                     kind = 86;
                  jjCheckNAddStates(381, 386);
                  break;
               case 175:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(175, 176);
                  break;
               case 176:
                  if (curChar == 40)
                     jjCheckNAdd(173);
                  break;
               case 177:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 86)
                     kind = 86;
                  jjCheckNAddTwoStates(177, 178);
                  break;
               case 179:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(179, 118);
                  break;
               case 182:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(399, 403);
                  break;
               case 183:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(184);
                  break;
               case 184:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(501, 505);
                  break;
               case 185:
                  if ((0x100002600L & l) != 0L)
                     jjCheckNAddStates(506, 512);
                  break;
               case 186:
                  if (curChar == 34)
                     jjCheckNAddStates(209, 211);
                  break;
               case 188:
                  jjCheckNAddStates(209, 211);
                  break;
               case 189:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(209, 211);
                  break;
               case 190:
                  if (curChar == 34)
                     jjCheckNAddStates(506, 512);
                  break;
               case 191:
                  if (curChar == 39)
                     jjCheckNAddStates(513, 515);
                  break;
               case 193:
                  jjCheckNAddStates(513, 515);
                  break;
               case 194:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(513, 515);
                  break;
               case 195:
                  if (curChar == 39)
                     jjCheckNAddStates(506, 512);
                  break;
               case 197:
               case 200:
                  jjCheckNAddStates(506, 512);
                  break;
               case 198:
                  if ((0xffffff7bffffffffL & l) != 0L)
                     jjCheckNAddStates(506, 512);
                  break;
               case 205:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 204;
                  break;
               case 206:
                  if (curChar == 10)
                     jjCheckNAddStates(506, 512);
                  break;
               case 207:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 206;
                  break;
               case 209:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(394, 398);
                  break;
               case 210:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(211);
                  break;
               case 211:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(516, 520);
                  break;
               case 212:
                  if ((0x100002600L & l) != 0L)
                     jjCheckNAddStates(521, 526);
                  break;
               case 213:
                  if (curChar == 34)
                     jjCheckNAddStates(226, 228);
                  break;
               case 215:
                  jjCheckNAddStates(226, 228);
                  break;
               case 216:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(226, 228);
                  break;
               case 217:
                  if (curChar == 34)
                     jjCheckNAddStates(521, 526);
                  break;
               case 218:
                  if (curChar == 39)
                     jjCheckNAddStates(527, 529);
                  break;
               case 220:
                  jjCheckNAddStates(527, 529);
                  break;
               case 221:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(527, 529);
                  break;
               case 222:
                  if (curChar == 39)
                     jjCheckNAddStates(521, 526);
                  break;
               case 224:
               case 227:
                  jjCheckNAddStates(521, 526);
                  break;
               case 225:
                  if ((0xffffff7bffffffffL & l) != 0L)
                     jjCheckNAddStates(521, 526);
                  break;
               case 231:
                  if (curChar == 10)
                     jjCheckNAddStates(521, 526);
                  break;
               case 232:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 231;
                  break;
               case 235:
                  if (curChar == 13)
                     jjAddStates(387, 388);
                  break;
               case 236:
                  if (curChar == 10 && kind > 88)
                     kind = 88;
                  break;
               case 237:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(239, 240);
                  break;
               case 238:
                  if (curChar == 10 && kind > 91)
                     kind = 91;
                  break;
               case 239:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 238;
                  break;
               case 240:
                  if ((0x2400L & l) != 0L && kind > 91)
                     kind = 91;
                  break;
               case 241:
                  if ((0x2400L & l) == 0L)
                     break;
                  if (kind > 88)
                     kind = 88;
                  jjCheckNAddTwoStates(239, 240);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 181:
                  if (curChar == 123)
                     jjCheckNAdd(209);
                  if (curChar == 123)
                     jjCheckNAdd(182);
                  break;
               case 1:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                  {
                     if (kind > 89)
                        kind = 89;
                     jjCheckNAddTwoStates(119, 120);
                  }
                  else if ((0x78000001f8000001L & l) != 0L)
                  {
                     if (kind > 90)
                        kind = 90;
                  }
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(443, 445);
                  else if (curChar == 126)
                     jjCheckNAddStates(530, 532);
                  else if (curChar == 123)
                     jjAddStates(533, 534);
                  else if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 3;
                  else if (curChar == 124)
                  {
                     if (kind > 11)
                        kind = 11;
                  }
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 88;
                  else if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 48;
                  else if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 36;
                  else if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 0;
                  break;
               case 242:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(394, 398);
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(399, 403);
                  break;
               case 2:
                  if (curChar == 124 && kind > 11)
                     kind = 11;
                  break;
               case 3:
                  if (curChar == 91)
                     jjCheckNAddStates(408, 412);
                  break;
               case 5:
               case 10:
                  if (curChar == 126)
                     jjCheckNAdd(6);
                  break;
               case 6:
                  jjCheckNAddStates(404, 407);
                  break;
               case 7:
                  if ((0xbfffffffdfffffffL & l) != 0L)
                     jjCheckNAddStates(404, 407);
                  break;
               case 8:
                  if (curChar == 93)
                     jjCheckNAdd(7);
                  break;
               case 9:
                  if (curChar == 93)
                     jjAddStates(535, 536);
                  break;
               case 11:
                  if (curChar == 93)
                     jjCheckNAddStates(408, 412);
                  break;
               case 12:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 13:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 14:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 15:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 16:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 15;
                  break;
               case 17:
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 18:
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 17;
                  break;
               case 19:
               case 24:
                  if (curChar == 126)
                     jjCheckNAdd(20);
                  break;
               case 20:
                  jjCheckNAddStates(408, 412);
                  break;
               case 21:
                  if ((0xbfffffffdfffffffL & l) != 0L)
                     jjCheckNAddStates(408, 412);
                  break;
               case 22:
                  if (curChar == 93)
                     jjCheckNAdd(21);
                  break;
               case 23:
                  if (curChar == 93)
                     jjAddStates(537, 538);
                  break;
               case 25:
                  if (curChar == 93 && kind > 71)
                     kind = 71;
                  break;
               case 26:
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 3;
                  break;
               case 28:
               case 30:
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 29:
                  if (curChar == 126)
                     jjAddStates(539, 541);
                  break;
               case 31:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 32:
                  if ((0x78000001f8000001L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 33:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 27;
                  break;
               case 34:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 35:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 34;
                  break;
               case 36:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 35;
                  break;
               case 37:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 36;
                  break;
               case 39:
               case 41:
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 40:
                  if (curChar == 126)
                     jjAddStates(542, 544);
                  break;
               case 42:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 43:
                  if ((0x78000001f8000001L & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 44:
                  if (curChar == 104)
                     jjstateSet[jjnewStateCnt++] = 38;
                  break;
               case 45:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 44;
                  break;
               case 46:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 45;
                  break;
               case 47:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 46;
                  break;
               case 48:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 47;
                  break;
               case 49:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 48;
                  break;
               case 52:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(420, 424);
                  break;
               case 54:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 55;
                  break;
               case 55:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(420, 424);
                  break;
               case 57:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(425, 429);
                  break;
               case 59:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 60;
                  break;
               case 60:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(425, 429);
                  break;
               case 62:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(430, 432);
                  break;
               case 64:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 65;
                  break;
               case 65:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(430, 432);
                  break;
               case 67:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(67, 68);
                  break;
               case 69:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 70:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(67, 68);
                  break;
               case 72:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 73:
                  if ((0x7e0000007eL & l) != 0L)
                     jjCheckNAddTwoStates(74, 77);
                  break;
               case 75:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 76;
                  break;
               case 76:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(433, 437);
                  break;
               case 77:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(433, 437);
                  break;
               case 79:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(438, 442);
                  break;
               case 81:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 82:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(438, 442);
                  break;
               case 83:
                  if ((0x47fffffe87fffffeL & l) != 0L)
                     jjCheckNAddTwoStates(74, 77);
                  break;
               case 84:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 50;
                  break;
               case 85:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 84;
                  break;
               case 86:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 85;
                  break;
               case 87:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 86;
                  break;
               case 88:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 87;
                  break;
               case 89:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 88;
                  break;
               case 90:
               case 91:
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(443, 445);
                  break;
               case 93:
               case 94:
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(446, 448);
                  break;
               case 96:
                  if ((0x47fffffe87fffffeL & l) != 0L)
                     jjCheckNAddStates(457, 459);
                  break;
               case 98:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 99;
                  break;
               case 99:
                  if ((0x7e0000007eL & l) != 0L)
                     jjCheckNAddStates(457, 459);
                  break;
               case 100:
                  if (curChar != 64)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(460, 465);
                  break;
               case 102:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 103;
                  break;
               case 103:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(460, 465);
                  break;
               case 104:
                  if ((0x47fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(460, 465);
                  break;
               case 108:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(470, 474);
                  break;
               case 110:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 111;
                  break;
               case 111:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(470, 474);
                  break;
               case 119:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(119, 120);
                  break;
               case 120:
                  if (curChar == 126)
                     jjCheckNAdd(119);
                  break;
               case 121:
                  if ((0x78000001f8000001L & l) != 0L && kind > 90)
                     kind = 90;
                  break;
               case 126:
               case 142:
                  if (curChar == 126)
                     jjCheckNAdd(127);
                  break;
               case 127:
                  jjCheckNAddStates(475, 480);
                  break;
               case 128:
               case 130:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(475, 480);
                  break;
               case 132:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 133;
                  break;
               case 133:
                  jjCheckNAddStates(171, 173);
                  break;
               case 134:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(171, 173);
                  break;
               case 137:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 138;
                  break;
               case 138:
                  jjCheckNAddStates(481, 483);
                  break;
               case 139:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(481, 483);
                  break;
               case 153:
               case 169:
                  if (curChar == 126)
                     jjCheckNAdd(154);
                  break;
               case 154:
                  jjCheckNAddStates(490, 495);
                  break;
               case 155:
               case 157:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(490, 495);
                  break;
               case 159:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 160;
                  break;
               case 160:
                  jjCheckNAddStates(189, 191);
                  break;
               case 161:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(189, 191);
                  break;
               case 164:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 165;
                  break;
               case 165:
                  jjCheckNAddStates(496, 498);
                  break;
               case 166:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(496, 498);
                  break;
               case 178:
                  if (curChar == 126)
                     jjCheckNAdd(177);
                  break;
               case 180:
                  if (curChar == 123)
                     jjAddStates(533, 534);
                  break;
               case 182:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(399, 403);
                  break;
               case 183:
                  if (curChar == 95)
                     jjCheckNAdd(184);
                  break;
               case 184:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(501, 505);
                  break;
               case 187:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 188;
                  break;
               case 188:
                  jjCheckNAddStates(209, 211);
                  break;
               case 189:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(209, 211);
                  break;
               case 192:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 193;
                  break;
               case 193:
                  jjCheckNAddStates(513, 515);
                  break;
               case 194:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(513, 515);
                  break;
               case 196:
               case 201:
                  if (curChar == 126)
                     jjCheckNAdd(197);
                  break;
               case 197:
                  jjCheckNAddStates(506, 512);
                  break;
               case 198:
               case 200:
                  if ((0x9fffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(506, 512);
                  break;
               case 199:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 200;
                  break;
               case 202:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 201;
                  break;
               case 203:
                  if (curChar == 125 && kind > 73)
                     kind = 73;
                  break;
               case 204:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 203;
                  break;
               case 208:
                  if (curChar == 123)
                     jjCheckNAdd(209);
                  break;
               case 209:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(394, 398);
                  break;
               case 210:
                  if (curChar == 95)
                     jjCheckNAdd(211);
                  break;
               case 211:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(516, 520);
                  break;
               case 214:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 215;
                  break;
               case 215:
                  jjCheckNAddStates(226, 228);
                  break;
               case 216:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(226, 228);
                  break;
               case 219:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 220;
                  break;
               case 220:
                  jjCheckNAddStates(527, 529);
                  break;
               case 221:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(527, 529);
                  break;
               case 223:
               case 229:
                  if (curChar == 126)
                     jjCheckNAdd(224);
                  break;
               case 224:
                  jjCheckNAddStates(521, 526);
                  break;
               case 225:
               case 227:
                  if ((0x9fffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(521, 526);
                  break;
               case 226:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 227;
                  break;
               case 228:
                  if (curChar == 125)
                     jjCheckNAddTwoStates(229, 230);
                  break;
               case 230:
                  if (curChar == 125 && kind > 74)
                     kind = 74;
                  break;
               case 233:
                  if (curChar == 125)
                     jjCheckNAdd(230);
                  break;
               case 234:
                  if (curChar == 126)
                     jjCheckNAddStates(530, 532);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 1:
               case 119:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(119, 120);
                  break;
               case 242:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(399, 403);
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(394, 398);
                  break;
               case 6:
               case 7:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(404, 407);
                  break;
               case 20:
               case 21:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(408, 412);
                  break;
               case 28:
               case 30:
               case 31:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 39:
               case 41:
               case 42:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 127:
               case 128:
               case 130:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(475, 480);
                  break;
               case 133:
               case 134:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(171, 173);
                  break;
               case 138:
               case 139:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(481, 483);
                  break;
               case 154:
               case 155:
               case 157:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(490, 495);
                  break;
               case 160:
               case 161:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(189, 191);
                  break;
               case 165:
               case 166:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(496, 498);
                  break;
               case 182:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(399, 403);
                  break;
               case 184:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(501, 505);
                  break;
               case 188:
               case 189:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(209, 211);
                  break;
               case 193:
               case 194:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(513, 515);
                  break;
               case 197:
               case 198:
               case 200:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(506, 512);
                  break;
               case 209:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(394, 398);
                  break;
               case 211:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(516, 520);
                  break;
               case 215:
               case 216:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(226, 228);
                  break;
               case 220:
               case 221:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(527, 529);
                  break;
               case 224:
               case 225:
               case 227:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(521, 526);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 242 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
static final int[] jjnextStates = {
   23, 0, 24, 2, 5, 8, 26, 46, 68, 13, 21, 2, 3, 4, 24, 2, 
   5, 8, 27, 29, 30, 32, 37, 42, 33, 35, 36, 38, 40, 41, 43, 44, 
   45, 14, 15, 20, 47, 49, 50, 52, 57, 62, 53, 55, 56, 58, 60, 61, 
   63, 64, 66, 67, 69, 71, 72, 74, 79, 84, 75, 77, 78, 80, 82, 83, 
   85, 86, 87, 93, 94, 92, 204, 205, 207, 227, 228, 177, 178, 180, 202, 200, 
   170, 171, 172, 173, 174, 115, 231, 232, 120, 147, 168, 2, 4, 5, 6, 15, 
   16, 18, 19, 20, 48, 68, 80, 49, 50, 58, 63, 49, 50, 53, 58, 63, 
   53, 54, 55, 58, 63, 59, 60, 63, 71, 74, 75, 58, 63, 75, 76, 77, 
   58, 63, 88, 89, 111, 89, 91, 111, 93, 97, 101, 102, 104, 58, 63, 109, 
   94, 93, 97, 98, 101, 102, 104, 58, 63, 103, 104, 58, 63, 104, 105, 106, 
   58, 63, 121, 123, 124, 126, 131, 136, 127, 129, 130, 132, 134, 135, 137, 138, 
   139, 145, 146, 144, 148, 150, 151, 153, 158, 163, 154, 156, 157, 159, 161, 162, 
   164, 165, 178, 179, 180, 202, 200, 181, 186, 191, 193, 194, 197, 200, 182, 184, 
   185, 187, 189, 190, 205, 206, 207, 227, 228, 208, 213, 218, 220, 221, 223, 209, 
   211, 212, 214, 216, 217, 172, 116, 118, 176, 203, 7, 8, 21, 22, 27, 28, 
   29, 38, 39, 40, 8, 9, 11, 31, 32, 9, 10, 11, 31, 32, 12, 17, 
   22, 24, 25, 27, 13, 15, 16, 18, 20, 21, 34, 35, 37, 39, 35, 36, 
   37, 39, 7, 40, 4, 5, 138, 139, 144, 145, 120, 121, 125, 126, 127, 131, 
   132, 133, 134, 115, 148, 175, 130, 137, 141, 142, 121, 123, 124, 126, 223, 224, 
   226, 246, 247, 196, 197, 199, 221, 219, 121, 123, 124, 149, 151, 152, 154, 159, 
   164, 155, 157, 158, 160, 162, 163, 165, 166, 167, 173, 174, 172, 176, 178, 179, 
   181, 186, 191, 192, 193, 197, 198, 199, 221, 219, 200, 205, 210, 212, 213, 216, 
   219, 201, 203, 204, 206, 208, 209, 224, 225, 226, 246, 247, 227, 232, 237, 239, 
   240, 242, 228, 230, 231, 233, 235, 236, 132, 116, 118, 195, 222, 175, 176, 177, 
   178, 179, 118, 236, 237, 125, 152, 173, 0, 123, 209, 210, 212, 232, 233, 182, 
   183, 185, 207, 205, 5, 7, 8, 9, 18, 19, 21, 22, 23, 51, 71, 83, 
   52, 53, 61, 66, 52, 53, 56, 61, 66, 56, 57, 58, 61, 66, 62, 63, 
   66, 74, 77, 78, 61, 66, 78, 79, 80, 61, 66, 91, 92, 114, 92, 94, 
   114, 96, 100, 104, 105, 107, 61, 66, 112, 97, 96, 100, 101, 104, 105, 107, 
   61, 66, 106, 107, 61, 66, 107, 108, 109, 61, 66, 126, 128, 129, 131, 136, 
   141, 137, 139, 140, 142, 143, 144, 150, 151, 149, 153, 155, 156, 158, 163, 168, 
   164, 166, 167, 169, 170, 183, 184, 185, 207, 205, 186, 191, 196, 198, 199, 202, 
   205, 192, 194, 195, 210, 211, 212, 232, 233, 213, 218, 223, 225, 226, 228, 219, 
   221, 222, 177, 119, 121, 181, 208, 10, 11, 24, 25, 30, 31, 32, 41, 42, 
   43, 
};
private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec2[i2] & l2) != 0L);
      default :
         if ((jjbitVec0[i1] & l1) != 0L)
            return true;
         return false;
   }
}

/** Token literal values. */
public static final String[] jjstrLiteralImages = {
"", null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, "\173\173\173", null, null, "\52\52", "\57\57", "\55\55", 
"\137\137", "\136\136", "\54\54", "\43\43", null, null, "\134\134", null, null, null, null, 
null, null, null, null, null, };

/** Lexer state names. */
public static final String[] lexStateNames = {
   "DEFAULT",
   "BEGINNING_OF_LINE",
   "TABLE_CONTEXT",
   "HEADER_CONTEXT",
   "VERBATIM_CONTEXT",
   "MACRO_CONTEXT",
   "INLINE",
};

/** Lex State array. */
public static final int[] jjnewLexState = {
   -1, 1, -1, 6, 6, -1, -1, -1, 6, -1, -1, -1, 1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, 4, -1, 5, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, 1, 1, 1, 
};
static final long[] jjtoToken = {
   0x1ffdfdL, 0x3ffffff0L, 
};
static final long[] jjtoSkip = {
   0x202L, 0x0L, 
};
protected SimpleCharStream input_stream;
private final int[] jjrounds = new int[249];
private final int[] jjstateSet = new int[498];
private final StringBuilder jjimage = new StringBuilder();
private StringBuilder image = jjimage;
private int jjimageLen;
private int lengthOfMatch;
protected char curChar;
/** Constructor. */
public XWikiScannerTokenManager(SimpleCharStream stream){
   if (SimpleCharStream.staticFlag)
      throw new Error("ERROR: Cannot use a static CharStream class with a non-static lexical analyzer.");
   input_stream = stream;
}

/** Constructor. */
public XWikiScannerTokenManager(SimpleCharStream stream, int lexState){
   this(stream);
   SwitchTo(lexState);
}

/** Reinitialise parser. */
public void ReInit(SimpleCharStream stream)
{
   jjmatchedPos = jjnewStateCnt = 0;
   curLexState = defaultLexState;
   input_stream = stream;
   ReInitRounds();
}
private void ReInitRounds()
{
   int i;
   jjround = 0x80000001;
   for (i = 249; i-- > 0;)
      jjrounds[i] = 0x80000000;
}

/** Reinitialise parser. */
public void ReInit(SimpleCharStream stream, int lexState)
{
   ReInit(stream);
   SwitchTo(lexState);
}

/** Switch to specified lex state. */
public void SwitchTo(int lexState)
{
   if (lexState >= 7 || lexState < 0)
      throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrError.INVALID_LEXICAL_STATE);
   else
      curLexState = lexState;
}

protected Token jjFillToken()
{
   final Token t;
   final String curTokenImage;
   final int beginLine;
   final int endLine;
   final int beginColumn;
   final int endColumn;
   if (jjmatchedPos < 0)
   {
      if (image == null)
         curTokenImage = "";
      else
         curTokenImage = image.toString();
      beginLine = endLine = input_stream.getBeginLine();
      beginColumn = endColumn = input_stream.getBeginColumn();
   }
   else
   {
      String im = jjstrLiteralImages[jjmatchedKind];
      curTokenImage = (im == null) ? input_stream.GetImage() : im;
      beginLine = input_stream.getBeginLine();
      beginColumn = input_stream.getBeginColumn();
      endLine = input_stream.getEndLine();
      endColumn = input_stream.getEndColumn();
   }
   t = Token.newToken(jjmatchedKind, curTokenImage);

   t.beginLine = beginLine;
   t.endLine = endLine;
   t.beginColumn = beginColumn;
   t.endColumn = endColumn;

   return t;
}

int curLexState = 0;
int defaultLexState = 0;
int jjnewStateCnt;
int jjround;
int jjmatchedPos;
int jjmatchedKind;

/** Get the next Token. */
public Token getNextToken() 
{
  Token matchedToken;
  int curPos = 0;

  EOFLoop :
  for (;;)
  {
   try
   {
      curChar = input_stream.BeginToken();
   }
   catch(java.io.IOException e)
   {
      jjmatchedKind = 0;
      matchedToken = jjFillToken();
      return matchedToken;
   }
   image = jjimage;
   image.setLength(0);
   jjimageLen = 0;

   switch(curLexState)
   {
     case 0:
       jjmatchedKind = 1;
       jjmatchedPos = -1;
       curPos = 0;
       curPos = jjMoveStringLiteralDfa0_0();
       break;
     case 1:
       jjmatchedKind = 9;
       jjmatchedPos = -1;
       curPos = 0;
       curPos = jjMoveStringLiteralDfa0_1();
       break;
     case 2:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_2();
       break;
     case 3:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_3();
       break;
     case 4:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_4();
       break;
     case 5:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_5();
       break;
     case 6:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_6();
       break;
   }
     if (jjmatchedKind != 0x7fffffff)
     {
        if (jjmatchedPos + 1 < curPos)
           input_stream.backup(curPos - jjmatchedPos - 1);
        if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
           matchedToken = jjFillToken();
           TokenLexicalActions(matchedToken);
       if (jjnewLexState[jjmatchedKind] != -1)
         curLexState = jjnewLexState[jjmatchedKind];
           return matchedToken;
        }
        else
        {
           SkipLexicalActions(null);
         if (jjnewLexState[jjmatchedKind] != -1)
           curLexState = jjnewLexState[jjmatchedKind];
           continue EOFLoop;
        }
     }
     int error_line = input_stream.getEndLine();
     int error_column = input_stream.getEndColumn();
     String error_after = null;
     boolean EOFSeen = false;
     try { input_stream.readChar(); input_stream.backup(1); }
     catch (java.io.IOException e1) {
        EOFSeen = true;
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
        if (curChar == '\n' || curChar == '\r') {
           error_line++;
           error_column = 0;
        }
        else
           error_column++;
     }
     if (!EOFSeen) {
        input_stream.backup(1);
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
     }
     throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);
  }
}

int[] jjemptyLineNo = new int[7];
int[] jjemptyColNo = new int[7];
boolean[] jjbeenHere = new boolean[7];
void SkipLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 1 :
         if (jjmatchedPos == -1)
         {
            if (jjbeenHere[0] &&
                jjemptyLineNo[0] == input_stream.getBeginLine() &&
                jjemptyColNo[0] == input_stream.getBeginColumn())
               throw new TokenMgrError(("Error: Bailing out of infinite loop caused by repeated empty string matches at line " + input_stream.getBeginLine() + ", column " + input_stream.getBeginColumn() + "."), TokenMgrError.LOOP_DETECTED);
            jjemptyLineNo[0] = input_stream.getBeginLine();
            jjemptyColNo[0] = input_stream.getBeginColumn();
            jjbeenHere[0] = true;
         }
         break;
      case 9 :
         if (jjmatchedPos == -1)
         {
            if (jjbeenHere[1] &&
                jjemptyLineNo[1] == input_stream.getBeginLine() &&
                jjemptyColNo[1] == input_stream.getBeginColumn())
               throw new TokenMgrError(("Error: Bailing out of infinite loop caused by repeated empty string matches at line " + input_stream.getBeginLine() + ", column " + input_stream.getBeginColumn() + "."), TokenMgrError.LOOP_DETECTED);
            jjemptyLineNo[1] = input_stream.getBeginLine();
            jjemptyColNo[1] = input_stream.getBeginColumn();
            jjbeenHere[1] = true;
         }
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        returnFromBeginningOfLine();
         break;
      default :
         break;
   }
}
void TokenLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 0 :
         break;
      case 2 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                enterBlockState(HEADER_CONTEXT);
         break;
      case 3 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                                                                                    clearBlockState();
         break;
      case 4 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                 clearBlockState();
         break;
      case 5 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                             input_stream.backup(image.length()); enterBlockState(TABLE_CONTEXT);
         break;
      case 6 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                               clearBlockState();
         break;
      case 7 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                          matchedToken.kind = NL;
         break;
      case 8 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                   clearBlockState();
         break;
      case 12 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                    clearBlockState();
         break;
      case 13 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
          clearBlockState();
          matchedToken.kind = HEADER_END;
         break;
      case 14 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                              matchedToken.kind = HEADER_BEGIN;
         break;
      case 15 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
          if (image.length() == 3) {
              verbatimBlockDepth++;
          }
          matchedToken.kind = VERBATIM_CONTENT;
         break;
      case 16 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
          if (image.length() < 3) {
              matchedToken.kind = VERBATIM_CONTENT;
          } else {
              verbatimBlockDepth--;
              if (verbatimBlockDepth == 0)  {
                  returnFromSpecialState();
              } else {
                  matchedToken.kind = VERBATIM_CONTENT;
              }
          }
         break;
      case 18 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        {
            String name = getMacroName(image);
            if (name.equals(macroName)) {
                macroDepth++;
            }
            matchedToken.kind = MACRO_CONTENT;
        }
         break;
      case 19 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        {
            String name = getMacroName(image);
            if (name.equals(macroName)) {
                macroDepth--;
                if (macroDepth == 0) {
                    returnFromSpecialState();
                } else {
                     matchedToken.kind = MACRO_CONTENT;
                }
            } else {
                matchedToken.kind = MACRO_CONTENT;
            }
        }
         break;
      case 68 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                                              input_stream.backup("(((".length());
         break;
      case 70 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                  pushControlState();
         break;
      case 72 :
        image.append(jjstrLiteralImages[72]);
        lengthOfMatch = jjstrLiteralImages[72].length();
                                 verbatimBlockDepth++;
         break;
      case 74 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                                                         initMacro(image);
         break;
      case 87 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
       if (inEmbeddedDocument()) {
          popControlState();
       } else {
          /*
           * We must put back the spaces on the input stream.
           */
          String s = image.toString();
          int offset = s.indexOf(")))");
          if (offset > 0) {
             input_stream.backup(s.length() - offset);
             matchedToken.image = s.substring(0, offset);
             matchedToken.kind = XWIKI_SPACE;
          } else if (s.length() > ")))".length()) {
             matchedToken.image = s.substring(0, ")))".length());
             input_stream.backup(s.length() - ")))".length());
             matchedToken.kind = XWIKI_SPECIAL_SYMBOL;
          } else {
             matchedToken.kind = XWIKI_SPECIAL_SYMBOL;
          }
       }
         break;
      case 91 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                             clearBlockState();
         break;
      case 92 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                              clearBlockState();
         break;
      default :
         break;
   }
}
private void jjCheckNAdd(int state)
{
   if (jjrounds[state] != jjround)
   {
      jjstateSet[jjnewStateCnt++] = state;
      jjrounds[state] = jjround;
   }
}
private void jjAddStates(int start, int end)
{
   do {
      jjstateSet[jjnewStateCnt++] = jjnextStates[start];
   } while (start++ != end);
}
private void jjCheckNAddTwoStates(int state1, int state2)
{
   jjCheckNAdd(state1);
   jjCheckNAdd(state2);
}

private void jjCheckNAddStates(int start, int end)
{
   do {
      jjCheckNAdd(jjnextStates[start]);
   } while (start++ != end);
}

}
