/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.wikimodel;

/**
 * Common execption for wiki parsers.
 *
 * @version $Id: d35b8c0cc2452030dfd589246042ba51ad1ab759 $
 * @since 4.0M1
 */
public class WikiParserException extends Exception
{
    /**
     * The serialize version id
     */
    private static final long serialVersionUID = -4472747025921827543L;

    /**
     *
     */
    public WikiParserException()
    {
        super();
    }

    /**
     * @param message
     */
    public WikiParserException(String message)
    {
        super(message);
    }

    /**
     * @param message
     * @param cause
     */
    public WikiParserException(String message, Throwable cause)
    {
        super(message, cause);
    }

    /**
     * @param cause
     */
    public WikiParserException(Throwable cause)
    {
        super(cause);
    }
}
