/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.wikimodel.xhtml.handler;

import org.xwiki.rendering.wikimodel.xhtml.impl.TagContext;

/**
 * @version $Id: a9782f0ace3ed5db4414c3192bc550056103549e $
 * @since 4.0M1
 */
public class HeaderTagHandler extends TagHandler
{
    public HeaderTagHandler()
    {
        super(true);
    }

    @Override
    public boolean isBlockHandler(TagContext context)
    {
        return true;
    }

    @Override
    protected void begin(TagContext context)
    {
        int level = Integer.parseInt(context.getName().substring(1, 2));
        sendEmptyLines(context);
        context.getScannerContext().beginHeader(level, context.getParams());
    }

    @Override
    protected void end(TagContext context)
    {
        context.getScannerContext().endHeader();
    }
}
