/* ConfluenceWikiScanner.java */
/* Generated By:JavaCC: Do not edit this line. ConfluenceWikiScanner.java */
/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.wikimodel.internal.confluence.javacc;

import org.xwiki.rendering.wikimodel.IWikiReferenceParser;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;
import org.xwiki.rendering.wikimodel.WikiStyle;
import org.xwiki.rendering.wikimodel.confluence.ConfluenceImageWikiReferenceParser;
import org.xwiki.rendering.wikimodel.confluence.ConfluenceWikiReferenceParser;
import org.xwiki.rendering.wikimodel.confluence.ConfluenceWikiScannerContext;
import org.xwiki.rendering.wikimodel.impl.InlineState;
import org.xwiki.rendering.wikimodel.impl.WikiScannerUtil;

/**
 * This is the internal wiki page parser generated from the grammar file.
 * 
 * <p>This code was originally authored by Mikhail Kotelnikov (Cognium Systems SA) and other contributors (including
 * XWiki committers), under the ASL 2.0 license (http://www.apache.org/licenses/LICENSE-2.0).</p>
 */
public class ConfluenceWikiScanner implements ConfluenceWikiScannerConstants {

    /**
     * Indicate if {noformat} macro should be seen as a macro or a verbatim block.
     */
    private boolean fNoformatAsMacro = true;

    private ConfluenceWikiScannerContext fContext;

    private IWikiReferenceParser fReferenceParser = new ConfluenceWikiReferenceParser();

    private IWikiReferenceParser fImageReferenceParser = new ConfluenceImageWikiReferenceParser();

    public void parse(ConfluenceWikiScannerContext context) throws ParseException {
        fContext = context;
        doParse();
    }

    public void setNoformatAsMacro(boolean noformatAsMacro) {
        fNoformatAsMacro = noformatAsMacro;
    }

    private boolean isImage(WikiReference ref) {
        String str = ref.getLink().toLowerCase();
        return str.endsWith(".gif") ||
            str.endsWith(".jpg") ||
            str.endsWith(".jpeg") ||
            str.endsWith(".png");
    }

    private WikiParameters newMacroParameters(String paramStr) {
        if (paramStr == null || "".equals(paramStr.trim()))
            return WikiParameters.EMPTY;
        WikiParameters params;
        if (paramStr.indexOf("|") < 0 && paramStr.indexOf("=") < 0) {
            params = new WikiParameters("");
            params = params.addParameter("value", paramStr);
        } else {
            params = new WikiParameters(paramStr, "|");
        }
        return params;
    }

    private String[] splitMacroParams(String str) {
        str = str.trim();
        str = str.substring(1, str.length() - 1);
        String paramStr = "";
        int paramStrPos = str.indexOf(":");
        String name = "";
        if (paramStrPos > 0) {
            paramStr = str.substring(paramStrPos + 1);
            name = str.substring(0, paramStrPos);
        } else {
            name = str;
        }
        name = name.trim();
        return new String[] { name, paramStr };
    }

  final public Token getINTERNAL_MACRO() throws ParseException {Token t=null;
    t = jj_consume_token(INTERNAL_MACRO);
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getINTERNAL_MACRO_CONTENT() throws ParseException {Token t=null;
    t = jj_consume_token(INTERNAL_MACRO_CONTENT);
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getTABLE_ROW() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_TABLE_ROW:{
      t = jj_consume_token(I_TABLE_ROW);
      break;
      }
    case D_TABLE_ROW:{
      t = jj_consume_token(D_TABLE_ROW);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getTABLE_CELL() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_TABLE_CELL:{
      t = jj_consume_token(I_TABLE_CELL);
      break;
      }
    case D_TABLE_CELL:{
      t = jj_consume_token(D_TABLE_CELL);
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

// <getters>
  final public     Token getLIST_ITEM() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_LIST_ITEM:{
      t = jj_consume_token(I_LIST_ITEM);
      break;
      }
    case D_LIST_ITEM:{
      t = jj_consume_token(D_LIST_ITEM);
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getHEADER() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_HEADER:{
      t = jj_consume_token(I_HEADER);
      break;
      }
    case D_HEADER:{
      t = jj_consume_token(D_HEADER);
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getVERBATIM_BLOCK() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_VERBATIM_BLOCK:{
      t = jj_consume_token(I_VERBATIM_BLOCK);
      break;
      }
    case D_VERBATIM_BLOCK:{
      t = jj_consume_token(D_VERBATIM_BLOCK);
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getHORLINE() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_HORLINE:{
      t = jj_consume_token(I_HORLINE);
      break;
      }
    case D_HORLINE:{
      t = jj_consume_token(D_HORLINE);
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getVERBATIM_INLINE() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_VERBATIM_INLINE:{
      t = jj_consume_token(I_VERBATIM_INLINE);
      break;
      }
    case D_VERBATIM_INLINE:{
      t = jj_consume_token(D_VERBATIM_INLINE);
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getREFERENCE() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_REFERENCE:{
      t = jj_consume_token(I_REFERENCE);
      break;
      }
    case D_REFERENCE:{
      t = jj_consume_token(D_REFERENCE);
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getQUOT_BLOCK() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_QUOT_BLOCK:{
      t = jj_consume_token(I_QUOT_BLOCK);
      break;
      }
    case D_QUOT_BLOCK:{
      t = jj_consume_token(D_QUOT_BLOCK);
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getQUOT_BLOCK_MACRO() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_QUOT_BLOCK_MACRO:{
      t = jj_consume_token(I_QUOT_BLOCK_MACRO);
      break;
      }
    case D_QUOT_BLOCK_MACRO:{
      t = jj_consume_token(D_QUOT_BLOCK_MACRO);
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getBR() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_BR:{
      t = jj_consume_token(I_BR);
      break;
      }
    case D_BR:{
      t = jj_consume_token(D_BR);
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getMACRO_BLOCK_START() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_MACRO_BLOCK_START:{
      t = jj_consume_token(I_MACRO_BLOCK_START);
      break;
      }
    case D_MACRO_BLOCK_START:{
      t = jj_consume_token(D_MACRO_BLOCK_START);
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getMACRO_EMPTY_BLOCK() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_MACRO_EMPTY_BLOCK:{
      t = jj_consume_token(I_MACRO_EMPTY_BLOCK);
      break;
      }
    case D_MACRO_EMPTY_BLOCK:{
      t = jj_consume_token(D_MACRO_EMPTY_BLOCK);
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getMACRO_INLINE_START() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_MACRO_INLINE_START:{
      t = jj_consume_token(I_MACRO_INLINE_START);
      break;
      }
    case D_MACRO_INLINE_START:{
      t = jj_consume_token(D_MACRO_INLINE_START);
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getMACRO_EMPTY_INLINE() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_MACRO_EMPTY_INLINE:{
      t = jj_consume_token(I_MACRO_EMPTY_INLINE);
      break;
      }
    case D_MACRO_EMPTY_INLINE:{
      t = jj_consume_token(D_MACRO_EMPTY_INLINE);
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getESCAPED() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_ESCAPED:{
      t = jj_consume_token(I_ESCAPED);
      break;
      }
    case D_ESCAPED:{
      t = jj_consume_token(D_ESCAPED);
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getFORMAT_SYMBOL() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_FORMAT_SYMBOL:{
      t = jj_consume_token(I_FORMAT_SYMBOL);
      break;
      }
    case D_FORMAT_SYMBOL:{
      t = jj_consume_token(D_FORMAT_SYMBOL);
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getSPECIAL_SYMBOLS() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_SPECIAL_SYMBOLS:{
      t = jj_consume_token(I_SPECIAL_SYMBOLS);
      break;
      }
    case D_SPECIAL_SYMBOLS:{
      t = jj_consume_token(D_SPECIAL_SYMBOLS);
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

// "Standard" tokens. They are the same for all wikis.
  final public     Token getURI() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_URI:{
      t = jj_consume_token(I_URI);
      break;
      }
    case D_URI:{
      t = jj_consume_token(D_URI);
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getNL() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_NL:{
      t = jj_consume_token(I_NL);
      break;
      }
    case D_NL:{
      t = jj_consume_token(D_NL);
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getSPACE() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_SPACE:{
      t = jj_consume_token(I_SPACE);
      break;
      }
    case D_SPACE:{
      t = jj_consume_token(D_SPACE);
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getWORD() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_WORD:{
      t = jj_consume_token(I_WORD);
      break;
      }
    case D_WORD:{
      t = jj_consume_token(D_WORD);
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token getSPECIAL_SYMBOL() throws ParseException {Token t=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_SPECIAL_SYMBOL:{
      t = jj_consume_token(I_SPECIAL_SYMBOL);
      break;
      }
    case D_SPECIAL_SYMBOL:{
      t = jj_consume_token(D_SPECIAL_SYMBOL);
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

// </getters>
  final public 
void doParse() throws ParseException {token_source.SwitchTo(token_source.INITIAL_CONTEXT);
fContext.beginDocument();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case I_TABLE_ROW:
      case I_TABLE_CELL:
      case I_LIST_ITEM:
      case I_HEADER:
      case I_VERBATIM_BLOCK:
      case I_HORLINE:
      case I_VERBATIM_INLINE:
      case I_REFERENCE:
      case I_QUOT_BLOCK:
      case I_QUOT_BLOCK_MACRO:
      case I_BR:
      case I_MACRO_BLOCK_START:
      case I_MACRO_EMPTY_BLOCK:
      case I_MACRO_INLINE_START:
      case I_MACRO_EMPTY_INLINE:
      case I_ESCAPED:
      case I_FORMAT_SYMBOL:
      case I_SPECIAL_SYMBOLS:
      case I_URI:
      case I_NL:
      case I_SPACE:
      case I_WORD:
      case I_SPECIAL_SYMBOL:
      case D_TABLE_ROW:
      case D_TABLE_CELL:
      case D_LIST_ITEM:
      case D_HEADER:
      case D_VERBATIM_BLOCK:
      case D_HORLINE:
      case D_VERBATIM_INLINE:
      case D_REFERENCE:
      case D_QUOT_BLOCK:
      case D_QUOT_BLOCK_MACRO:
      case D_BR:
      case D_MACRO_BLOCK_START:
      case D_MACRO_EMPTY_BLOCK:
      case D_MACRO_INLINE_START:
      case D_MACRO_EMPTY_INLINE:
      case D_ESCAPED:
      case D_FORMAT_SYMBOL:
      case D_SPECIAL_SYMBOLS:
      case D_URI:
      case D_NL:
      case D_SPACE:
      case D_WORD:
      case D_SPECIAL_SYMBOL:{
        ;
        break;
        }
      default:
        jj_la1[23] = jj_gen;
        break label_1;
      }
      docElements();
    }
    jj_consume_token(0);
fContext.endDocument();
  }

  final public void docElements() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_HEADER:
    case D_HEADER:{
      header();
      break;
      }
    case I_TABLE_ROW:
    case D_TABLE_ROW:{
      table();
      break;
      }
    case I_LIST_ITEM:
    case D_LIST_ITEM:{
      list();
      break;
      }
    case I_VERBATIM_BLOCK:
    case D_VERBATIM_BLOCK:{
      verbatimBlock();
      break;
      }
    case I_MACRO_BLOCK_START:
    case I_MACRO_EMPTY_BLOCK:
    case D_MACRO_BLOCK_START:
    case D_MACRO_EMPTY_BLOCK:{
      macroBlock();
      break;
      }
    case I_HORLINE:
    case D_HORLINE:{
      horline();
      break;
      }
    case I_TABLE_CELL:
    case I_VERBATIM_INLINE:
    case I_REFERENCE:
    case I_QUOT_BLOCK:
    case I_QUOT_BLOCK_MACRO:
    case I_BR:
    case I_MACRO_INLINE_START:
    case I_MACRO_EMPTY_INLINE:
    case I_ESCAPED:
    case I_FORMAT_SYMBOL:
    case I_SPECIAL_SYMBOLS:
    case I_URI:
    case I_SPACE:
    case I_WORD:
    case I_SPECIAL_SYMBOL:
    case D_TABLE_CELL:
    case D_VERBATIM_INLINE:
    case D_REFERENCE:
    case D_QUOT_BLOCK:
    case D_QUOT_BLOCK_MACRO:
    case D_BR:
    case D_MACRO_INLINE_START:
    case D_MACRO_EMPTY_INLINE:
    case D_ESCAPED:
    case D_FORMAT_SYMBOL:
    case D_SPECIAL_SYMBOLS:
    case D_URI:
    case D_SPACE:
    case D_WORD:
    case D_SPECIAL_SYMBOL:{
      if (jj_2_1(2)) {
        quot();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case I_QUOT_BLOCK_MACRO:
        case D_QUOT_BLOCK_MACRO:{
          quotMacro();
          break;
          }
        case I_TABLE_CELL:
        case I_VERBATIM_INLINE:
        case I_REFERENCE:
        case I_BR:
        case I_MACRO_INLINE_START:
        case I_MACRO_EMPTY_INLINE:
        case I_ESCAPED:
        case I_FORMAT_SYMBOL:
        case I_SPECIAL_SYMBOLS:
        case I_URI:
        case I_SPACE:
        case I_WORD:
        case I_SPECIAL_SYMBOL:
        case D_TABLE_CELL:
        case D_VERBATIM_INLINE:
        case D_REFERENCE:
        case D_BR:
        case D_MACRO_INLINE_START:
        case D_MACRO_EMPTY_INLINE:
        case D_ESCAPED:
        case D_FORMAT_SYMBOL:
        case D_SPECIAL_SYMBOLS:
        case D_URI:
        case D_SPACE:
        case D_WORD:
        case D_SPECIAL_SYMBOL:{
          paragraph();
          break;
          }
        default:
          jj_la1[24] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case I_NL:
    case D_NL:{
      emptyParagraph();
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void header() throws ParseException {Token t = null;
    t = getHEADER();
int level = t.image.trim().charAt(1) - '0';
        fContext.beginHeader(level);
    if (jj_2_2(2)) {
      line();
    } else {
      ;
    }
fContext.endHeader();
  }

  final public void table() throws ParseException {Token t = null;
   String str = "";
fContext.beginTable();
    label_2:
    while (true) {
      tableRow();
      if (jj_2_3(2)) {
        ;
      } else {
        break label_2;
      }
    }
fContext.endTable();
  }

  final public void tableRow() throws ParseException {Token t = null;
    String str = null;
    t = getTABLE_ROW();
str = t.image.trim();
        fContext.beginTableRow(str.length() > 1);
        t = null;
    label_3:
    while (true) {
      if (jj_2_4(2)) {
        ;
      } else {
        break label_3;
      }
      block();
    }
fContext.endTableRow();
  }

  final public void list() throws ParseException {
fContext.beginList();
    label_4:
    while (true) {
      listItem();
      if (jj_2_5(2)) {
        ;
      } else {
        break label_4;
      }
    }
fContext.endList();
  }

  final public void listItem() throws ParseException {Token t = null;
    t = getLIST_ITEM();
fContext.beginListItem(t.image.trim());
    if (jj_2_6(2)) {
      lines();
    } else {
      ;
    }
fContext.endListItem();
  }

  final public void block() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_LIST_ITEM:
    case D_LIST_ITEM:{
      list();
      break;
      }
    case I_TABLE_CELL:
    case I_VERBATIM_INLINE:
    case I_REFERENCE:
    case I_BR:
    case I_MACRO_INLINE_START:
    case I_MACRO_EMPTY_INLINE:
    case I_ESCAPED:
    case I_FORMAT_SYMBOL:
    case I_SPECIAL_SYMBOLS:
    case I_URI:
    case I_SPACE:
    case I_WORD:
    case I_SPECIAL_SYMBOL:
    case D_TABLE_CELL:
    case D_VERBATIM_INLINE:
    case D_REFERENCE:
    case D_BR:
    case D_MACRO_INLINE_START:
    case D_MACRO_EMPTY_INLINE:
    case D_ESCAPED:
    case D_FORMAT_SYMBOL:
    case D_SPECIAL_SYMBOLS:
    case D_URI:
    case D_SPACE:
    case D_WORD:
    case D_SPECIAL_SYMBOL:{
      lines();
      break;
      }
    case I_VERBATIM_BLOCK:
    case D_VERBATIM_BLOCK:{
      verbatimBlock();
      break;
      }
    case I_MACRO_BLOCK_START:
    case I_MACRO_EMPTY_BLOCK:
    case D_MACRO_BLOCK_START:
    case D_MACRO_EMPTY_BLOCK:{
      macroBlock();
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void multilineBlock() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_TABLE_CELL:
    case I_VERBATIM_INLINE:
    case I_REFERENCE:
    case I_BR:
    case I_MACRO_INLINE_START:
    case I_MACRO_EMPTY_INLINE:
    case I_ESCAPED:
    case I_FORMAT_SYMBOL:
    case I_SPECIAL_SYMBOLS:
    case I_URI:
    case I_SPACE:
    case I_WORD:
    case I_SPECIAL_SYMBOL:
    case D_TABLE_CELL:
    case D_VERBATIM_INLINE:
    case D_REFERENCE:
    case D_BR:
    case D_MACRO_INLINE_START:
    case D_MACRO_EMPTY_INLINE:
    case D_ESCAPED:
    case D_FORMAT_SYMBOL:
    case D_SPECIAL_SYMBOLS:
    case D_URI:
    case D_SPACE:
    case D_WORD:
    case D_SPECIAL_SYMBOL:{
      lines();
      break;
      }
    case I_VERBATIM_BLOCK:
    case D_VERBATIM_BLOCK:{
      verbatimBlock();
      break;
      }
    case I_MACRO_BLOCK_START:
    case I_MACRO_EMPTY_BLOCK:
    case D_MACRO_BLOCK_START:
    case D_MACRO_EMPTY_BLOCK:{
      macroBlock();
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void verbatimBlock() throws ParseException {Token t = null;
    t = getVERBATIM_BLOCK();
String str = t.image.trim();
        str = str.substring(3, str.length() - 3);
        fContext.onVerbatim(str,  false);
  }

  final public void macroBlock() throws ParseException {Token t = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case I_MACRO_EMPTY_BLOCK:
    case D_MACRO_EMPTY_BLOCK:{
      t = getMACRO_EMPTY_BLOCK();
emptyMacro(t, true);
      break;
      }
    case I_MACRO_BLOCK_START:
    case D_MACRO_BLOCK_START:{
      t = getMACRO_BLOCK_START();
macro(t, true);
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void emptyMacro(Token t, boolean block) throws ParseException {
String[] array = splitMacroParams(t.image);
        String name = array[0];
        String paramStr = array[1];
        String str = "";
        WikiParameters params = newMacroParameters(paramStr);
        if (block) {
            fContext.onMacroBlock(name, params, str);
        } else {
            fContext.onMacroInline(name, params, str);
        }
  }

  final public void macro(Token t, boolean block) throws ParseException {StringBuffer buf = new StringBuffer();
    String name = "";
    WikiParameters params;
    String paramStr = "";
    int paramStrPos = -1;
    String str = null;
    boolean macro = false;
    String prevEnd = null;
String[] array = splitMacroParams(t.image);
        name = array[0];
        paramStr = array[1];
        str = "";
    label_5:
    while (true) {
      if (jj_2_7(2)) {
        ;
      } else {
        break label_5;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case INTERNAL_MACRO:{
        t = getINTERNAL_MACRO();
macro = true;
        break;
        }
      case INTERNAL_MACRO_CONTENT:{
        t = getINTERNAL_MACRO_CONTENT();
macro = false;
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (prevEnd != null) {
                if (block) {
                    buf.append(prevEnd);
                } else {
                    buf.append(WikiScannerUtil.unescape(prevEnd));
                }
            }
                prevEnd = t.image;
    }
str = buf.toString();
        params = newMacroParameters(paramStr);
        if (!fNoformatAsMacro && "noformat".equals(name)) {
                params = params.addParameter("type", name);
                fContext.onVerbatim(str, !block, params);
        } else if (block) {
            fContext.onMacroBlock(name, params, str);
        } else {
            fContext.onMacroInline(name, params, str);
        }
  }

  final public void horline() throws ParseException {Token t = null;
    t = getHORLINE();
fContext.onHorizontalLine();
  }

  final public void paragraph() throws ParseException {Token t = null;
    String str = "";
fContext.beginParagraph();
    lines();
fContext.endParagraph();
  }

  final public void quot() throws ParseException {Token t = null;
    String str = "";
    WikiParameters params = WikiParameters.EMPTY;
    t = getQUOT_BLOCK();
str = t.image.trim();
        fContext.beginQuot(params);
    quotLines();
fContext.endQuot();
  }

  final public void quotMacro() throws ParseException {Token t = null;
    t = getQUOT_BLOCK_MACRO();
String[] array = splitMacroParams(t.image);
        String paramStr = array[1];
        WikiParameters params = newMacroParameters(paramStr);
        fContext.beginQuot(params);
    quotLines();
    if (jj_2_8(2)) {
      getQUOT_BLOCK_MACRO();
    } else {
      ;
    }
fContext.endQuot();
  }

  final public void quotLines() throws ParseException {
    if (jj_2_10(2)) {
fContext.beginQuotLine(1);
      line();
fContext.endQuotLine();
      label_6:
      while (true) {
        if (jj_2_9(2)) {
          ;
        } else {
          break label_6;
        }
        newLine();
fContext.beginQuotLine(1);
        line();
fContext.endQuotLine();
      }
    } else {
      ;
    }
  }

  final public void emptyParagraph() throws ParseException {
    getNL();
    label_7:
    while (true) {
      if (jj_2_11(2)) {
        ;
      } else {
        break label_7;
      }
      getNL();
    }
  }

  final public void lines() throws ParseException {
    line();
    label_8:
    while (true) {
      if (jj_2_12(2)) {
        ;
      } else {
        break label_8;
      }
      newLine();
      line();
    }
  }

  final public void newLine() throws ParseException {
    getNL();
fContext.onNewLine();
  }

  final public void line() throws ParseException {Token t = null;
    String str = null;
    WikiStyle style = null;
    char ch = 0;
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case I_BR:
      case D_BR:{
        t = getBR();
fContext.onLineBreak();
        break;
        }
      case I_ESCAPED:
      case D_ESCAPED:{
        t = getESCAPED();
fContext.onEscape("" + t.image.charAt(1));
        break;
        }
      case I_WORD:
      case D_WORD:{
        t = getWORD();
fContext.onWord(t.image);
        break;
        }
      case I_SPACE:
      case D_SPACE:{
        t = getSPACE();
fContext.onSpace(t.image);
        break;
        }
      case I_SPECIAL_SYMBOLS:
      case D_SPECIAL_SYMBOLS:{
        t = getSPECIAL_SYMBOLS();
fContext.onSpecialSymbol(t.image);
        break;
        }
      case I_FORMAT_SYMBOL:
      case D_FORMAT_SYMBOL:{
        t = getFORMAT_SYMBOL();
str = t.image;
                ch = str.charAt(0);
                style = null;
                boolean checkStyleContext = false;
                switch (ch) {
                    case '{':
                    case '}':
                        style  = ConfluenceWikiScannerContext.MONO;
                        break;
                    case '*':
                        style  = ConfluenceWikiScannerContext.STRONG;
                        break;
                    case '_':
                        style  = ConfluenceWikiScannerContext.EM;
                        break;
                    case '?':
                        style  = ConfluenceWikiScannerContext.CITE;
                        break;
                    case '^':
                        style  = ConfluenceWikiScannerContext.SUP;
                        break;
                    case '~':
                        style  = ConfluenceWikiScannerContext.SUB;
                        break;
                    case '+':
                        // Underlined text was explicitly forbidden. 
                        // So replace it by TT.
                        style  = ConfluenceWikiScannerContext.INS;
                        checkStyleContext = true;
                        break;
                    case '-':
                        style  = ConfluenceWikiScannerContext.STRIKE;
                        checkStyleContext = true;
                        break;
                }
                if (checkStyleContext) {
                    InlineState inlineState = fContext.getInlineState();
                    if (fContext.checkFormatStyle(style)
                        || inlineState.check(InlineState.BEGIN)
                        || inlineState.check(InlineState.SPACE)
                        || inlineState.check(InlineState.NEW_LINE)) {
                        fContext.onFormat(style);
                    } else {
                        fContext.onSpecialSymbol(t.image);
                    }
                } else {
                    fContext.onFormat(style);
                }
        break;
        }
      case I_SPECIAL_SYMBOL:
      case D_SPECIAL_SYMBOL:{
        t = getSPECIAL_SYMBOL();
fContext.onSpecialSymbol(t.image);
        break;
        }
      case I_VERBATIM_INLINE:
      case D_VERBATIM_INLINE:{
        t = getVERBATIM_INLINE();
str = t.image.trim();
                str = str.substring(3, str.length() - 3);
                fContext.onVerbatim(str, true);
        break;
        }
      case I_URI:
      case D_URI:{
        t = getURI();
fContext.onWord(t.image);
        break;
        }
      case I_REFERENCE:
      case D_REFERENCE:{
        t = getREFERENCE();
str = t.image.trim();
                WikiReference ref;
                if (str.startsWith("!")) {
                   str = str.substring(1, str.length() - 1);
                   ref = fImageReferenceParser.parse(str);
                   fContext.onImage(ref);
                } else {
                   str = str.substring(1, str.length() - 1);
                   ref = fReferenceParser.parse(str);
                   fContext.onReference(ref);
                }
        break;
        }
      case I_TABLE_CELL:
      case D_TABLE_CELL:{
        t = getTABLE_CELL();
if (fContext.isExplicitInTable()) {
                    str = t.image.trim();
                    fContext.onTableCell(str.length() > 1);
                } else {
                    fContext.onSpecialSymbol(t.image);
                }
        break;
        }
      case I_MACRO_EMPTY_INLINE:
      case D_MACRO_EMPTY_INLINE:{
        t = getMACRO_EMPTY_INLINE();
emptyMacro(t, false);
        break;
        }
      case I_MACRO_INLINE_START:
      case D_MACRO_INLINE_START:{
        t = getMACRO_INLINE_START();
macro(t, false);
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_13(2)) {
        ;
      } else {
        break label_9;
      }
    }
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_3R_43()
 {
    if (jj_scan_token(INTERNAL_MACRO_CONTENT)) return true;
    return false;
  }

  private boolean jj_3R_16()
 {
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3R_34()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) return true;
    }
    return false;
  }

  private boolean jj_3R_60()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) return true;
    }
    return false;
  }

  private boolean jj_3R_53()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) return true;
    }
    return false;
  }

  private boolean jj_3R_14()
 {
    if (jj_3R_41()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_6()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_44()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) return true;
    }
    return false;
  }

  private boolean jj_3R_42()
 {
    if (jj_scan_token(INTERNAL_MACRO)) return true;
    return false;
  }

  private boolean jj_3R_41()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) return true;
    }
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_11()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_9()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_54()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) return true;
    }
    return false;
  }

  private boolean jj_3R_35()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_7()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_16()) {
    jj_scanpos = xsp;
    if (jj_3R_17()) return true;
    }
    return false;
  }

  private boolean jj_3R_36()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) return true;
    }
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_33()
 {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_57()
 {
    Token xsp;
    if (jj_3_5()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_5()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_26()
 {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_32()
 {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_25()
 {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_24()
 {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_31()
 {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_12()
 {
    if (jj_3R_36()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_4()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_23()
 {
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3R_22()
 {
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_10()
 {
    if (jj_3R_34()) return true;
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_12()) return true;
    return false;
  }

  private boolean jj_3R_40()
 {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_21()
 {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_30()
 {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_62()
 {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_29()
 {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) {
    jj_scanpos = xsp;
    if (jj_3R_24()) {
    jj_scanpos = xsp;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) {
    jj_scanpos = xsp;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_61()
 {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_59()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) return true;
    }
    return false;
  }

  private boolean jj_3R_11()
 {
    Token xsp;
    if (jj_3_13()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_13()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_28()
 {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3R_39()
 {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_27()
 {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_58()
 {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_19()
 {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_50()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) return true;
    }
    return false;
  }

  private boolean jj_3R_38()
 {
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_19()) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) return true;
    }
    return false;
  }

  private boolean jj_3R_55()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) return true;
    }
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_56()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) return true;
    }
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3R_15()
 {
    if (jj_3R_11()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_12()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_49()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) return true;
    }
    return false;
  }

  private boolean jj_3R_37()
 {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_63()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) return true;
    }
    return false;
  }

  private boolean jj_3R_13()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_64()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) return true;
    }
    return false;
  }

  private boolean jj_3R_47()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) return true;
    }
    return false;
  }

  private boolean jj_3R_46()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) return true;
    }
    return false;
  }

  private boolean jj_3R_52()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) return true;
    }
    return false;
  }

  private boolean jj_3R_18()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) return true;
    }
    return false;
  }

  private boolean jj_3R_20()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) return true;
    }
    return false;
  }

  private boolean jj_3R_45()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) return true;
    }
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_19()) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3R_51()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) return true;
    }
    return false;
  }

  private boolean jj_3R_17()
 {
    if (jj_3R_43()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ConfluenceWikiScannerTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[31];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x80000,0x100000,0x200000,0x400000,0x800000,0x1000000,0x2000000,0x4000000,0x8000000,0x10000000,0x20000000,0x40000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfff80000,0x36100000,0xfff80000,0xe6b00000,0xe6900000,0xc0000000,0x0,0x26100000,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x400,0x800,0x1000,0x2000,0x4000,0x8000,0x10000,0x20000,0x40000,0x80000,0x100000,0x200000,0x400000,0x800001,0x1000002,0x2000004,0x4000008,0x8000010,0x10000020,0x20000040,0x40000080,0x80000100,0x200,0xffffffff,0xdf9b0bbf,0xffffffff,0xdff35bbf,0xdff34bbf,0x600000,0x0,0xdf930bbf,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x1,0x1,0x1,0x1,0x0,0x0,0x1,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[13];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public ConfluenceWikiScanner(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public ConfluenceWikiScanner(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new ConfluenceWikiScannerTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ConfluenceWikiScanner(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ConfluenceWikiScannerTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
      jj_input_stream = new SimpleCharStream(stream, 1, 1);
   } else {
      jj_input_stream.ReInit(stream, 1, 1);
   }
   if (token_source == null) {
      token_source = new ConfluenceWikiScannerTokenManager(jj_input_stream);
   }

    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ConfluenceWikiScanner(ConfluenceWikiScannerTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ConfluenceWikiScannerTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) {
       return;
    }

    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];

      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }

      for (int[] oldentry : jj_expentries) {
        if (oldentry.length == jj_expentry.length) {
          boolean isMatched = true;

          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              isMatched = false;
              break;
            }

          }
          if (isMatched) {
            jj_expentries.add(jj_expentry);
            break;
          }
        }
      }

      if (pos != 0) {
        jj_lasttokens[(jj_endpos = pos) - 1] = kind;
      }
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[97];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 31; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 97; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 13; i++) {
      try {
        JJCalls p = jj_2_rtns[i];

        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
              case 10: jj_3_11(); break;
              case 11: jj_3_12(); break;
              case 12: jj_3_13(); break;
            }
          }
          p = p.next;
        } while (p != null);

        } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }

    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
